/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.exoplatform;

import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.concurrent.Callable;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Provider;
import org.everrest.core.impl.EverrestConfiguration;
import org.everrest.core.impl.async.AsynchronousJobPool;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityConstants;

@Provider
public class ExoAsynchronousJobPool
extends AsynchronousJobPool
implements ContextResolver<AsynchronousJobPool> {
    public ExoAsynchronousJobPool(EverrestConfiguration config) {
        super(config);
    }

    protected Callable<Object> newCallable(Object resource, Method method, Object[] params) {
        Callable callable = super.newCallable(resource, method, params);
        return (Callable)Proxy.newProxyInstance(callable.getClass().getClassLoader(), callable.getClass().getInterfaces(), (InvocationHandler)new ConversationStateRestoreHandler(callable));
    }

    private static final class ConversationStateRestoreHandler
    implements InvocationHandler {
        private final WeakReference<ConversationState> conversationStateHolder;
        private final Object callable;

        public ConversationStateRestoreHandler(Object callable) {
            this.callable = callable;
            ConversationState current = ConversationState.getCurrent();
            this.conversationStateHolder = new WeakReference<ConversationState>(current);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(Object proxy, Method theMethod, Object[] theParams) throws Throwable {
            if ("call".equals(theMethod.getName())) {
                try {
                    ConversationState saved = (ConversationState)this.conversationStateHolder.get();
                    if (saved == null) {
                        saved = new ConversationState(new Identity(IdentityConstants.ANONIM));
                    }
                    ConversationState.setCurrent((ConversationState)saved);
                    Object object = theMethod.invoke(this.callable, theParams);
                    return object;
                }
                finally {
                    ConversationState.setCurrent(null);
                }
            }
            return theMethod.invoke(this.callable, theParams);
        }
    }
}

