/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.exoplatform;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import javax.inject.Provider;
import org.everrest.core.BaseDependencySupplier;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.PicoContainer;

public class ExoDependencySupplier
extends BaseDependencySupplier {
    public Provider<?> getProvider(Type providerType) {
        if (!(providerType instanceof ParameterizedType)) {
            throw new RuntimeException("Cannot inject provider without type parameter. ");
        }
        Type actualType = ((ParameterizedType)providerType).getActualTypeArguments()[0];
        return this.getProvider(ExoContainerContext.getCurrentContainer(), actualType);
    }

    private Provider<?> getProvider(final ExoContainer container, Type entryType) {
        ComponentAdapter cadapter;
        List injectionProviders = container.getComponentInstancesOfType(Provider.class);
        if (injectionProviders != null && !injectionProviders.isEmpty()) {
            for (Provider provider : injectionProviders) {
                try {
                    Type injectedType = provider.getClass().getMethod("get", new Class[0]).getGenericReturnType();
                    if (!entryType.equals(injectedType)) continue;
                    return provider;
                }
                catch (NoSuchMethodException ignored) {
                }
            }
        }
        if (entryType instanceof Class && (cadapter = container.getComponentAdapterOfType((Class)entryType)) != null) {
            return new Provider<Object>(){

                public Object get() {
                    return cadapter.getComponentInstance((PicoContainer)container);
                }
            };
        }
        return null;
    }

    public Object getComponent(Class<?> type) {
        Provider<?> provider = this.getProvider(ExoContainerContext.getCurrentContainer(), type);
        if (provider != null) {
            return provider.get();
        }
        return null;
    }
}

