/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.exoplatform;

import java.util.List;
import javax.inject.Provider;
import javax.ws.rs.WebApplicationException;
import org.everrest.core.ApplicationContext;
import org.everrest.core.GenericContainerRequest;
import org.everrest.core.GenericContainerResponse;
import org.everrest.core.ObjectFactory;
import org.everrest.core.RequestFilter;
import org.everrest.core.ResourceBinder;
import org.everrest.core.impl.ApplicationContextImpl;
import org.everrest.core.impl.ProviderBinder;
import org.everrest.core.impl.RequestDispatcher;
import org.everrest.core.resource.AbstractResourceDescriptor;
import org.everrest.exoplatform.ApplicationResource;
import org.everrest.exoplatform.ProvidersRegistry;
import org.everrest.exoplatform.container.RestfulComponentAdapter;
import org.everrest.exoplatform.container.RestfulContainer;
import org.exoplatform.container.ExoContainerContext;

public final class ExoRequestDispatcher
extends RequestDispatcher {
    private final ProvidersRegistry providersRegistry;

    public ExoRequestDispatcher(ResourceBinder resourceBinder, ProvidersRegistry providersRegistry) {
        super(resourceBinder);
        this.providersRegistry = providersRegistry;
    }

    public void dispatch(GenericContainerRequest request, GenericContainerResponse response) {
        String appName;
        ProviderBinder appProviders;
        ApplicationContext context = ApplicationContextImpl.getCurrent();
        String requestPath = context.getPath(false);
        List parameterValues = context.getParameterValues();
        ObjectFactory<AbstractResourceDescriptor> resourceFactory = this.getRootResource(parameterValues, requestPath);
        AbstractResourceDescriptor resourceDescriptor = (AbstractResourceDescriptor)resourceFactory.getObjectModel();
        if (resourceDescriptor instanceof ApplicationResource && (appProviders = this.providersRegistry.getProviders(appName = ((ApplicationResource)resourceDescriptor).getApplicationName())) != null) {
            ((ApplicationContextImpl)context).setProviders(appProviders);
            for (ObjectFactory factory : context.getProviders().getRequestFilters(context.getPath())) {
                ((RequestFilter)factory.getInstance(context)).doFilter(request);
            }
        }
        String newRequestPath = ExoRequestDispatcher.getPathTail((List)parameterValues);
        context.addMatchedURI(requestPath.substring(0, requestPath.lastIndexOf(newRequestPath)));
        context.setParameterNames(((AbstractResourceDescriptor)resourceFactory.getObjectModel()).getUriPattern().getParameterNames());
        Object resource = resourceFactory.getInstance(context);
        this.dispatch(request, response, context, resourceFactory, resource, newRequestPath);
    }

    protected ObjectFactory<AbstractResourceDescriptor> getRootResource(List<String> parameterValues, String requestPath) {
        ObjectFactory resource;
        try {
            resource = super.getRootResource(parameterValues, requestPath);
        }
        catch (WebApplicationException wae) {
            RestfulComponentAdapter resourceAdapter;
            RestfulContainer container;
            Provider provider;
            if (404 == wae.getResponse().getStatus() && null != (provider = (Provider)ExoContainerContext.getCurrentContainer().getComponentInstance((Object)"RestfulContainerProvider")) && null != (container = (RestfulContainer)((Object)provider.get())) && null != (resourceAdapter = (RestfulComponentAdapter)container.getMatchedResource(requestPath, parameterValues))) {
                return resourceAdapter.getFactory();
            }
            throw wae;
        }
        return resource;
    }
}

