/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.exoplatform.container;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import javax.ws.rs.Path;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.everrest.core.impl.header.MediaTypeHelper;
import org.everrest.core.provider.ProviderDescriptor;
import org.everrest.core.resource.AbstractResourceDescriptor;
import org.everrest.core.uri.UriPattern;
import org.everrest.exoplatform.container.ComponentFilter;
import org.everrest.exoplatform.container.RestfulComponentAdapter;
import org.everrest.exoplatform.container.RestfulContainer;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.defaults.AbstractPicoVisitor;

abstract class ComponentsFinder
extends AbstractPicoVisitor {
    private static final Set<ComponentFilter> COMPONENT_FILTERS = new LinkedHashSet<ComponentFilter>();
    final Class<? extends Annotation> annotation;

    static List<ComponentAdapter> withFilters(List<ComponentAdapter> source) {
        if (source.size() == 0 || COMPONENT_FILTERS.size() == 0) {
            return source;
        }
        ArrayList<ComponentAdapter> result = new ArrayList<ComponentAdapter>();
        for (ComponentAdapter component : source) {
            for (ComponentFilter f : COMPONENT_FILTERS) {
                if (!f.accept(component)) continue;
                result.add(component);
            }
        }
        return result;
    }

    ComponentsFinder(Class<? extends Annotation> annotation) {
        this.annotation = annotation;
    }

    public final void visitComponentAdapter(ComponentAdapter componentAdapter) {
        this.checkTraversal();
    }

    public final void visitParameter(Parameter parameter) {
        this.checkTraversal();
    }

    static ComponentAdapter findResource(PicoContainer pico, String requestPath, List<String> parameterValues) {
        return (ComponentAdapter)new ResourceFinder(Path.class, requestPath, parameterValues).traverse(pico);
    }

    static <T> MessageBodyWriter<T> findWriter(PicoContainer pico, Class<T> entityType, Type genericEntityType, Annotation[] annotations, MediaType mediaType) {
        return (MessageBodyWriter)new WriterFinder<T>(Provider.class, entityType, genericEntityType, annotations, mediaType).traverse(pico);
    }

    static <T> MessageBodyReader<T> findReader(PicoContainer pico, Class<T> entityType, Type genericEntityType, Annotation[] annotations, MediaType mediaType) {
        return (MessageBodyReader)new ReaderFinder<T>(Provider.class, entityType, genericEntityType, annotations, mediaType).traverse(pico);
    }

    static <T extends Throwable> ExceptionMapper<T> findExceptionMapper(PicoContainer pico, Class<T> exceptionType) {
        return (ExceptionMapper)new ExceptionMapperFinder<T>(Provider.class, exceptionType).traverse(pico);
    }

    static <T> ContextResolver<T> findContextResolver(PicoContainer pico, Class<T> contextType, MediaType mediaType) {
        return (ContextResolver)new ContextResolverFinder<T>(Provider.class, contextType, mediaType).traverse(pico);
    }

    static {
        for (ComponentFilter f : ServiceLoader.load(ComponentFilter.class)) {
            COMPONENT_FILTERS.add(f);
        }
    }

    static final class ContextResolverFinder<T>
    extends ComponentsFinder {
        private final Class<T> contextType;
        private final MediaType mediaType;
        private final List<ComponentAdapter> components = new ArrayList<ComponentAdapter>();

        ContextResolverFinder(Class<? extends Annotation> annotation, Class<T> contextType, MediaType mediaType) {
            super(annotation);
            this.contextType = contextType;
            this.mediaType = mediaType;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object traverse(Object container) {
            this.components.clear();
            try {
                super.traverse(container);
                MediaTypeHelper.MediaTypeRange mediaTypeRange = new MediaTypeHelper.MediaTypeRange(this.mediaType);
                while (mediaTypeRange.hasNext()) {
                    MediaType next = mediaTypeRange.next();
                    for (ComponentAdapter adapter : this.components) {
                        ParameterizedType[] implementedInterfaces;
                        ProviderDescriptor provider;
                        if (!(adapter instanceof RestfulComponentAdapter) || !(provider = (ProviderDescriptor)((RestfulComponentAdapter)adapter).getObjectModel()).produces().contains(next)) continue;
                        for (ParameterizedType genericInterface : implementedInterfaces = ((RestfulComponentAdapter)adapter).getImplementedInterfaces()) {
                            Class actualType;
                            Type rawType = genericInterface.getRawType();
                            try {
                                actualType = (Class)genericInterface.getActualTypeArguments()[0];
                            }
                            catch (ClassCastException e) {
                                continue;
                            }
                            if (ContextResolver.class != rawType || !this.contextType.isAssignableFrom(actualType)) continue;
                            Object object = adapter.getComponentInstance((PicoContainer)container);
                            return object;
                        }
                    }
                }
                Object var3_3 = null;
                return var3_3;
            }
            finally {
                this.components.clear();
            }
        }

        public void visitContainer(PicoContainer pico) {
            this.checkTraversal();
            this.components.addAll(ContextResolverFinder.withFilters(((RestfulContainer)pico).getComponentAdaptersOfType(ContextResolver.class, this.annotation)));
        }
    }

    static final class ExceptionMapperFinder<T>
    extends ComponentsFinder {
        private final Class<T> exceptionType;
        private final List<ComponentAdapter> components = new ArrayList<ComponentAdapter>();

        ExceptionMapperFinder(Class<? extends Annotation> annotation, Class<T> exceptionType) {
            super(annotation);
            this.exceptionType = exceptionType;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object traverse(Object container) {
            this.components.clear();
            try {
                super.traverse(container);
                for (ComponentAdapter adapter : this.components) {
                    ParameterizedType[] implementedInterfaces;
                    if (!(adapter instanceof RestfulComponentAdapter)) continue;
                    for (ParameterizedType genericInterface : implementedInterfaces = ((RestfulComponentAdapter)adapter).getImplementedInterfaces()) {
                        if (ExceptionMapper.class != genericInterface.getRawType() || this.exceptionType != genericInterface.getActualTypeArguments()[0]) continue;
                        Object object = adapter.getComponentInstance((PicoContainer)container);
                        return object;
                    }
                }
                Iterator<ComponentAdapter> iterator = null;
                return iterator;
            }
            finally {
                this.components.clear();
            }
        }

        public void visitContainer(PicoContainer pico) {
            this.checkTraversal();
            this.components.addAll(ExceptionMapperFinder.withFilters(((RestfulContainer)pico).getComponentAdaptersOfType(ExceptionMapper.class, this.annotation)));
        }
    }

    static final class ReaderFinder<T>
    extends ComponentsFinder {
        private final Class<T> entityType;
        private final Type genericEntityType;
        private final MediaType mediaType;
        private final Annotation[] annotations;
        private final List<ComponentAdapter> components = new ArrayList<ComponentAdapter>();

        ReaderFinder(Class<? extends Annotation> annotation, Class<T> entityType, Type genericEntityType, Annotation[] annotations, MediaType mediaType) {
            super(annotation);
            this.entityType = entityType;
            this.genericEntityType = genericEntityType;
            this.annotations = annotations;
            this.mediaType = mediaType;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object traverse(Object container) {
            this.components.clear();
            try {
                super.traverse(container);
                MediaTypeHelper.MediaTypeRange mediaTypeRange = new MediaTypeHelper.MediaTypeRange(this.mediaType);
                while (mediaTypeRange.hasNext()) {
                    MediaType next = mediaTypeRange.next();
                    for (ComponentAdapter adapter : this.components) {
                        MessageBodyReader reader;
                        ProviderDescriptor provider;
                        if (!(adapter instanceof RestfulComponentAdapter) || !(provider = (ProviderDescriptor)((RestfulComponentAdapter)adapter).getObjectModel()).consumes().contains(next) || !(reader = (MessageBodyReader)adapter.getComponentInstance((PicoContainer)container)).isReadable(this.entityType, this.genericEntityType, this.annotations, next)) continue;
                        MessageBodyReader messageBodyReader = reader;
                        return messageBodyReader;
                    }
                }
                Object var3_3 = null;
                return var3_3;
            }
            finally {
                this.components.clear();
            }
        }

        public void visitContainer(PicoContainer pico) {
            this.checkTraversal();
            this.components.addAll(ReaderFinder.withFilters(((RestfulContainer)pico).getComponentAdaptersOfType(MessageBodyReader.class, this.annotation)));
        }
    }

    static final class WriterFinder<T>
    extends ComponentsFinder {
        private final Class<T> entityType;
        private final Type genericEntityType;
        private final MediaType mediaType;
        private final Annotation[] annotations;
        private final List<ComponentAdapter> components = new ArrayList<ComponentAdapter>();

        WriterFinder(Class<? extends Annotation> annotation, Class<T> entityType, Type genericEntityType, Annotation[] annotations, MediaType mediaType) {
            super(annotation);
            this.entityType = entityType;
            this.genericEntityType = genericEntityType;
            this.annotations = annotations;
            this.mediaType = mediaType;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object traverse(Object container) {
            this.components.clear();
            try {
                super.traverse(container);
                MediaTypeHelper.MediaTypeRange mediaTypeRange = new MediaTypeHelper.MediaTypeRange(this.mediaType);
                while (mediaTypeRange.hasNext()) {
                    MediaType next = mediaTypeRange.next();
                    for (ComponentAdapter adapter : this.components) {
                        MessageBodyWriter writer;
                        ProviderDescriptor provider;
                        if (!(adapter instanceof RestfulComponentAdapter) || !(provider = (ProviderDescriptor)((RestfulComponentAdapter)adapter).getObjectModel()).produces().contains(next) || !(writer = (MessageBodyWriter)adapter.getComponentInstance((PicoContainer)container)).isWriteable(this.entityType, this.genericEntityType, this.annotations, next)) continue;
                        MessageBodyWriter messageBodyWriter = writer;
                        return messageBodyWriter;
                    }
                }
                Object var3_3 = null;
                return var3_3;
            }
            finally {
                this.components.clear();
            }
        }

        public void visitContainer(PicoContainer pico) {
            this.checkTraversal();
            this.components.addAll(WriterFinder.withFilters(((RestfulContainer)pico).getComponentAdaptersOfType(MessageBodyWriter.class, this.annotation)));
        }
    }

    static final class ResourceFinder
    extends ComponentsFinder {
        private final String requestPath;
        private final List<String> parameterValues;
        private final List<ComponentAdapter> components = new ArrayList<ComponentAdapter>();

        ResourceFinder(Class<? extends Annotation> annotation, String requestPath, List<String> parameterValues) {
            super(annotation);
            this.requestPath = requestPath;
            this.parameterValues = parameterValues;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object traverse(Object container) {
            this.components.clear();
            try {
                super.traverse(container);
                HashMap<UriPattern, ComponentAdapter> matched = new HashMap<UriPattern, ComponentAdapter>();
                for (ComponentAdapter adapter : this.components) {
                    String tail;
                    AbstractResourceDescriptor resource;
                    if (!(adapter instanceof RestfulComponentAdapter) || !(resource = (AbstractResourceDescriptor)((RestfulComponentAdapter)adapter).getObjectModel()).getUriPattern().match(this.requestPath, this.parameterValues) || (tail = this.parameterValues.get(this.parameterValues.size() - 1)) != null && !"/".equals(tail) && resource.getSubResourceMethods().size() + resource.getSubResourceLocators().size() <= 0) continue;
                    matched.put(resource.getUriPattern(), adapter);
                }
                if (matched.isEmpty()) {
                    Iterator<ComponentAdapter> iterator = null;
                    return iterator;
                }
                if (matched.size() == 1) {
                    ComponentAdapter adapter;
                    ComponentAdapter componentAdapter = (ComponentAdapter)matched.values().iterator().next();
                    matched.clear();
                    adapter = componentAdapter;
                    return adapter;
                }
                UriPattern[] keys = matched.keySet().toArray(new UriPattern[matched.size()]);
                Arrays.sort(keys, UriPattern.URIPATTERN_COMPARATOR);
                ComponentAdapter componentAdapter = (ComponentAdapter)matched.get(keys[0]);
                matched.clear();
                ComponentAdapter componentAdapter2 = componentAdapter;
                return componentAdapter2;
            }
            finally {
                this.components.clear();
            }
        }

        public void visitContainer(PicoContainer pico) {
            this.checkTraversal();
            this.components.addAll(ResourceFinder.withFilters(((RestfulContainer)pico).getComponentAdapters(this.annotation)));
        }
    }
}

