/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.exoplatform.servlet;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.everrest.core.ContainerResponseWriter;
import org.everrest.core.GenericContainerRequest;
import org.everrest.core.GenericContainerResponse;
import org.everrest.core.RequestHandler;
import org.everrest.core.UnhandledException;
import org.everrest.core.impl.ContainerResponse;
import org.everrest.core.impl.EnvironmentContext;
import org.everrest.core.servlet.ServletContainerRequest;
import org.everrest.core.servlet.ServletContainerResponseWriter;
import org.everrest.core.tools.WebApplicationDeclaredRoles;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.web.AbstractHttpServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EverrestExoServlet
extends AbstractHttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(EverrestExoServlet.class);
    private WebApplicationDeclaredRoles webApplicationRoles;

    protected void afterInit(ServletConfig config) throws ServletException {
        this.webApplicationRoles = new WebApplicationDeclaredRoles(this.getServletContext());
    }

    protected void onService(ExoContainer container, HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        block9: {
            RequestLifeCycle.begin((ExoContainer)container);
            RequestHandler requestHandler = (RequestHandler)container.getComponentInstanceOfType(RequestHandler.class);
            EnvironmentContext env = new EnvironmentContext();
            env.put(HttpServletRequest.class, (Object)req);
            env.put(HttpServletResponse.class, (Object)res);
            env.put(ServletConfig.class, (Object)this.config);
            env.put(ServletContext.class, (Object)this.getServletContext());
            env.put(WebApplicationDeclaredRoles.class, (Object)this.webApplicationRoles);
            try {
                EnvironmentContext.setCurrent((EnvironmentContext)env);
                ServletContainerRequest request = ServletContainerRequest.create((HttpServletRequest)req);
                ContainerResponse response = new ContainerResponse((ContainerResponseWriter)new ServletContainerResponseWriter(res));
                requestHandler.handleRequest((GenericContainerRequest)request, (GenericContainerResponse)response);
            }
            catch (IOException ioe) {
                if (ioe.getClass().getName().equals("org.apache.catalina.connector.ClientAbortException")) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(ioe.getMessage(), (Throwable)ioe);
                    }
                    break block9;
                }
                throw ioe;
            }
            catch (UnhandledException e) {
                throw new ServletException((Throwable)e);
            }
            finally {
                EnvironmentContext.setCurrent(null);
                RequestLifeCycle.end();
            }
        }
    }
}

