/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.exoplatform.container;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import javax.ws.rs.Path;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.everrest.core.ApplicationContext;
import org.everrest.core.BaseDependencySupplier;
import org.everrest.core.DependencySupplier;
import org.everrest.core.Filter;
import org.everrest.core.ObjectFactory;
import org.everrest.core.ObjectModel;
import org.everrest.core.PerRequestObjectFactory;
import org.everrest.core.SingletonObjectFactory;
import org.everrest.core.impl.ApplicationContextImpl;
import org.everrest.core.impl.FilterDescriptorImpl;
import org.everrest.core.impl.provider.ProviderDescriptorImpl;
import org.everrest.core.impl.resource.AbstractResourceDescriptorImpl;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.PicoVisitor;

public class RestfulComponentAdapter
implements ComponentAdapter {
    private final Class<?> clazz;
    private final Object componentKey;
    private final ObjectFactory<ObjectModel> factory;
    private final ParameterizedType[] implementedInterfaces;
    private static final Class[] KNOWN_INTERFACES = new Class[]{MessageBodyReader.class, MessageBodyWriter.class, ExceptionMapper.class, ContextResolver.class};

    public static boolean isRestfulComponent(Object classOrInstance) {
        Class<?> clazz = classOrInstance instanceof Class ? (Class<?>)classOrInstance : classOrInstance.getClass();
        return clazz.isAnnotationPresent(Path.class) || clazz.isAnnotationPresent(Provider.class) || clazz.isAnnotationPresent(Filter.class);
    }

    public RestfulComponentAdapter(Object componentKey, Object classOrInstance) {
        AbstractResourceDescriptorImpl objectModel;
        if (componentKey == null || classOrInstance == null) {
            throw new NullPointerException();
        }
        this.componentKey = componentKey;
        Object instance = null;
        if (classOrInstance instanceof Class) {
            this.clazz = (Class)classOrInstance;
        } else {
            this.clazz = classOrInstance.getClass();
            instance = classOrInstance;
        }
        this.implementedInterfaces = RestfulComponentAdapter.getImplementedInterfaces(this.clazz);
        if (this.clazz.isAnnotationPresent(Path.class)) {
            objectModel = instance == null ? new AbstractResourceDescriptorImpl(this.clazz) : new AbstractResourceDescriptorImpl(instance);
        } else if (this.clazz.isAnnotationPresent(Provider.class)) {
            objectModel = instance == null ? new ProviderDescriptorImpl(this.clazz) : new ProviderDescriptorImpl(instance);
        } else if (this.clazz.isAnnotationPresent(Filter.class)) {
            objectModel = instance == null ? new FilterDescriptorImpl(this.clazz) : new FilterDescriptorImpl(instance);
        } else {
            throw new IllegalArgumentException("Incorrect type or instance " + this.clazz + ". ");
        }
        this.factory = instance == null ? new PerRequestObjectFactory((ObjectModel)objectModel) : new SingletonObjectFactory((ObjectModel)objectModel, instance);
    }

    public ObjectModel getObjectModel() {
        return this.factory.getObjectModel();
    }

    public ObjectFactory<ObjectModel> getFactory() {
        return this.factory;
    }

    ParameterizedType[] getImplementedInterfaces() {
        return this.implementedInterfaces;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getComponentInstance(final PicoContainer container) throws PicoInitializationException, PicoIntrospectionException {
        final ApplicationContext context = ApplicationContextImpl.getCurrent();
        if (context == null) {
            throw new IllegalStateException("ApplicationContext is not initialized. ");
        }
        DependencySupplier dependencies = context.getDependencySupplier();
        try {
            context.setDependencySupplier((DependencySupplier)new BaseDependencySupplier(){

                public Object getComponent(Class<?> type) {
                    Object object = container.getComponentInstanceOfType(type);
                    if (object != null) {
                        return object;
                    }
                    DependencySupplier contextDependencySupplier = context.getDependencySupplier();
                    if (contextDependencySupplier != null) {
                        return contextDependencySupplier.getComponent(type);
                    }
                    return null;
                }
            });
            Object object = this.factory.getInstance(context);
            return object;
        }
        finally {
            context.setDependencySupplier(dependencies);
        }
    }

    public void verify(PicoContainer container) throws PicoIntrospectionException {
    }

    public void accept(PicoVisitor visitor) {
        visitor.visitComponentAdapter((ComponentAdapter)this);
    }

    public Object getComponentKey() {
        return this.componentKey;
    }

    public Class getComponentImplementation() {
        return this.clazz;
    }

    public String toString() {
        return "RestfulComponentAdapter [" + this.getComponentKey() + "]";
    }

    private static ParameterizedType[] getImplementedInterfaces(Class<?> type) {
        if (type.isAnnotationPresent(Provider.class)) {
            ArrayList<ParameterizedType> implementedInterfaces = new ArrayList<ParameterizedType>();
            for (int i = 0; i < KNOWN_INTERFACES.length; ++i) {
                ParameterizedType impl = RestfulComponentAdapter.getGenericInterface(KNOWN_INTERFACES[i], type);
                if (impl == null) continue;
                implementedInterfaces.add(impl);
            }
            if (implementedInterfaces.size() == 0) {
                throw new IllegalArgumentException("Type " + type + " annotated with @javax.ws.rs.ext.Provider but does not implement any of the interfaces: " + Arrays.toString(KNOWN_INTERFACES));
            }
            return implementedInterfaces.toArray(new ParameterizedType[implementedInterfaces.size()]);
        }
        return new ParameterizedType[0];
    }

    private static ParameterizedType getGenericInterface(Class<?> interfaceType, Class<?> type) {
        for (Type t : type.getGenericInterfaces()) {
            ParameterizedType parameterized;
            if (!(t instanceof ParameterizedType) || interfaceType != (parameterized = (ParameterizedType)t).getRawType()) continue;
            return parameterized;
        }
        Class<?> sc = type.getSuperclass();
        if (sc != null && sc != Object.class) {
            return RestfulComponentAdapter.getGenericInterface(interfaceType, sc);
        }
        return null;
    }
}

