/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.exoplatform.servlet;

import java.net.MalformedURLException;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.ws.rs.core.Application;
import org.everrest.core.DependencySupplier;
import org.everrest.core.ResourceBinder;
import org.everrest.core.impl.ApplicationProviderBinder;
import org.everrest.core.impl.EverrestApplication;
import org.everrest.core.impl.EverrestConfiguration;
import org.everrest.core.impl.EverrestProcessor;
import org.everrest.core.impl.FileCollectorDestroyer;
import org.everrest.core.impl.ProviderBinder;
import org.everrest.core.impl.ResourceBinderImpl;
import org.everrest.core.impl.async.AsynchronousJobPool;
import org.everrest.core.impl.async.AsynchronousJobService;
import org.everrest.core.impl.async.AsynchronousProcessListWriter;
import org.everrest.core.impl.method.filter.SecurityConstraint;
import org.everrest.core.servlet.EverrestServletContextInitializer;
import org.everrest.core.util.Logger;
import org.everrest.exoplatform.ExoDependencySupplier;
import org.everrest.exoplatform.StartableApplication;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.StandaloneContainer;

public abstract class EverrestExoContextListener
implements ServletContextListener {
    public final void contextInitialized(ServletContextEvent sce) {
        ServletContext servletContext = sce.getServletContext();
        EverrestServletContextInitializer everrestInitializer = new EverrestServletContextInitializer(servletContext);
        ResourceBinderImpl resources = new ResourceBinderImpl();
        ApplicationProviderBinder providers = new ApplicationProviderBinder();
        ExoDependencySupplier dependencySupplier = new ExoDependencySupplier();
        EverrestConfiguration config = everrestInitializer.getConfiguration();
        Application application = everrestInitializer.getApplication();
        EverrestApplication everrest = new EverrestApplication();
        if (config.isAsynchronousSupported()) {
            everrest.addResource(config.getAsynchronousServicePath(), AsynchronousJobService.class);
            everrest.addSingleton((Object)new AsynchronousJobPool(config));
            everrest.addSingleton((Object)new AsynchronousProcessListWriter());
        }
        if (config.isCheckSecurity()) {
            everrest.addSingleton((Object)new SecurityConstraint());
        }
        everrest.addApplication(application);
        ExoContainer container = this.getContainer(servletContext);
        if (container != null) {
            StartableApplication startable = (StartableApplication)((Object)container.getComponentInstanceOfType(StartableApplication.class));
            if (startable == null) {
                container.registerComponentImplementation(StartableApplication.class);
                startable = (StartableApplication)((Object)container.getComponentInstanceOfType(StartableApplication.class));
            }
            everrest.addApplication((Application)startable);
        }
        EverrestProcessor processor = new EverrestProcessor((ResourceBinder)resources, (ProviderBinder)providers, (DependencySupplier)dependencySupplier, config, (Application)everrest);
        processor.start();
        servletContext.setAttribute(EverrestConfiguration.class.getName(), (Object)config);
        servletContext.setAttribute(Application.class.getName(), (Object)everrest);
        servletContext.setAttribute(DependencySupplier.class.getName(), (Object)dependencySupplier);
        servletContext.setAttribute(ResourceBinder.class.getName(), (Object)resources);
        servletContext.setAttribute(ApplicationProviderBinder.class.getName(), (Object)providers);
        servletContext.setAttribute(EverrestProcessor.class.getName(), (Object)processor);
    }

    protected abstract ExoContainer getContainer(ServletContext var1);

    public void contextDestroyed(ServletContextEvent sce) {
        this.makeFileCollectorDestroyer().stopFileCollector();
        ServletContext servletContext = sce.getServletContext();
        EverrestProcessor processor = (EverrestProcessor)servletContext.getAttribute(EverrestProcessor.class.getName());
        if (processor != null) {
            processor.stop();
        }
    }

    protected FileCollectorDestroyer makeFileCollectorDestroyer() {
        return new FileCollectorDestroyer();
    }

    public static class StandaloneContainerStarter
    extends EverrestExoContextListener {
        public static final String CONFIGURATION_PATH = "everrest.exoplatform.standalone.config";
        public static final String PREFIX_WAR = "war:";
        private static final Logger LOG = Logger.getLogger(StandaloneContainerStarter.class);
        private StandaloneContainer container;

        @Override
        protected ExoContainer getContainer(ServletContext servletContext) {
            String configurationURL = servletContext.getInitParameter(CONFIGURATION_PATH);
            if (configurationURL != null) {
                if (configurationURL.startsWith(PREFIX_WAR)) {
                    try {
                        configurationURL = servletContext.getResource(configurationURL.substring(PREFIX_WAR.length())).toExternalForm();
                    }
                    catch (MalformedURLException e) {
                        LOG.error("Error of configurationURL read. ", (Throwable)e);
                    }
                }
            } else {
                configurationURL = System.getProperty(CONFIGURATION_PATH);
            }
            try {
                StandaloneContainer.addConfigurationURL((String)configurationURL);
            }
            catch (MalformedURLException e1) {
                try {
                    StandaloneContainer.addConfigurationPath((String)configurationURL);
                }
                catch (MalformedURLException e2) {
                    LOG.error("Error of addConfiguration. ", (Throwable)e2);
                }
            }
            try {
                this.container = StandaloneContainer.getInstance((ClassLoader)Thread.currentThread().getContextClassLoader());
            }
            catch (Exception e) {
                LOG.error("Error of StandaloneContainer initialization. ", (Throwable)e);
            }
            return this.container;
        }

        @Override
        public void contextDestroyed(ServletContextEvent sce) {
            if (this.container != null) {
                this.container.stop();
            }
            super.contextDestroyed(sce);
        }
    }

    public static class DefaultListener
    extends EverrestExoContextListener {
        @Override
        protected ExoContainer getContainer(ServletContext servletContext) {
            return null;
        }
    }
}

