/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.guice;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.ProvisionException;
import javax.servlet.ServletConfig;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Providers;
import org.everrest.core.ApplicationContext;
import org.everrest.core.InitialProperties;
import org.everrest.core.impl.ApplicationContextImpl;
import org.everrest.core.impl.EnvironmentContext;

public class EverrestModule
implements Module {
    public void configure(Binder binder) {
        binder.bind(HttpHeaders.class).toProvider((Provider)new HttpHeadersProvider());
        binder.bind(InitialProperties.class).toProvider((Provider)new InitialPropertiesProvider());
        binder.bind(Providers.class).toProvider((Provider)new ProvidersProvider());
        binder.bind(Request.class).toProvider((Provider)new RequestProvider());
        binder.bind(SecurityContext.class).toProvider((Provider)new SecurityContextProvider());
        binder.bind(ServletConfig.class).toProvider((Provider)new ServletConfigProvider());
        binder.bind(UriInfo.class).toProvider((Provider)new UriInfoProvider());
    }

    public static class UriInfoProvider
    implements Provider<UriInfo> {
        public UriInfo get() {
            ApplicationContext context = ApplicationContextImpl.getCurrent();
            if (context == null) {
                throw new ProvisionException("EverRest ApplicationContext is not initialized.");
            }
            return context.getUriInfo();
        }
    }

    public static class ServletConfigProvider
    implements Provider<ServletConfig> {
        public ServletConfig get() {
            EnvironmentContext context = EnvironmentContext.getCurrent();
            if (context == null) {
                throw new ProvisionException("EverRest EnvironmentContext is not initialized.");
            }
            return (ServletConfig)EnvironmentContext.getCurrent().get(ServletConfig.class);
        }
    }

    public static class SecurityContextProvider
    implements Provider<SecurityContext> {
        public SecurityContext get() {
            ApplicationContext context = ApplicationContextImpl.getCurrent();
            if (context == null) {
                throw new ProvisionException("EverRest ApplicationContext is not initialized.");
            }
            return context.getSecurityContext();
        }
    }

    public static class RequestProvider
    implements Provider<Request> {
        public Request get() {
            ApplicationContext context = ApplicationContextImpl.getCurrent();
            if (context == null) {
                throw new ProvisionException("EverRest ApplicationContext is not initialized.");
            }
            return context.getRequest();
        }
    }

    public static class ProvidersProvider
    implements Provider<Providers> {
        public Providers get() {
            ApplicationContext context = ApplicationContextImpl.getCurrent();
            if (context == null) {
                throw new ProvisionException("EverRest ApplicationContext is not initialized.");
            }
            return context.getProviders();
        }
    }

    public static class InitialPropertiesProvider
    implements Provider<InitialProperties> {
        public InitialProperties get() {
            ApplicationContext context = ApplicationContextImpl.getCurrent();
            if (context == null) {
                throw new ProvisionException("EverRest ApplicationContext is not initialized.");
            }
            return context.getInitialProperties();
        }
    }

    public static class HttpHeadersProvider
    implements Provider<HttpHeaders> {
        public HttpHeaders get() {
            ApplicationContext context = ApplicationContextImpl.getCurrent();
            if (context == null) {
                throw new ProvisionException("EverRest ApplicationContext is not initialized.");
            }
            return context.getHttpHeaders();
        }
    }
}

