/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.guice.servlet;

import com.google.inject.Binding;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.internal.BindingImpl;
import com.google.inject.servlet.GuiceServletContextListener;
import com.google.inject.servlet.ServletModule;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.ws.rs.Path;
import javax.ws.rs.core.Application;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import org.everrest.core.ComponentLifecycleScope;
import org.everrest.core.DependencySupplier;
import org.everrest.core.Filter;
import org.everrest.core.RequestFilter;
import org.everrest.core.ResourceBinder;
import org.everrest.core.ResponseFilter;
import org.everrest.core.impl.ApplicationProviderBinder;
import org.everrest.core.impl.EverrestConfiguration;
import org.everrest.core.impl.EverrestProcessor;
import org.everrest.core.impl.FileCollectorDestroyer;
import org.everrest.core.impl.FilterDescriptorImpl;
import org.everrest.core.impl.ProviderBinder;
import org.everrest.core.impl.ResourceBinderImpl;
import org.everrest.core.impl.provider.ProviderDescriptorImpl;
import org.everrest.core.impl.resource.AbstractResourceDescriptorImpl;
import org.everrest.core.impl.resource.ResourceDescriptorValidator;
import org.everrest.core.method.MethodInvokerFilter;
import org.everrest.core.resource.ResourceDescriptorVisitor;
import org.everrest.core.servlet.EverrestApplication;
import org.everrest.core.servlet.EverrestServletContextInitializer;
import org.everrest.guice.EverrestModule;
import org.everrest.guice.GuiceDependencySupplier;
import org.everrest.guice.GuiceObjectFactory;
import org.everrest.guice.servlet.GuiceEverrestServlet;

public abstract class EverrestGuiceContextListener
extends GuiceServletContextListener {
    protected ResourceBinderImpl resources;
    protected ApplicationProviderBinder providers;

    public final void contextInitialized(ServletContextEvent sce) {
        super.contextInitialized(sce);
        ServletContext servletContext = sce.getServletContext();
        EverrestServletContextInitializer everrestInitializer = new EverrestServletContextInitializer(servletContext);
        this.resources = new ResourceBinderImpl();
        this.providers = new ApplicationProviderBinder();
        Injector injector = this.getInjector(servletContext);
        GuiceDependencySupplier dependencySupplier = new GuiceDependencySupplier(injector);
        EverrestConfiguration config = everrestInitializer.getConfiguration();
        Application application = everrestInitializer.getApplication();
        EverrestApplication everrest = new EverrestApplication(config);
        everrest.addApplication(application);
        EverrestProcessor processor = new EverrestProcessor((ResourceBinder)this.resources, (ProviderBinder)this.providers, (DependencySupplier)dependencySupplier, config, (Application)everrest);
        processor.start();
        servletContext.setAttribute(EverrestConfiguration.class.getName(), (Object)config);
        servletContext.setAttribute(DependencySupplier.class.getName(), (Object)dependencySupplier);
        servletContext.setAttribute(ResourceBinder.class.getName(), (Object)this.resources);
        servletContext.setAttribute(ApplicationProviderBinder.class.getName(), (Object)this.providers);
        servletContext.setAttribute(EverrestProcessor.class.getName(), (Object)processor);
        this.processBindings(injector);
    }

    public void contextDestroyed(ServletContextEvent sce) {
        this.makeFileCollectorDestroyer().stopFileCollector();
        ServletContext sctx = sce.getServletContext();
        EverrestProcessor processor = (EverrestProcessor)sctx.getAttribute(EverrestProcessor.class.getName());
        if (processor != null) {
            processor.stop();
        }
    }

    protected FileCollectorDestroyer makeFileCollectorDestroyer() {
        return new FileCollectorDestroyer();
    }

    protected final Injector getInjector() {
        return Guice.createInjector(this.createModules());
    }

    private List<Module> createModules() {
        ArrayList<Module> all = new ArrayList<Module>();
        ServletModule servletModule = this.getServletModule();
        if (servletModule != null) {
            all.add((Module)servletModule);
        }
        all.add(new EverrestModule());
        List<Module> modules = this.getModules();
        if (modules != null && modules.size() > 0) {
            all.addAll(modules);
        }
        return all;
    }

    protected abstract List<Module> getModules();

    protected ServletModule getServletModule() {
        return new ServletModule(){

            protected void configureServlets() {
                this.serve("/*", new String[0]).with(GuiceEverrestServlet.class);
            }
        };
    }

    protected Injector getInjector(ServletContext servletContext) {
        return (Injector)servletContext.getAttribute(Injector.class.getName());
    }

    protected void processBindings(Injector injector) {
        ResourceDescriptorValidator rdv = ResourceDescriptorValidator.getInstance();
        for (Binding binding : injector.getBindings().values()) {
            Provider guiceProvider;
            ComponentLifecycleScope lifeCycle;
            Type type = binding.getKey().getTypeLiteral().getType();
            if (!(type instanceof Class)) continue;
            Class clazz = (Class)type;
            ComponentLifecycleScope componentLifecycleScope = lifeCycle = ((BindingImpl)binding).getScoping().isNoScope() ? ComponentLifecycleScope.PER_REQUEST : ComponentLifecycleScope.SINGLETON;
            if (clazz.getAnnotation(javax.ws.rs.ext.Provider.class) != null) {
                ProviderDescriptorImpl pDescriptor = new ProviderDescriptorImpl(clazz, lifeCycle);
                guiceProvider = binding.getProvider();
                pDescriptor.accept((ResourceDescriptorVisitor)rdv);
                if (ContextResolver.class.isAssignableFrom(clazz)) {
                    this.providers.addContextResolver(new GuiceObjectFactory<ProviderDescriptorImpl>(pDescriptor, guiceProvider));
                }
                if (ExceptionMapper.class.isAssignableFrom(clazz)) {
                    this.providers.addExceptionMapper(new GuiceObjectFactory<ProviderDescriptorImpl>(pDescriptor, guiceProvider));
                }
                if (MessageBodyReader.class.isAssignableFrom(clazz)) {
                    this.providers.addMessageBodyReader(new GuiceObjectFactory<ProviderDescriptorImpl>(pDescriptor, guiceProvider));
                }
                if (!MessageBodyWriter.class.isAssignableFrom(clazz)) continue;
                this.providers.addMessageBodyWriter(new GuiceObjectFactory<ProviderDescriptorImpl>(pDescriptor, guiceProvider));
                continue;
            }
            if (clazz.getAnnotation(Filter.class) != null) {
                FilterDescriptorImpl fDescriptor = new FilterDescriptorImpl(clazz, lifeCycle);
                fDescriptor.accept((ResourceDescriptorVisitor)rdv);
                guiceProvider = binding.getProvider();
                if (MethodInvokerFilter.class.isAssignableFrom(clazz)) {
                    this.providers.addMethodInvokerFilter(new GuiceObjectFactory<FilterDescriptorImpl>(fDescriptor, guiceProvider));
                }
                if (RequestFilter.class.isAssignableFrom(clazz)) {
                    this.providers.addRequestFilter(new GuiceObjectFactory<FilterDescriptorImpl>(fDescriptor, guiceProvider));
                }
                if (!ResponseFilter.class.isAssignableFrom(clazz)) continue;
                this.providers.addResponseFilter(new GuiceObjectFactory<FilterDescriptorImpl>(fDescriptor, guiceProvider));
                continue;
            }
            if (clazz.getAnnotation(Path.class) == null) continue;
            AbstractResourceDescriptorImpl rDescriptor = new AbstractResourceDescriptorImpl(clazz, lifeCycle);
            rDescriptor.accept((ResourceDescriptorVisitor)rdv);
            guiceProvider = binding.getProvider();
            this.resources.addResource(new GuiceObjectFactory<AbstractResourceDescriptorImpl>(rDescriptor, guiceProvider));
        }
    }

    public static class DefaultListener
    extends EverrestGuiceContextListener {
        @Override
        protected List<Module> getModules() {
            return Collections.emptyList();
        }
    }
}

