/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.guice;

import com.google.inject.Provider;
import java.util.List;
import org.everrest.core.ApplicationContext;
import org.everrest.core.FieldInjector;
import org.everrest.core.ObjectFactory;
import org.everrest.core.ObjectModel;

public class GuiceObjectFactory<T extends ObjectModel>
implements ObjectFactory<T> {
    protected final T model;
    protected final Provider<?> provider;

    public GuiceObjectFactory(T model, Provider<?> provider) {
        this.model = model;
        this.provider = provider;
    }

    public Object getInstance(ApplicationContext context) {
        Object object = this.provider.get();
        List fieldInjectors = this.model.getFieldInjectors();
        if (fieldInjectors != null && fieldInjectors.size() > 0) {
            for (FieldInjector injector : fieldInjectors) {
                if (injector.getAnnotation() == null) continue;
                injector.inject(object, context);
            }
        }
        return object;
    }

    public T getObjectModel() {
        return this.model;
    }
}

