/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.websockets;

import java.io.IOException;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import javax.websocket.CloseReason;
import org.everrest.websockets.WSConnectionContext;
import org.everrest.websockets.WSConnectionImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WSConnectionTracker
implements HttpSessionListener {
    private static final Logger LOG = LoggerFactory.getLogger(WSConnectionTracker.class);

    public void sessionCreated(HttpSessionEvent se) {
    }

    public void sessionDestroyed(HttpSessionEvent se) {
        String destroyedSessionId = se.getSession().getId();
        for (WSConnectionImpl wsConnection : WSConnectionContext.connections.values()) {
            HttpSession httpSession = wsConnection.getHttpSession();
            if (httpSession == null || !destroyedSessionId.equals(httpSession.getId())) continue;
            try {
                wsConnection.close(CloseReason.CloseCodes.NORMAL_CLOSURE.getCode(), "Http session destroyed");
            }
            catch (IOException e) {
                LOG.warn(String.format("Error occurs while try to close web-socket connection %s. %s", wsConnection, e.getMessage()), (Throwable)e);
            }
        }
    }
}

