/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.websockets.message;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import javax.websocket.CloseReason;
import javax.websocket.EncodeException;
import javax.websocket.RemoteEndpoint;
import javax.websocket.SendHandler;
import javax.websocket.SendResult;
import javax.websocket.Session;
import org.everrest.websockets.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageSender {
    private static final Logger LOG = LoggerFactory.getLogger(MessageSender.class);
    private final int maxNumberOfMessageInQueue = 1000000000;
    private final Session session;
    private final RemoteEndpoint.Async async;
    private final LinkedList<MessageWrapper> sendQueue;
    private final SendHandler sendHandler;
    private final Object lock = new Object();
    private volatile boolean sendingInProgress = false;

    public MessageSender(Session session) {
        this.session = session;
        this.async = session.getAsyncRemote();
        this.sendQueue = new LinkedList();
        this.sendHandler = new MessageSendHandler();
    }

    public void send(Message message) throws IOException, EncodeException {
        this.send(new MessageWrapper(message));
    }

    public void send(String text) throws IOException {
        this.send(new MessageWrapper(text));
    }

    public void send(byte[] bytes) throws IOException {
        this.send(new MessageWrapper(bytes));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send(MessageWrapper message) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.sendingInProgress) {
                if (this.isMaxQueueCapacityExceeded()) {
                    String error = "Max size of message queue exceeded";
                    this.session.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.VIOLATED_POLICY, "Max size of message queue exceeded"));
                    throw new IOException("Max size of message queue exceeded");
                }
                this.sendQueue.add(message);
            } else {
                this.sendingInProgress = true;
                this.doSend(message);
            }
        }
    }

    private boolean isMaxQueueCapacityExceeded() {
        int newSize = this.sendQueue.size() + 1;
        LOG.debug(" SendQueue sieze {} ,  maxNumberOfMessageInQueue {}", (Object)newSize, (Object)1000000000);
        return newSize > 1000000000;
    }

    private void doSend(MessageWrapper messageForSending) {
        if (messageForSending.isText()) {
            this.async.sendText(messageForSending.getText(), this.sendHandler);
        } else if (messageForSending.isBinary()) {
            this.async.sendBinary(messageForSending.getBinary(), this.sendHandler);
        } else if (messageForSending.isMessage()) {
            this.async.sendObject((Object)messageForSending.getMessage(), this.sendHandler);
        }
    }

    private class MessageSendHandler
    implements SendHandler {
        private MessageSendHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onResult(SendResult result) {
            LOG.debug(" SendQueue size {} ,  maxNumberOfMessageInQueue {} result {}", new Object[]{MessageSender.this.sendQueue.size(), 1000000000, result.isOK()});
            if (!result.isOK()) {
                try {
                    MessageSender.this.session.close();
                }
                catch (IOException iOException) {
                }
                finally {
                    MessageSender.this.sendQueue.clear();
                }
            }
            Object object = MessageSender.this.lock;
            synchronized (object) {
                if (MessageSender.this.sendQueue.isEmpty()) {
                    MessageSender.this.sendingInProgress = false;
                } else {
                    MessageWrapper message = (MessageWrapper)MessageSender.this.sendQueue.remove();
                    MessageSender.this.doSend(message);
                }
            }
        }
    }

    private static final class MessageWrapper {
        private final Message message;
        private final byte[] bytes;
        private final String text;

        MessageWrapper(String text) {
            this.text = text;
            this.message = null;
            this.bytes = null;
        }

        MessageWrapper(byte[] bytes) {
            this.bytes = bytes;
            this.message = null;
            this.text = null;
        }

        MessageWrapper(Message message) {
            this.message = message;
            this.bytes = null;
            this.text = null;
        }

        boolean isText() {
            return this.text != null;
        }

        boolean isBinary() {
            return this.bytes != null;
        }

        boolean isMessage() {
            return this.message != null;
        }

        Message getMessage() {
            return this.message;
        }

        ByteBuffer getBinary() {
            return ByteBuffer.wrap(this.bytes);
        }

        String getText() {
            return this.text;
        }
    }
}

