/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.websockets;

import java.security.Principal;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.http.HttpSession;
import javax.websocket.DecodeException;
import javax.websocket.DeploymentException;
import javax.websocket.EncodeException;
import javax.websocket.HandshakeResponse;
import javax.websocket.server.HandshakeRequest;
import javax.websocket.server.ServerContainer;
import javax.websocket.server.ServerEndpointConfig;
import javax.ws.rs.core.SecurityContext;
import org.everrest.core.impl.EverrestConfiguration;
import org.everrest.core.impl.EverrestProcessor;
import org.everrest.core.impl.provider.json.JsonException;
import org.everrest.core.tools.SimplePrincipal;
import org.everrest.core.tools.SimpleSecurityContext;
import org.everrest.core.tools.WebApplicationDeclaredRoles;
import org.everrest.websockets.WSConnectionImpl;
import org.everrest.websockets.message.BaseTextDecoder;
import org.everrest.websockets.message.BaseTextEncoder;
import org.everrest.websockets.message.JsonMessageConverter;
import org.everrest.websockets.message.OutputMessage;
import org.everrest.websockets.message.RestInputMessage;

public class ServerContainerInitializeListener
implements ServletContextListener {
    public static final String EVERREST_PROCESSOR_ATTRIBUTE = EverrestProcessor.class.getName();
    public static final String HTTP_SESSION_ATTRIBUTE = HttpSession.class.getName();
    public static final String EVERREST_CONFIG_ATTRIBUTE = EverrestConfiguration.class.getName();
    public static final String EXECUTOR_ATTRIBUTE = "everrest.Executor";
    public static final String SECURITY_CONTEXT = SecurityContext.class.getName();
    private static final AtomicLong sequence = new AtomicLong(1L);
    private WebApplicationDeclaredRoles webApplicationDeclaredRoles;
    private EverrestConfiguration everrestConfiguration;
    private ServerEndpointConfig serverEndpointConfig;

    public final void contextInitialized(ServletContextEvent sce) {
        ServletContext servletContext = sce.getServletContext();
        this.webApplicationDeclaredRoles = new WebApplicationDeclaredRoles(servletContext);
        this.everrestConfiguration = (EverrestConfiguration)servletContext.getAttribute(EVERREST_CONFIG_ATTRIBUTE);
        if (this.everrestConfiguration == null) {
            this.everrestConfiguration = new EverrestConfiguration();
        }
        ServerContainer serverContainer = (ServerContainer)servletContext.getAttribute("javax.websocket.server.ServerContainer");
        try {
            this.serverEndpointConfig = this.createServerEndpointConfig(servletContext);
            serverContainer.addEndpoint(this.serverEndpointConfig);
        }
        catch (DeploymentException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        ExecutorService executor;
        if (this.serverEndpointConfig != null && (executor = (ExecutorService)this.serverEndpointConfig.getUserProperties().get(EXECUTOR_ATTRIBUTE)) != null) {
            executor.shutdownNow();
        }
    }

    protected ServerEndpointConfig createServerEndpointConfig(ServletContext servletContext) {
        LinkedList<Class<OutputMessageEncoder>> encoders = new LinkedList<Class<OutputMessageEncoder>>();
        LinkedList<Class<InputMessageDecoder>> decoders = new LinkedList<Class<InputMessageDecoder>>();
        encoders.add(OutputMessageEncoder.class);
        decoders.add(InputMessageDecoder.class);
        ServerEndpointConfig endpointConfig = ServerEndpointConfig.Builder.create(WSConnectionImpl.class, (String)"/ws").configurator(this.createConfigurator()).encoders(encoders).decoders(decoders).build();
        endpointConfig.getUserProperties().put(EVERREST_PROCESSOR_ATTRIBUTE, this.getEverrestProcessor(servletContext));
        endpointConfig.getUserProperties().put(EVERREST_CONFIG_ATTRIBUTE, this.getEverrestConfiguration(servletContext));
        endpointConfig.getUserProperties().put(EXECUTOR_ATTRIBUTE, this.createExecutor(servletContext));
        return endpointConfig;
    }

    private ServerEndpointConfig.Configurator createConfigurator() {
        return new ServerEndpointConfig.Configurator(){

            public void modifyHandshake(ServerEndpointConfig sec, HandshakeRequest request, HandshakeResponse response) {
                super.modifyHandshake(sec, request, response);
                HttpSession httpSession = (HttpSession)request.getHttpSession();
                if (httpSession != null) {
                    sec.getUserProperties().put(HTTP_SESSION_ATTRIBUTE, httpSession);
                }
                SecurityContext securityContext = ServerContainerInitializeListener.this.createSecurityContext(request);
                sec.getUserProperties().put(SECURITY_CONTEXT, securityContext);
            }
        };
    }

    protected EverrestProcessor getEverrestProcessor(ServletContext servletContext) {
        return (EverrestProcessor)servletContext.getAttribute(EVERREST_PROCESSOR_ATTRIBUTE);
    }

    protected EverrestConfiguration getEverrestConfiguration(ServletContext servletContext) {
        return this.everrestConfiguration;
    }

    protected ExecutorService createExecutor(ServletContext servletContext) {
        EverrestConfiguration everrestConfiguration = this.getEverrestConfiguration(servletContext);
        return Executors.newFixedThreadPool(everrestConfiguration.getAsynchronousPoolSize(), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "everrest.WSConnection" + sequence.getAndIncrement());
                t.setDaemon(true);
                return t;
            }
        });
    }

    protected SecurityContext createSecurityContext(HandshakeRequest req) {
        boolean isSecure = false;
        Principal principal = req.getUserPrincipal();
        if (principal == null) {
            return new SimpleSecurityContext(false);
        }
        String authenticationScheme = "BASIC";
        LinkedHashSet<String> userRoles = new LinkedHashSet<String>();
        for (String declaredRole : this.webApplicationDeclaredRoles.getDeclaredRoles()) {
            if (!req.isUserInRole(declaredRole)) continue;
            userRoles.add(declaredRole);
        }
        return new SimpleSecurityContext((Principal)new SimplePrincipal(principal.getName()), userRoles, "BASIC", false);
    }

    public static class OutputMessageEncoder
    extends BaseTextEncoder<OutputMessage> {
        private final JsonMessageConverter jsonMessageConverter = new JsonMessageConverter();

        public String encode(OutputMessage output) throws EncodeException {
            try {
                return this.jsonMessageConverter.toString(output);
            }
            catch (JsonException e) {
                throw new EncodeException((Object)output, e.getMessage(), (Throwable)e);
            }
        }
    }

    public static class InputMessageDecoder
    extends BaseTextDecoder<RestInputMessage> {
        private final JsonMessageConverter jsonMessageConverter = new JsonMessageConverter();

        public RestInputMessage decode(String s) throws DecodeException {
            try {
                return this.jsonMessageConverter.fromString(s, RestInputMessage.class);
            }
            catch (JsonException e) {
                throw new DecodeException(s, e.getMessage(), (Throwable)e);
            }
        }

        public boolean willDecode(String s) {
            return true;
        }
    }
}

