/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.samples.website.extention.services;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.groovyscript.text.TemplateService;
import org.exoplatform.platform.samples.website.extention.services.NavigableNode;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.publication.WCMComposer;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

@Path(value="/content-navigation")
public class ContentNavigationService
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getExoLogger(ContentNavigationService.class);
    private String workspace = null;
    private RepositoryService repositoryService_;
    private ManageableRepository manageableRepository_;

    public ContentNavigationService(RepositoryService rService, TemplateService templateService, InitParams params) {
        this.repositoryService_ = rService;
        this.workspace = params.getValueParam("workspace").getValue();
    }

    @GET
    @Path(value="/navigation/")
    @Produces(value={"application/json"})
    public JsonMenu getNavigation() {
        JsonMenu jsonMenu_ = new JsonMenu();
        ArrayList<JsonMenuNode> jsonMenuNodes = new ArrayList<JsonMenuNode>();
        try {
            this.manageableRepository_ = this.repositoryService_.getCurrentRepository();
            Session session = SessionProvider.createSystemProvider().getSession(this.workspace, this.manageableRepository_);
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            String strQuery = "SELECT * FROM exo:navigable";
            Query query = queryManager.createQuery(strQuery, "sql");
            QueryResult queryResult = query.execute();
            NodeIterator iterRawNodes = queryResult.getNodes();
            PortalContainer exoContanier = RootContainer.getInstance().getPortalContainer("portal");
            WCMComposer wcmComposer = (WCMComposer)exoContanier.getComponentInstanceOfType(WCMComposer.class);
            HashMap<String, String> filters = new HashMap<String, String>();
            filters.put("filter-mode", "Live");
            ArrayList<NavigableNode> allNodes = new ArrayList<NavigableNode>();
            while (iterRawNodes.hasNext()) {
                Node node = (Node)iterRawNodes.next();
                NavigableNode navigableNode = new NavigableNode(node);
                navigableNode.setNavigationNode(node.hasProperty("exo:navigationNode") ? node.getProperty("exo:navigationNode").getValue().getString() : "");
                navigableNode.setClickable(node.hasProperty("exo:clickable") ? node.getProperty("exo:clickable").getValue().getBoolean() : false);
                navigableNode.setListUri(node.hasProperty("exo:page") ? node.getProperty("exo:page").getValue().getString() : "");
                navigableNode.setListParam(node.hasProperty("exo:pageParamId") ? node.getProperty("exo:pageParamId").getValue().getString() : "");
                navigableNode.setDetailUri(node.hasProperty("exo:childrenPage") ? node.getProperty("exo:childrenPage").getValue().getString() : "");
                navigableNode.setDetailParam(node.hasProperty("exo:childrenPageParamId") ? node.getProperty("exo:childrenPageParamId").getValue().getString() : "");
                if (wcmComposer.getContent(this.workspace, node.getPath(), filters, WCMCoreUtils.getUserSessionProvider()) == null) {
                    navigableNode.setViewableNode(false);
                } else {
                    navigableNode.setViewableNode(true);
                }
                allNodes.add(navigableNode);
            }
            for (NavigableNode navigableNode : allNodes) {
                if (StringUtils.isEmpty((String)navigableNode.getNavigationNode())) continue;
                JsonMenuNode jsonMenuNode = new JsonMenuNode();
                jsonMenuNode.setLabel(navigableNode.getNode().getName());
                jsonMenuNode.setUri(navigableNode.isClickable() ? navigableNode.getNavigationNode() : "#");
                jsonMenuNode.setViewable(navigableNode.isViewableNode());
                jsonMenuNode.setNavigationNode(navigableNode.getNavigationNode());
                jsonMenuNode.setNodes(this.getChildNodes(navigableNode, allNodes));
                jsonMenuNodes.add(jsonMenuNode);
            }
            jsonMenu_.setMenu(jsonMenuNodes);
            session.logout();
        }
        catch (Exception e) {
            LOG.error((Object)"Error while retrieving navigable nodes", (Throwable)e);
        }
        return jsonMenu_;
    }

    private List<JsonMenuNode> getChildNodes(NavigableNode parentNavigableNode, List<NavigableNode> allNodes) throws RepositoryException {
        ArrayList<JsonMenuNode> childNodes = new ArrayList<JsonMenuNode>();
        String parentNodePath = parentNavigableNode.getNode().getPath();
        ConversationState userState = ConversationState.getCurrent();
        Identity userIdentity = null;
        SessionImpl session = (SessionImpl)WCMCoreUtils.getUserSessionProvider().getSession(this.workspace, this.manageableRepository_);
        userIdentity = userState != null ? userState.getIdentity() : new Identity(IdentityConstants.ANONIM);
        for (NavigableNode navigableNode : allNodes) {
            if (!session.getAccessManager().hasPermission(((NodeImpl)navigableNode.getNode()).getACL(), "read", userIdentity)) continue;
            String nodePath = navigableNode.getNode().getPath();
            if (nodePath.length() > parentNodePath.length() && nodePath.indexOf(parentNodePath) == 0) {
                String subPath = nodePath.substring(parentNodePath.length());
                if (subPath.substring(1).split("/").length != 1) continue;
                if (StringUtils.isEmpty((String)navigableNode.getListUri())) {
                    navigableNode.setListUri(parentNavigableNode.getListUri());
                }
                if (StringUtils.isEmpty((String)navigableNode.getListParam())) {
                    navigableNode.setListParam(parentNavigableNode.getListParam());
                }
                if (StringUtils.isEmpty((String)navigableNode.getDetailUri())) {
                    navigableNode.setDetailUri(parentNavigableNode.getDetailUri());
                }
                if (StringUtils.isEmpty((String)navigableNode.getDetailParam())) {
                    navigableNode.setDetailParam(parentNavigableNode.getDetailParam());
                }
                JsonMenuNode jsonSubMenuNode = this.buildNode(navigableNode);
                childNodes.add(jsonSubMenuNode);
                jsonSubMenuNode.setNodes(this.getChildNodes(navigableNode, allNodes));
                continue;
            }
            if (!navigableNode.getNode().hasProperty("jcr:uuid")) continue;
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            String strQuery = "SELECT * FROM exo:symlink WHERE exo:uuid = '" + navigableNode.getNode().getUUID() + "'";
            Query query = queryManager.createQuery(strQuery, "sql");
            QueryResult queryResult = query.execute();
            NodeIterator iter = queryResult.getNodes();
            while (iter.hasNext()) {
                String symlinkSubPath;
                Node symlinkNode = (Node)iter.next();
                String symlinkNodePath = symlinkNode.getPath();
                if (symlinkNodePath.length() <= parentNodePath.length() || symlinkNodePath.indexOf(parentNodePath) != 0 || (symlinkSubPath = symlinkNodePath.substring(parentNodePath.length())).substring(1).split("/").length != 1) continue;
                if (StringUtils.isEmpty((String)navigableNode.getListUri())) {
                    navigableNode.setListUri(parentNavigableNode.getListUri());
                }
                if (StringUtils.isEmpty((String)navigableNode.getListParam())) {
                    navigableNode.setListParam(parentNavigableNode.getListParam());
                }
                if (StringUtils.isEmpty((String)navigableNode.getDetailUri())) {
                    navigableNode.setDetailUri(parentNavigableNode.getDetailUri());
                }
                if (StringUtils.isEmpty((String)navigableNode.getDetailParam())) {
                    navigableNode.setDetailParam(parentNavigableNode.getDetailParam());
                }
                JsonMenuNode jsonSubMenuNode = this.buildNode(navigableNode);
                childNodes.add(jsonSubMenuNode);
                jsonSubMenuNode.setNodes(this.getChildNodes(navigableNode, allNodes));
            }
        }
        Collections.sort(childNodes);
        return childNodes;
    }

    private JsonMenuNode buildNode(NavigableNode navigableNode) throws RepositoryException {
        JsonMenuNode jsonSubMenuNode = new JsonMenuNode();
        Node node = navigableNode.getNode();
        if (node.hasProperty("exo:title")) {
            jsonSubMenuNode.setLabel(node.getProperty("exo:title").getString());
        } else {
            jsonSubMenuNode.setLabel(node.getName());
        }
        if (navigableNode.isClickable()) {
            NodeLocation nodeLocation = NodeLocation.getNodeLocationByNode((Node)node);
            if (node.isNodeType("nt:folder") || node.isNodeType("exo:taxonomy")) {
                if (navigableNode.isClickable()) {
                    jsonSubMenuNode.setUri(navigableNode.getListUri());
                    jsonSubMenuNode.setPageParamId(navigableNode.getListParam());
                }
                jsonSubMenuNode.setContentPath(nodeLocation.getRepository() + ":" + nodeLocation.getWorkspace() + ":" + node.getPath());
            } else {
                if (navigableNode.isClickable()) {
                    jsonSubMenuNode.setUri(navigableNode.getDetailUri());
                    jsonSubMenuNode.setPageParamId(navigableNode.getDetailParam());
                }
                jsonSubMenuNode.setContentPath("/" + nodeLocation.getRepository() + "/" + nodeLocation.getWorkspace() + node.getPath());
            }
        }
        if (node.hasProperty("exo:index")) {
            jsonSubMenuNode.setIndex(node.getProperty("exo:index").getLong());
        } else {
            jsonSubMenuNode.setIndex(Integer.MAX_VALUE);
        }
        try {
            jsonSubMenuNode.setViewable(navigableNode.isViewableNode());
        }
        catch (Exception e) {
            LOG.error((Object)("Can not get isViewableNode property for navigableNode " + navigableNode.getNode().getPath()), (Throwable)e);
        }
        return jsonSubMenuNode;
    }

    public class JsonMenuNode
    implements Comparable<JsonMenuNode> {
        private String label;
        private String uri;
        private String navigationNode;
        private long index;
        private String pageParamId;
        private String contentPath;
        private boolean isViewable;
        private List<JsonMenuNode> nodes;

        public JsonMenuNode() {
        }

        public JsonMenuNode(String label, String uri, String navigationNode) {
            this.label = label;
            this.uri = uri;
            this.navigationNode = navigationNode;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public String getUri() {
            return this.uri;
        }

        public void setUri(String uri) {
            this.uri = uri;
        }

        public List<JsonMenuNode> getNodes() {
            return this.nodes;
        }

        public void setNodes(List<JsonMenuNode> nodes) {
            this.nodes = nodes;
        }

        public String getNavigationNode() {
            return this.navigationNode;
        }

        public void setNavigationNode(String navigationNode) {
            this.navigationNode = navigationNode;
        }

        public void setIndex(long index) {
            this.index = index;
        }

        public String getPageParamId() {
            return this.pageParamId;
        }

        public void setPageParamId(String pageParamId) {
            this.pageParamId = pageParamId;
        }

        public String getContentPath() {
            return this.contentPath;
        }

        public void setContentPath(String contentPath) {
            this.contentPath = contentPath;
        }

        @Override
        public int compareTo(JsonMenuNode o) {
            return (int)(this.index - o.index);
        }

        public boolean isViewable() {
            return this.isViewable;
        }

        public void setViewable(boolean isViewable) {
            this.isViewable = isViewable;
        }
    }

    public class JsonMenu {
        private List<JsonMenuNode> menu;

        public List<JsonMenuNode> getMenu() {
            return this.menu;
        }

        public void setMenu(List<JsonMenuNode> menu) {
            this.menu = menu;
        }
    }
}

