/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.service;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

public class ActivityComposerConfigurationService {
    public static final String HIDE_USER_ACTIVITY_COMPOSER = "hideUserActivityComposer";
    public static final String SPACES_WITHOUT_ACTIVITY_COMPOSER = "spacesWithoutActivityComposer";
    private static final String SPACES_SEPARATOR = ";";
    private List<Space> listSpacesWithActivityComposer;
    private List<Space> listSpacesWithoutActivityComposer;
    private SettingService settingService;
    private SpaceService spaceService;

    public ActivityComposerConfigurationService(SettingService settingService, SpaceService spaceService) {
        this.settingService = settingService;
        this.spaceService = spaceService;
    }

    public List<Space> getListSpacesWithActivityComposer() throws Exception {
        this.initSpaces();
        return this.listSpacesWithActivityComposer;
    }

    public List<Space> getListSpacesWithoutActivityComposer() throws Exception {
        this.initSpaces();
        return this.listSpacesWithoutActivityComposer;
    }

    public String getUserActivityComposerState() throws Exception {
        SettingValue hideUserActivityComposerSetting = this.settingService.get(Context.GLOBAL, Scope.GLOBAL, HIDE_USER_ACTIVITY_COMPOSER);
        return hideUserActivityComposerSetting != null ? (String)hideUserActivityComposerSetting.getValue() : "false";
    }

    public void hideSpaceActivityComposer(String spaces) {
        SettingValue spacesWithoutActivityComposerSetting = this.settingService.get(Context.GLOBAL, Scope.GLOBAL, SPACES_WITHOUT_ACTIVITY_COMPOSER);
        String spacesWithoutActivityComposer = spacesWithoutActivityComposerSetting != null ? (String)spacesWithoutActivityComposerSetting.getValue() : "";
        this.settingService.set(Context.GLOBAL, Scope.GLOBAL, SPACES_WITHOUT_ACTIVITY_COMPOSER, SettingValue.create((String)(spacesWithoutActivityComposer + spaces.replace(",", SPACES_SEPARATOR) + SPACES_SEPARATOR)));
    }

    public void showSpaceActivityComposer(String spaces) {
        SettingValue spacesWithoutActivityComposerSetting = this.settingService.get(Context.GLOBAL, Scope.GLOBAL, SPACES_WITHOUT_ACTIVITY_COMPOSER);
        String spacesWithoutActivityComposer = spacesWithoutActivityComposerSetting != null ? (String)spacesWithoutActivityComposerSetting.getValue() : "";
        this.settingService.set(Context.GLOBAL, Scope.GLOBAL, SPACES_WITHOUT_ACTIVITY_COMPOSER, SettingValue.create((String)spacesWithoutActivityComposer.replace(spaces.replace(",", SPACES_SEPARATOR) + SPACES_SEPARATOR, "")));
    }

    public void showHideUserActivityComposer(String hideUserActivityComposer) {
        this.settingService.set(Context.GLOBAL, Scope.GLOBAL, HIDE_USER_ACTIVITY_COMPOSER, SettingValue.create((String)hideUserActivityComposer));
    }

    private void initSpaces() throws Exception {
        ListAccess allSpacesListAccess = this.spaceService.getAllSpacesWithListAccess();
        Space[] allSpaces = (Space[])allSpacesListAccess.load(0, allSpacesListAccess.getSize());
        SettingValue spacesWithoutActivityComposerSetting = this.settingService.get(Context.GLOBAL, Scope.GLOBAL, SPACES_WITHOUT_ACTIVITY_COMPOSER);
        String spacesWithoutActivityComposer = spacesWithoutActivityComposerSetting != null ? (String)spacesWithoutActivityComposerSetting.getValue() : "";
        this.listSpacesWithoutActivityComposer = new ArrayList<Space>();
        this.listSpacesWithActivityComposer = new ArrayList<Space>();
        for (Space space : allSpaces) {
            if (!spacesWithoutActivityComposer.isEmpty() && spacesWithoutActivityComposer.contains(space.getPrettyName())) {
                this.listSpacesWithoutActivityComposer.add(space);
                continue;
            }
            this.listSpacesWithActivityComposer.add(space);
        }
    }
}

