// Generated by delombok at Thu Mar 04 16:35:24 UTC 2021
package org.exoplatform.analytics.model;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import lombok.*;
import lombok.EqualsAndHashCode.Exclude;

public class StatisticFieldMapping {
  private static final List<String> NUMERIC_TYPES = Arrays.asList("long", "double", "float", "short", "int");
  private String name;
  private String type;
  private boolean hasKeywordSubField;

  public static final String computeESQueryValue(String value) {
    if (NumberUtils.isDigits(value)) {
      return value;
    } else {
      return "\"" + value + "\"";
    }
  }

  public boolean isNumeric() {
    return NUMERIC_TYPES.contains(type);
  }

  public boolean isKeyword() {
    return StringUtils.equals(type, "keyword") || (hasKeywordSubField && StringUtils.equals(type, "text"));
  }

  public boolean isDate() {
    return StringUtils.equals(type, "date");
  }

  public boolean isText() {
    return StringUtils.equals(type, "text");
  }

  public boolean isAggregation() {
    return isNumeric() || isDate() || isKeyword();
  }

  public String getSearchFieldName() {
    return name;
  }

  public String getAggregationFieldName() {
    if (isAggregation() && hasKeywordSubField && StringUtils.equals(type, "text")) {
      return name + ".keyword";
    }
    return name;
  }

  public String getESQueryValue(String value) {
    if (isNumeric()) {
      return value;
    } else {
      return "\"" + value + "\"";
    }
  }

  @java.lang.SuppressWarnings("all")
  public String getName() {
    return this.name;
  }

  @java.lang.SuppressWarnings("all")
  public String getType() {
    return this.type;
  }

  @java.lang.SuppressWarnings("all")
  public boolean isHasKeywordSubField() {
    return this.hasKeywordSubField;
  }

  @java.lang.SuppressWarnings("all")
  public void setName(final String name) {
    this.name = name;
  }

  @java.lang.SuppressWarnings("all")
  public void setType(final String type) {
    this.type = type;
  }

  @java.lang.SuppressWarnings("all")
  public void setHasKeywordSubField(final boolean hasKeywordSubField) {
    this.hasKeywordSubField = hasKeywordSubField;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof StatisticFieldMapping)) return false;
    final StatisticFieldMapping other = (StatisticFieldMapping) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$name = this.getName();
    final java.lang.Object other$name = other.getName();
    if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof StatisticFieldMapping;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $name = this.getName();
    result = result * PRIME + ($name == null ? 43 : $name.hashCode());
    return result;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  public java.lang.String toString() {
    return "StatisticFieldMapping(name=" + this.getName() + ", type=" + this.getType() + ", hasKeywordSubField=" + this.isHasKeywordSubField() + ")";
  }

  @java.lang.SuppressWarnings("all")
  public StatisticFieldMapping(final String name, final String type, final boolean hasKeywordSubField) {
    this.name = name;
    this.type = type;
    this.hasKeywordSubField = hasKeywordSubField;
  }

  @java.lang.SuppressWarnings("all")
  public StatisticFieldMapping() {
  }
}
