// Generated by delombok at Thu Mar 04 16:35:24 UTC 2021
package org.exoplatform.analytics.model.filter.aggregation;

import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.analytics.utils.AnalyticsUtils;
import groovy.transform.ToString;
import lombok.*;
import lombok.EqualsAndHashCode.Exclude;

@ToString
public class AnalyticsAggregation implements Serializable, Cloneable {
  private static final long serialVersionUID = 2130321038232532587L;
  public static final String YEAR_INTERVAL = "year";
  public static final String MONTH_INTERVAL = "month";
  public static final String QUARTER_INTERVAL = "quarter";
  public static final String WEEK_INTERVAL = "week";
  public static final String DAY_INTERVAL = "day";
  public static final String HOUR_INTERVAL = "hour";
  public static final String MINUTE_INTERVAL = "minute";
  public static final String SECOND_INTERVAL = "second";
  public static final DateTimeFormatter YEAR_DATE_FORMATTER = DateTimeFormatter.ofPattern("uuuu");
  public static final DateTimeFormatter QUARTER_DATE_FORMATTER = DateTimeFormatter.ofPattern("QQQ uuuu");
  public static final DateTimeFormatter MONTH_DATE_FORMATTER = DateTimeFormatter.ofPattern("MMM uuuu");
  public static final DateTimeFormatter DAY_DATE_FORMATTER = DateTimeFormatter.ofPattern("d MMM uuuu");
  public static final DateTimeFormatter WEEK_DATE_FORMATTER = DateTimeFormatter.ofPattern("\'W\'w uuuu");
  public static final DateTimeFormatter HOUR_DATE_FORMATTER = DateTimeFormatter.ofPattern("hh a, d MMM uuuu");
  private AnalyticsAggregationType type;
  private String field;
  private String sortDirection;
  private String interval;

  public AnalyticsAggregation(String field) {
    this.field = field;
    this.type = AnalyticsAggregationType.COUNT;
  }

  public String getLabel(String fieldValue, String lang) {
    if (type == AnalyticsAggregationType.DATE) {
      long timestamp = Long.parseLong(fieldValue);
      return formatTime(timestamp, lang);
    }
    return AnalyticsUtils.compueLabel(field, fieldValue);
  }

  private String formatTime(long timestamp, String lang) {
    Locale userLocale = StringUtils.isBlank(lang) ? Locale.getDefault() : new Locale(lang);
    LocalDateTime dateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(timestamp), TimeZone.getDefault().toZoneId());
    DateTimeFormatter dateFormatter = null;
    switch (interval) {
    case YEAR_INTERVAL: 
      dateFormatter = YEAR_DATE_FORMATTER;
      break;

    case QUARTER_INTERVAL: 
      dateFormatter = QUARTER_DATE_FORMATTER;
      break;

    case MONTH_INTERVAL: 
      dateFormatter = MONTH_DATE_FORMATTER;
      break;

    case WEEK_INTERVAL: 
      dateFormatter = WEEK_DATE_FORMATTER;
      break;

    case DAY_INTERVAL: 
      dateFormatter = DAY_DATE_FORMATTER;
      break;

    case HOUR_INTERVAL: 
      dateFormatter = HOUR_DATE_FORMATTER;
      break;

    default: 
      dateFormatter = DAY_DATE_FORMATTER;
    }
    return dateTime.format(dateFormatter.withLocale(userLocale));
  }

  @Override
  public AnalyticsAggregation clone() {
    // NOSONAR
    return new AnalyticsAggregation(type, field, sortDirection, interval);
  }

  @java.lang.SuppressWarnings("all")
  public AnalyticsAggregationType getType() {
    return this.type;
  }

  @java.lang.SuppressWarnings("all")
  public String getField() {
    return this.field;
  }

  @java.lang.SuppressWarnings("all")
  public String getSortDirection() {
    return this.sortDirection;
  }

  @java.lang.SuppressWarnings("all")
  public String getInterval() {
    return this.interval;
  }

  @java.lang.SuppressWarnings("all")
  public void setType(final AnalyticsAggregationType type) {
    this.type = type;
  }

  @java.lang.SuppressWarnings("all")
  public void setField(final String field) {
    this.field = field;
  }

  @java.lang.SuppressWarnings("all")
  public void setSortDirection(final String sortDirection) {
    this.sortDirection = sortDirection;
  }

  @java.lang.SuppressWarnings("all")
  public void setInterval(final String interval) {
    this.interval = interval;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof AnalyticsAggregation)) return false;
    final AnalyticsAggregation other = (AnalyticsAggregation) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$type = this.getType();
    final java.lang.Object other$type = other.getType();
    if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
    final java.lang.Object this$field = this.getField();
    final java.lang.Object other$field = other.getField();
    if (this$field == null ? other$field != null : !this$field.equals(other$field)) return false;
    final java.lang.Object this$interval = this.getInterval();
    final java.lang.Object other$interval = other.getInterval();
    if (this$interval == null ? other$interval != null : !this$interval.equals(other$interval)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof AnalyticsAggregation;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $type = this.getType();
    result = result * PRIME + ($type == null ? 43 : $type.hashCode());
    final java.lang.Object $field = this.getField();
    result = result * PRIME + ($field == null ? 43 : $field.hashCode());
    final java.lang.Object $interval = this.getInterval();
    result = result * PRIME + ($interval == null ? 43 : $interval.hashCode());
    return result;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  public java.lang.String toString() {
    return "AnalyticsAggregation(type=" + this.getType() + ", field=" + this.getField() + ", sortDirection=" + this.getSortDirection() + ", interval=" + this.getInterval() + ")";
  }

  @java.lang.SuppressWarnings("all")
  public AnalyticsAggregation(final AnalyticsAggregationType type, final String field, final String sortDirection, final String interval) {
    this.type = type;
    this.field = field;
    this.sortDirection = sortDirection;
    this.interval = interval;
  }

  @java.lang.SuppressWarnings("all")
  public AnalyticsAggregation() {
  }
}
