// Generated by delombok at Wed Apr 28 14:54:39 UTC 2021
package org.exoplatform.analytics.model.chart;

import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;
import org.exoplatform.analytics.utils.AnalyticsUtils;

public class ChartDataList implements Serializable {
  private static final long serialVersionUID = 5490607865795348987L;
  private String lang;
  private LinkedHashSet<ChartAggregationLabel> aggregationLabels = new LinkedHashSet<>();
  private LinkedHashSet<ChartData> charts = new LinkedHashSet<>();
  private long computingTime;
  private long dataCount;

  public ChartDataList(String lang) {
    this.lang = lang;
  }

  public ChartData addAggregationResult(ChartAggregationValue chartParentAggregation, ChartAggregationResult aggregationResult) {
    ChartAggregationLabel chartLabel = aggregationResult.getChartLabel();
    if (!aggregationLabels.contains(chartLabel)) {
      aggregationLabels.add(chartLabel);
    }
    ChartData chartData = charts.stream().filter(data -> (data.getKey() == null && chartParentAggregation == null) || (data.getKey() != null && data.getKey().equals(chartParentAggregation))).findFirst().orElse(null);
    if (chartData == null) {
      List<ChartAggregationResult> results = new ArrayList<>();
      chartData = new ChartData(chartParentAggregation, results, lang, null);
      String chartValue = chartData.getChartValue();
      String chartKey = chartData.getChartKey();
      String label = AnalyticsUtils.compueLabel(chartKey, chartValue);
      chartData.setChartLabel(label);
      charts.add(chartData);
    }
    chartData.addAggregationResult(aggregationResult, -1, true);
    return chartData;
  }

  public List<String> getLabels() {
    return aggregationLabels.stream().map(result -> result.getLabel()).collect(Collectors.toList());
  }

  @java.lang.SuppressWarnings("all")
  public String getLang() {
    return this.lang;
  }

  @java.lang.SuppressWarnings("all")
  public LinkedHashSet<ChartAggregationLabel> getAggregationLabels() {
    return this.aggregationLabels;
  }

  @java.lang.SuppressWarnings("all")
  public LinkedHashSet<ChartData> getCharts() {
    return this.charts;
  }

  @java.lang.SuppressWarnings("all")
  public long getComputingTime() {
    return this.computingTime;
  }

  @java.lang.SuppressWarnings("all")
  public long getDataCount() {
    return this.dataCount;
  }

  @java.lang.SuppressWarnings("all")
  public void setLang(final String lang) {
    this.lang = lang;
  }

  @java.lang.SuppressWarnings("all")
  public void setAggregationLabels(final LinkedHashSet<ChartAggregationLabel> aggregationLabels) {
    this.aggregationLabels = aggregationLabels;
  }

  @java.lang.SuppressWarnings("all")
  public void setCharts(final LinkedHashSet<ChartData> charts) {
    this.charts = charts;
  }

  @java.lang.SuppressWarnings("all")
  public void setComputingTime(final long computingTime) {
    this.computingTime = computingTime;
  }

  @java.lang.SuppressWarnings("all")
  public void setDataCount(final long dataCount) {
    this.dataCount = dataCount;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof ChartDataList)) return false;
    final ChartDataList other = (ChartDataList) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$lang = this.getLang();
    final java.lang.Object other$lang = other.getLang();
    if (this$lang == null ? other$lang != null : !this$lang.equals(other$lang)) return false;
    final java.lang.Object this$aggregationLabels = this.getAggregationLabels();
    final java.lang.Object other$aggregationLabels = other.getAggregationLabels();
    if (this$aggregationLabels == null ? other$aggregationLabels != null : !this$aggregationLabels.equals(other$aggregationLabels)) return false;
    final java.lang.Object this$charts = this.getCharts();
    final java.lang.Object other$charts = other.getCharts();
    if (this$charts == null ? other$charts != null : !this$charts.equals(other$charts)) return false;
    if (this.getComputingTime() != other.getComputingTime()) return false;
    if (this.getDataCount() != other.getDataCount()) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof ChartDataList;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $lang = this.getLang();
    result = result * PRIME + ($lang == null ? 43 : $lang.hashCode());
    final java.lang.Object $aggregationLabels = this.getAggregationLabels();
    result = result * PRIME + ($aggregationLabels == null ? 43 : $aggregationLabels.hashCode());
    final java.lang.Object $charts = this.getCharts();
    result = result * PRIME + ($charts == null ? 43 : $charts.hashCode());
    final long $computingTime = this.getComputingTime();
    result = result * PRIME + (int) ($computingTime >>> 32 ^ $computingTime);
    final long $dataCount = this.getDataCount();
    result = result * PRIME + (int) ($dataCount >>> 32 ^ $dataCount);
    return result;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  public java.lang.String toString() {
    return "ChartDataList(lang=" + this.getLang() + ", aggregationLabels=" + this.getAggregationLabels() + ", charts=" + this.getCharts() + ", computingTime=" + this.getComputingTime() + ", dataCount=" + this.getDataCount() + ")";
  }
}
