/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.analytics.api.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.exoplatform.analytics.api.processor.StatisticDataProcessorPlugin;
import org.exoplatform.analytics.model.StatisticDataQueueEntry;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class StatisticDataProcessorService {
    private static final Log LOG = ExoLogger.getLogger(StatisticDataProcessorService.class);
    private static final short MAX_PROCESS_ATTEMPTS_COUNT = 5;
    private ArrayList<StatisticDataProcessorPlugin> dataProcessorPlugins = new ArrayList();

    public void addProcessor(StatisticDataProcessorPlugin dataProcessorPlugin) {
        this.dataProcessorPlugins.add(dataProcessorPlugin);
    }

    public List<StatisticDataProcessorPlugin> getProcessors() {
        return this.dataProcessorPlugins;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(List<? extends StatisticDataQueueEntry> queueEntries) {
        if (queueEntries == null || queueEntries.isEmpty()) {
            return;
        }
        int entriesCount = queueEntries.size();
        if (entriesCount > 100) {
            int toIndex;
            LOG.debug("Processing queue having {} documents with chunk of {}", new Object[]{entriesCount, (short)100});
            int index = 0;
            do {
                toIndex = Math.min(entriesCount, index + 100);
                List<? extends StatisticDataQueueEntry> subList = queueEntries.subList(index, toIndex);
                this.process(subList);
            } while ((index = toIndex) < entriesCount);
            return;
        }
        Iterator<? extends StatisticDataQueueEntry> queueEntriesIterator = queueEntries.iterator();
        while (queueEntriesIterator.hasNext()) {
            StatisticDataQueueEntry statisticDataQueueEntry = queueEntriesIterator.next();
            if (!statisticDataQueueEntry.isProcessed() && (!statisticDataQueueEntry.isError() || statisticDataQueueEntry.getAttemptCount() <= 5)) continue;
            queueEntriesIterator.remove();
        }
        if (queueEntries.isEmpty()) {
            return;
        }
        for (StatisticDataProcessorPlugin statisticDataProcessorPlugin : this.dataProcessorPlugins) {
            String processorId = statisticDataProcessorPlugin.getId();
            List<StatisticDataQueueEntry> processorQueueEntries = queueEntries.stream().filter(queueEntry -> !this.isProcessorRun((StatisticDataQueueEntry)queueEntry, processorId)).collect(Collectors.toList());
            if (processorQueueEntries.isEmpty()) continue;
            try {
                statisticDataProcessorPlugin.process(processorQueueEntries);
                processorQueueEntries.forEach(queueEntry -> this.markProcessorAsSuccess((StatisticDataQueueEntry)queueEntry, processorId, (List<StatisticDataProcessorPlugin>)this.dataProcessorPlugins));
            }
            catch (Exception e) {
                if (LOG.isDebugEnabled()) {
                    LOG.warn("Error processing queue entries: {}, try to process entries one by one.", new Object[]{processorQueueEntries, e});
                } else {
                    LOG.warn((Object)"Error processing queue entries, try to process entries one by one.", (Throwable)e);
                }
                processorQueueEntries.forEach(queueEntry -> {
                    try {
                        statisticDataProcessorPlugin.process(Collections.singletonList(queueEntry));
                        this.markProcessorAsSuccess((StatisticDataQueueEntry)queueEntry, processorId, (List<StatisticDataProcessorPlugin>)this.dataProcessorPlugins);
                    }
                    catch (Exception exception) {
                        LOG.warn("Error processing queue entry {}", new Object[]{queueEntry, exception});
                        this.markProcessorAsError((StatisticDataQueueEntry)queueEntry, processorId);
                    }
                });
            }
            finally {
                processorQueueEntries.forEach(queueEntry -> queueEntry.setAttemptCount((short)(queueEntry.getAttemptCount() + 1)));
            }
        }
    }

    private void markProcessorAsSuccess(StatisticDataQueueEntry dataQueueEntry, String processorId, List<StatisticDataProcessorPlugin> processors) {
        if (dataQueueEntry.getProcessingStatus() == null) {
            dataQueueEntry.setProcessingStatus(new HashMap<String, Boolean>());
        }
        dataQueueEntry.getProcessingStatus().put(processorId, true);
        boolean processedForAll = this.isProcessedForAll(dataQueueEntry, processors);
        dataQueueEntry.setProcessed(processedForAll);
    }

    private void markProcessorAsError(StatisticDataQueueEntry dataQueueEntry, String processorId) {
        if (dataQueueEntry.getProcessingStatus() == null) {
            dataQueueEntry.setProcessingStatus(new HashMap<String, Boolean>());
        }
        dataQueueEntry.getProcessingStatus().put(processorId, false);
        dataQueueEntry.setError(true);
    }

    private boolean isProcessedForAll(StatisticDataQueueEntry dataQueueEntry, List<StatisticDataProcessorPlugin> processors) {
        if (processors == null || processors.isEmpty()) {
            return true;
        }
        for (StatisticDataProcessorPlugin statisticDataProcessorPlugin : processors) {
            if (this.isProcessorRun(dataQueueEntry, statisticDataProcessorPlugin.getId())) continue;
            return false;
        }
        return true;
    }

    private boolean isProcessorRun(StatisticDataQueueEntry dataQueueEntry, String processorId) {
        Boolean processorStatus = dataQueueEntry.getProcessingStatus() == null ? null : dataQueueEntry.getProcessingStatus().get(processorId);
        return processorStatus != null && processorStatus != false;
    }
}

