// Generated by delombok at Wed Jun 09 17:14:11 UTC 2021
package org.exoplatform.analytics.model.filter;

import static org.exoplatform.analytics.model.filter.search.AnalyticsFieldFilterType.*;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.analytics.model.filter.aggregation.AnalyticsAggregation;
import org.exoplatform.analytics.model.filter.search.AnalyticsFieldFilter;
import org.exoplatform.analytics.utils.AnalyticsUtils;
import groovy.transform.ToString;
import lombok.*;

@ToString
public class AnalyticsFilter implements Serializable, Cloneable {
  private static final long serialVersionUID = 5699550622069979910L;
  private String title;
  private String chartType;
  private List<String> colors;
  private List<AnalyticsFieldFilter> filters = new ArrayList<>();
  private String multipleChartsField = null;
  private List<AnalyticsAggregation> xAxisAggregations = new ArrayList<>();
  private AnalyticsAggregation yAxisAggregation = null;
  private String lang = null;
  private long offset = 0;
  private long limit = 0;

  public List<AnalyticsAggregation> getAggregations() {
    List<AnalyticsAggregation> aggregations = new ArrayList<>();
    AnalyticsAggregation multipleChartsAggregation = getMultipleChartsAggregation();
    if (multipleChartsAggregation != null) {
      aggregations.add(multipleChartsAggregation);
    }
    aggregations.addAll(xAxisAggregations);
    if (yAxisAggregation != null && StringUtils.isNotBlank(yAxisAggregation.getField())) {
      aggregations.add(yAxisAggregation);
    }
    return Collections.unmodifiableList(aggregations);
  }

  public AnalyticsAggregation getMultipleChartsAggregation() {
    if (isMultipleCharts()) {
      return new AnalyticsAggregation(multipleChartsField);
    }
    return null;
  }

  public void addXAxisAggregation(AnalyticsAggregation aggregation) {
    xAxisAggregations.add(aggregation);
  }

  public boolean isMultipleCharts() {
    return StringUtils.isNotBlank(multipleChartsField);
  }

  public void addNotEqualFilter(String field, String value) {
    AnalyticsFieldFilter fieldFilter = new AnalyticsFieldFilter(field, NOT_EQUAL, String.valueOf(value));
    this.filters.add(fieldFilter);
  }

  public void addEqualFilter(String field, String value) {
    AnalyticsFieldFilter fieldFilter = new AnalyticsFieldFilter(field, EQUAL, String.valueOf(value));
    this.filters.add(fieldFilter);
  }

  public void addInSetFilter(String field, String... values) {
    if (values != null && values.length > 0) {
      AnalyticsFieldFilter fieldFilter = new AnalyticsFieldFilter(field, IN_SET, StringUtils.join(values, AnalyticsUtils.VALUES_SEPARATOR));
      this.filters.add(fieldFilter);
    }
  }

  public void addNotInSetFilter(String field, String... values) {
    if (values != null && values.length > 0) {
      AnalyticsFieldFilter fieldFilter = new AnalyticsFieldFilter(field, NOT_IN_SET, StringUtils.join(values, AnalyticsUtils.VALUES_SEPARATOR));
      this.filters.add(fieldFilter);
    }
  }

  public void addRangeFilter(String field, String start, String end) {
    AnalyticsFieldFilter fieldFilter = new AnalyticsFieldFilter(field, RANGE, new Range(start, end));
    this.filters.add(fieldFilter);
  }

  public void addGreaterFilter(String field, long value) {
    AnalyticsFieldFilter fieldFilter = new AnalyticsFieldFilter(field, GREATER, String.valueOf(value));
    this.filters.add(fieldFilter);
  }

  public void addLessFilter(String field, long value) {
    AnalyticsFieldFilter fieldFilter = new AnalyticsFieldFilter(field, LESS, String.valueOf(value));
    this.filters.add(fieldFilter);
  }


  @ToString
  public static class Range implements Serializable, Cloneable {
    private static final long serialVersionUID = 570632355720481459L;
    private String min;
    private String max;

    @Override
    public Range clone() {
      // NOSONAR
      return new Range(min, max);
    }

    @java.lang.SuppressWarnings("all")
    public String getMin() {
      return this.min;
    }

    @java.lang.SuppressWarnings("all")
    public String getMax() {
      return this.max;
    }

    @java.lang.SuppressWarnings("all")
    public void setMin(final String min) {
      this.min = min;
    }

    @java.lang.SuppressWarnings("all")
    public void setMax(final String max) {
      this.max = max;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof AnalyticsFilter.Range)) return false;
      final AnalyticsFilter.Range other = (AnalyticsFilter.Range) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$min = this.getMin();
      final java.lang.Object other$min = other.getMin();
      if (this$min == null ? other$min != null : !this$min.equals(other$min)) return false;
      final java.lang.Object this$max = this.getMax();
      final java.lang.Object other$max = other.getMax();
      if (this$max == null ? other$max != null : !this$max.equals(other$max)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof AnalyticsFilter.Range;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $min = this.getMin();
      result = result * PRIME + ($min == null ? 43 : $min.hashCode());
      final java.lang.Object $max = this.getMax();
      result = result * PRIME + ($max == null ? 43 : $max.hashCode());
      return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    public java.lang.String toString() {
      return "AnalyticsFilter.Range(min=" + this.getMin() + ", max=" + this.getMax() + ")";
    }

    @java.lang.SuppressWarnings("all")
    public Range() {
    }

    @java.lang.SuppressWarnings("all")
    public Range(final String min, final String max) {
      this.min = min;
      this.max = max;
    }
  }

  @Override
  public AnalyticsFilter clone() {
    // NOSONAR
    List<AnalyticsFieldFilter> cloneFilters = new ArrayList<>(filters).stream().map(filter -> filter.clone()).collect(Collectors.toList());
    List<AnalyticsAggregation> cloneXAggs = new ArrayList<>(xAxisAggregations).stream().map(aggr -> aggr.clone()).collect(Collectors.toList());
    AnalyticsAggregation cloneyAggregation = yAxisAggregation.clone();
    return new AnalyticsFilter(title, chartType, colors, cloneFilters, multipleChartsField, cloneXAggs, cloneyAggregation, lang, offset, limit);
  }

  @java.lang.SuppressWarnings("all")
  public String getTitle() {
    return this.title;
  }

  @java.lang.SuppressWarnings("all")
  public String getChartType() {
    return this.chartType;
  }

  @java.lang.SuppressWarnings("all")
  public List<String> getColors() {
    return this.colors;
  }

  @java.lang.SuppressWarnings("all")
  public List<AnalyticsFieldFilter> getFilters() {
    return this.filters;
  }

  @java.lang.SuppressWarnings("all")
  public String getMultipleChartsField() {
    return this.multipleChartsField;
  }

  @java.lang.SuppressWarnings("all")
  public List<AnalyticsAggregation> getXAxisAggregations() {
    return this.xAxisAggregations;
  }

  @java.lang.SuppressWarnings("all")
  public AnalyticsAggregation getYAxisAggregation() {
    return this.yAxisAggregation;
  }

  @java.lang.SuppressWarnings("all")
  public String getLang() {
    return this.lang;
  }

  @java.lang.SuppressWarnings("all")
  public long getOffset() {
    return this.offset;
  }

  @java.lang.SuppressWarnings("all")
  public long getLimit() {
    return this.limit;
  }

  @java.lang.SuppressWarnings("all")
  public void setTitle(final String title) {
    this.title = title;
  }

  @java.lang.SuppressWarnings("all")
  public void setChartType(final String chartType) {
    this.chartType = chartType;
  }

  @java.lang.SuppressWarnings("all")
  public void setColors(final List<String> colors) {
    this.colors = colors;
  }

  @java.lang.SuppressWarnings("all")
  public void setFilters(final List<AnalyticsFieldFilter> filters) {
    this.filters = filters;
  }

  @java.lang.SuppressWarnings("all")
  public void setMultipleChartsField(final String multipleChartsField) {
    this.multipleChartsField = multipleChartsField;
  }

  @java.lang.SuppressWarnings("all")
  public void setXAxisAggregations(final List<AnalyticsAggregation> xAxisAggregations) {
    this.xAxisAggregations = xAxisAggregations;
  }

  @java.lang.SuppressWarnings("all")
  public void setYAxisAggregation(final AnalyticsAggregation yAxisAggregation) {
    this.yAxisAggregation = yAxisAggregation;
  }

  @java.lang.SuppressWarnings("all")
  public void setLang(final String lang) {
    this.lang = lang;
  }

  @java.lang.SuppressWarnings("all")
  public void setOffset(final long offset) {
    this.offset = offset;
  }

  @java.lang.SuppressWarnings("all")
  public void setLimit(final long limit) {
    this.limit = limit;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof AnalyticsFilter)) return false;
    final AnalyticsFilter other = (AnalyticsFilter) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$title = this.getTitle();
    final java.lang.Object other$title = other.getTitle();
    if (this$title == null ? other$title != null : !this$title.equals(other$title)) return false;
    final java.lang.Object this$chartType = this.getChartType();
    final java.lang.Object other$chartType = other.getChartType();
    if (this$chartType == null ? other$chartType != null : !this$chartType.equals(other$chartType)) return false;
    final java.lang.Object this$colors = this.getColors();
    final java.lang.Object other$colors = other.getColors();
    if (this$colors == null ? other$colors != null : !this$colors.equals(other$colors)) return false;
    final java.lang.Object this$filters = this.getFilters();
    final java.lang.Object other$filters = other.getFilters();
    if (this$filters == null ? other$filters != null : !this$filters.equals(other$filters)) return false;
    final java.lang.Object this$multipleChartsField = this.getMultipleChartsField();
    final java.lang.Object other$multipleChartsField = other.getMultipleChartsField();
    if (this$multipleChartsField == null ? other$multipleChartsField != null : !this$multipleChartsField.equals(other$multipleChartsField)) return false;
    final java.lang.Object this$xAxisAggregations = this.getXAxisAggregations();
    final java.lang.Object other$xAxisAggregations = other.getXAxisAggregations();
    if (this$xAxisAggregations == null ? other$xAxisAggregations != null : !this$xAxisAggregations.equals(other$xAxisAggregations)) return false;
    final java.lang.Object this$yAxisAggregation = this.getYAxisAggregation();
    final java.lang.Object other$yAxisAggregation = other.getYAxisAggregation();
    if (this$yAxisAggregation == null ? other$yAxisAggregation != null : !this$yAxisAggregation.equals(other$yAxisAggregation)) return false;
    final java.lang.Object this$lang = this.getLang();
    final java.lang.Object other$lang = other.getLang();
    if (this$lang == null ? other$lang != null : !this$lang.equals(other$lang)) return false;
    if (this.getOffset() != other.getOffset()) return false;
    if (this.getLimit() != other.getLimit()) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof AnalyticsFilter;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $title = this.getTitle();
    result = result * PRIME + ($title == null ? 43 : $title.hashCode());
    final java.lang.Object $chartType = this.getChartType();
    result = result * PRIME + ($chartType == null ? 43 : $chartType.hashCode());
    final java.lang.Object $colors = this.getColors();
    result = result * PRIME + ($colors == null ? 43 : $colors.hashCode());
    final java.lang.Object $filters = this.getFilters();
    result = result * PRIME + ($filters == null ? 43 : $filters.hashCode());
    final java.lang.Object $multipleChartsField = this.getMultipleChartsField();
    result = result * PRIME + ($multipleChartsField == null ? 43 : $multipleChartsField.hashCode());
    final java.lang.Object $xAxisAggregations = this.getXAxisAggregations();
    result = result * PRIME + ($xAxisAggregations == null ? 43 : $xAxisAggregations.hashCode());
    final java.lang.Object $yAxisAggregation = this.getYAxisAggregation();
    result = result * PRIME + ($yAxisAggregation == null ? 43 : $yAxisAggregation.hashCode());
    final java.lang.Object $lang = this.getLang();
    result = result * PRIME + ($lang == null ? 43 : $lang.hashCode());
    final long $offset = this.getOffset();
    result = result * PRIME + (int) ($offset >>> 32 ^ $offset);
    final long $limit = this.getLimit();
    result = result * PRIME + (int) ($limit >>> 32 ^ $limit);
    return result;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  public java.lang.String toString() {
    return "AnalyticsFilter(title=" + this.getTitle() + ", chartType=" + this.getChartType() + ", colors=" + this.getColors() + ", filters=" + this.getFilters() + ", multipleChartsField=" + this.getMultipleChartsField() + ", xAxisAggregations=" + this.getXAxisAggregations() + ", yAxisAggregation=" + this.getYAxisAggregation() + ", lang=" + this.getLang() + ", offset=" + this.getOffset() + ", limit=" + this.getLimit() + ")";
  }

  @java.lang.SuppressWarnings("all")
  public AnalyticsFilter() {
  }

  @java.lang.SuppressWarnings("all")
  public AnalyticsFilter(final String title, final String chartType, final List<String> colors, final List<AnalyticsFieldFilter> filters, final String multipleChartsField, final List<AnalyticsAggregation> xAxisAggregations, final AnalyticsAggregation yAxisAggregation, final String lang, final long offset, final long limit) {
    this.title = title;
    this.chartType = chartType;
    this.colors = colors;
    this.filters = filters;
    this.multipleChartsField = multipleChartsField;
    this.xAxisAggregations = xAxisAggregations;
    this.yAxisAggregation = yAxisAggregation;
    this.lang = lang;
    this.offset = offset;
    this.limit = limit;
  }
}
