// Generated by delombok at Thu Sep 02 12:58:56 UTC 2021
package org.exoplatform.analytics.model.chart;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.*;

public class ChartData implements Serializable {
  private static final long serialVersionUID = 7951982952095482899L;
  private ChartAggregationValue key;
  private List<ChartAggregationResult> aggregationResults = new ArrayList<>();
  private String lang;
  private String chartLabel;

  public String getChartKey() {
    return key == null || key.getAggregation() == null ? null : key.getAggregation().getField();
  }

  public void addAggregationResult(ChartAggregationResult aggregationResult, int index, boolean replaceIfExists) {
    int existingIndex = aggregationResults.indexOf(aggregationResult);
    if (existingIndex < 0) {
      if (index < 0) {
        aggregationResults.add(aggregationResult);
      } else {
        aggregationResults.add(index, aggregationResult);
      }
    } else if (replaceIfExists) {
      aggregationResults.remove(index);
      if (index < 0) {
        aggregationResults.add(aggregationResult);
      } else {
        aggregationResults.add(index, aggregationResult);
      }
    }
  }

  public String getChartValue() {
    return key == null ? null : key.getFieldValue();
  }

  public List<String> getValues() {
    return aggregationResults.stream().map(ChartAggregationResult::getValue).collect(Collectors.toList());
  }

  @java.lang.SuppressWarnings("all")
  public ChartAggregationValue getKey() {
    return this.key;
  }

  @java.lang.SuppressWarnings("all")
  public List<ChartAggregationResult> getAggregationResults() {
    return this.aggregationResults;
  }

  @java.lang.SuppressWarnings("all")
  public String getLang() {
    return this.lang;
  }

  @java.lang.SuppressWarnings("all")
  public String getChartLabel() {
    return this.chartLabel;
  }

  @java.lang.SuppressWarnings("all")
  public void setKey(final ChartAggregationValue key) {
    this.key = key;
  }

  @java.lang.SuppressWarnings("all")
  public void setAggregationResults(final List<ChartAggregationResult> aggregationResults) {
    this.aggregationResults = aggregationResults;
  }

  @java.lang.SuppressWarnings("all")
  public void setLang(final String lang) {
    this.lang = lang;
  }

  @java.lang.SuppressWarnings("all")
  public void setChartLabel(final String chartLabel) {
    this.chartLabel = chartLabel;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof ChartData)) return false;
    final ChartData other = (ChartData) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$key = this.getKey();
    final java.lang.Object other$key = other.getKey();
    if (this$key == null ? other$key != null : !this$key.equals(other$key)) return false;
    final java.lang.Object this$aggregationResults = this.getAggregationResults();
    final java.lang.Object other$aggregationResults = other.getAggregationResults();
    if (this$aggregationResults == null ? other$aggregationResults != null : !this$aggregationResults.equals(other$aggregationResults)) return false;
    final java.lang.Object this$lang = this.getLang();
    final java.lang.Object other$lang = other.getLang();
    if (this$lang == null ? other$lang != null : !this$lang.equals(other$lang)) return false;
    final java.lang.Object this$chartLabel = this.getChartLabel();
    final java.lang.Object other$chartLabel = other.getChartLabel();
    if (this$chartLabel == null ? other$chartLabel != null : !this$chartLabel.equals(other$chartLabel)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof ChartData;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $key = this.getKey();
    result = result * PRIME + ($key == null ? 43 : $key.hashCode());
    final java.lang.Object $aggregationResults = this.getAggregationResults();
    result = result * PRIME + ($aggregationResults == null ? 43 : $aggregationResults.hashCode());
    final java.lang.Object $lang = this.getLang();
    result = result * PRIME + ($lang == null ? 43 : $lang.hashCode());
    final java.lang.Object $chartLabel = this.getChartLabel();
    result = result * PRIME + ($chartLabel == null ? 43 : $chartLabel.hashCode());
    return result;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  public java.lang.String toString() {
    return "ChartData(key=" + this.getKey() + ", aggregationResults=" + this.getAggregationResults() + ", lang=" + this.getLang() + ", chartLabel=" + this.getChartLabel() + ")";
  }

  @java.lang.SuppressWarnings("all")
  public ChartData(final ChartAggregationValue key, final List<ChartAggregationResult> aggregationResults, final String lang, final String chartLabel) {
    this.key = key;
    this.aggregationResults = aggregationResults;
    this.lang = lang;
    this.chartLabel = chartLabel;
  }
}
