/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.analytics.es.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.analytics.api.service.AnalyticsService;
import org.exoplatform.analytics.api.service.StatisticUIWatcherPlugin;
import org.exoplatform.analytics.api.service.StatisticWatcher;
import org.exoplatform.analytics.es.AnalyticsESClient;
import org.exoplatform.analytics.es.AnalyticsIndexingServiceConnector;
import org.exoplatform.analytics.model.StatisticData;
import org.exoplatform.analytics.model.StatisticFieldMapping;
import org.exoplatform.analytics.model.chart.ChartAggregationLabel;
import org.exoplatform.analytics.model.chart.ChartAggregationResult;
import org.exoplatform.analytics.model.chart.ChartAggregationValue;
import org.exoplatform.analytics.model.chart.ChartData;
import org.exoplatform.analytics.model.chart.ChartDataList;
import org.exoplatform.analytics.model.filter.AnalyticsFilter;
import org.exoplatform.analytics.model.filter.aggregation.AnalyticsAggregation;
import org.exoplatform.analytics.model.filter.aggregation.AnalyticsAggregationType;
import org.exoplatform.analytics.model.filter.search.AnalyticsFieldFilter;
import org.exoplatform.analytics.model.filter.search.AnalyticsFieldFilterType;
import org.exoplatform.analytics.model.filter.search.AnalyticsSortField;
import org.exoplatform.analytics.utils.AnalyticsUtils;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.picocontainer.Startable;

public class ESAnalyticsService
implements AnalyticsService,
Startable {
    private static final Log LOG = ExoLogger.getLogger(ESAnalyticsService.class);
    private static final String ANALYTICS_ADMIN_PERMISSION_PARAM_NAME = "exo.analytics.admin.permissions";
    private static final String ANALYTICS_VIEW_ALL_PERMISSION_PARAM_NAME = "exo.analytics.viewall.permissions";
    private static final String ANALYTICS_VIEW_PERMISSION_PARAM_NAME = "exo.analytics.view.permissions";
    private static final String RETURNED_AGGREGATION_DOCS_COUNT_PARAM_NAME = "exo.analytics.aggregation.terms.doc_size";
    private static final String AGGREGATION_KEYS_SEPARATOR = "-";
    private static final String AGGREGATION_RESULT_PARAM = "aggregation_result";
    private static final String AGGREGATION_RESULT_VALUE_PARAM = "aggregation_result_value";
    private static final Context CONTEXT = Context.GLOBAL.id("ANALYTICS");
    private static final Scope ES_SCOPE = Scope.GLOBAL.id("elasticsearch");
    private static final String ES_AGGREGATED_MAPPING = "ES_AGGREGATED_MAPPING";
    private static final AnalyticsFieldFilter ES_TYPE_FILTER = new AnalyticsFieldFilter("isAnalytics", AnalyticsFieldFilterType.EQUAL, "true");
    private List<StatisticUIWatcherPlugin> uiWatcherPlugins = new ArrayList<StatisticUIWatcherPlugin>();
    private List<StatisticWatcher> uiWatchers = new ArrayList<StatisticWatcher>();
    private AnalyticsESClient esClient;
    private AnalyticsIndexingServiceConnector analyticsIndexingServiceConnector;
    private SettingService settingService;
    private Map<String, StatisticFieldMapping> esMappings = new HashMap<String, StatisticFieldMapping>();
    private ScheduledExecutorService esMappingUpdater = Executors.newScheduledThreadPool(1);
    private List<String> administratorsPermissions;
    private List<String> viewAllPermissions;
    private List<String> viewPermissions;
    private int aggregationReturnedDocumentsSize = 200;

    public ESAnalyticsService(AnalyticsESClient esClient, AnalyticsIndexingServiceConnector analyticsIndexingServiceConnector, SettingService settingService, InitParams params) {
        this.esClient = esClient;
        this.analyticsIndexingServiceConnector = analyticsIndexingServiceConnector;
        this.settingService = settingService;
        this.administratorsPermissions = params != null && params.containsKey((Object)ANALYTICS_ADMIN_PERMISSION_PARAM_NAME) ? params.getValuesParam(ANALYTICS_ADMIN_PERMISSION_PARAM_NAME).getValues() : Collections.emptyList();
        this.viewAllPermissions = params != null && params.containsKey((Object)ANALYTICS_VIEW_ALL_PERMISSION_PARAM_NAME) ? params.getValuesParam(ANALYTICS_VIEW_ALL_PERMISSION_PARAM_NAME).getValues() : Collections.emptyList();
        this.viewPermissions = params != null && params.containsKey((Object)ANALYTICS_VIEW_PERMISSION_PARAM_NAME) ? params.getValuesParam(ANALYTICS_VIEW_PERMISSION_PARAM_NAME).getValues() : Collections.emptyList();
        if (params != null && params.containsKey((Object)RETURNED_AGGREGATION_DOCS_COUNT_PARAM_NAME)) {
            this.aggregationReturnedDocumentsSize = Integer.parseInt(params.getValueParam(RETURNED_AGGREGATION_DOCS_COUNT_PARAM_NAME).getValue());
        }
    }

    public void start() {
        this.esMappingUpdater.scheduleAtFixedRate(() -> {
            PortalContainer container = PortalContainer.getInstance();
            ExoContainerContext.setCurrentContainer((ExoContainer)container);
            RequestLifeCycle.begin((ExoContainer)container);
            try {
                this.retrieveMapping(true);
            }
            catch (Exception e) {
                LOG.warn((Object)"Error while getting mapping from elasticsearch", (Throwable)e);
            }
            finally {
                RequestLifeCycle.end();
            }
        }, 1L, 2L, TimeUnit.MINUTES);
    }

    public void stop() {
        this.esMappingUpdater.shutdown();
    }

    public Set<StatisticFieldMapping> retrieveMapping(boolean forceRefresh) {
        if (!forceRefresh) {
            if (this.esMappings.isEmpty()) {
                this.readFieldsMapping();
            }
            return new HashSet<StatisticFieldMapping>(this.esMappings.values());
        }
        try {
            long today = System.currentTimeMillis();
            String index = this.analyticsIndexingServiceConnector.getIndex(today);
            String mappingJsonString = this.esClient.getMapping(today);
            if (StringUtils.isBlank((CharSequence)mappingJsonString)) {
                return new HashSet<StatisticFieldMapping>(this.esMappings.values());
            }
            JSONObject result = new JSONObject(mappingJsonString);
            JSONObject mappingObject = AnalyticsUtils.getJSONObject((JSONObject)result, (int)0, (String[])new String[]{index, "mappings", this.analyticsIndexingServiceConnector.getType(), "properties"});
            if (mappingObject != null) {
                String[] fieldNames;
                for (String fieldName : fieldNames = JSONObject.getNames((JSONObject)mappingObject)) {
                    JSONObject esField = mappingObject.getJSONObject(fieldName);
                    String fieldType = esField.getString("type");
                    JSONObject keywordField = AnalyticsUtils.getJSONObject((JSONObject)esField, (int)0, (String[])new String[]{"fields", "keyword"});
                    StatisticFieldMapping esFieldMapping = new StatisticFieldMapping(fieldName, fieldType, keywordField != null);
                    this.esMappings.put(fieldName, esFieldMapping);
                }
            }
            this.storeFieldsMappings();
        }
        catch (Exception e) {
            LOG.error((Object)"Error getting mapping of analytics", (Throwable)e);
        }
        return new HashSet<StatisticFieldMapping>(this.esMappings.values());
    }

    public ChartDataList computeChartData(AnalyticsFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException("Filter is mandatory");
        }
        if (filter.getAggregations() == null || filter.getAggregations().isEmpty()) {
            throw new IllegalArgumentException("Filter aggregations is mandatory");
        }
        boolean retrieveUsedTuples = false;
        StringBuilder esQuery = new StringBuilder();
        this.buildAnalyticsQuery(filter, retrieveUsedTuples, esQuery);
        String esQueryString = esQuery.toString();
        esQueryString = AnalyticsUtils.fixJSONStringFormat((String)esQueryString);
        LOG.debug("ES query to compute chart data with filter :{} . Query: {}", new Object[]{filter, esQueryString});
        String jsonResponse = this.esClient.sendRequest(esQueryString);
        try {
            return this.buildChartDataFromESResponse(filter, jsonResponse);
        }
        catch (JSONException e) {
            throw new IllegalStateException("Error parsing results with - filter: " + filter + " - query: " + esQueryString + " - response: " + jsonResponse, e);
        }
    }

    public List<StatisticData> retrieveData(AnalyticsFilter searchFilter) {
        StringBuilder esQuery = this.buildFilterQuery(searchFilter, false);
        String esQueryString = esQuery.toString();
        esQueryString = AnalyticsUtils.fixJSONStringFormat((String)esQueryString);
        LOG.debug("ES query to compute search count with filter {}: {}", new Object[]{searchFilter, esQueryString});
        String jsonResponse = this.esClient.sendRequest(esQueryString);
        try {
            return this.buildSearchResultFromESResponse(jsonResponse);
        }
        catch (JSONException e) {
            throw new IllegalStateException("Error parsing results with filter: " + searchFilter + ", response: " + jsonResponse, e);
        }
    }

    public List<String> getAdministratorsPermissions() {
        return this.administratorsPermissions;
    }

    public List<String> getViewAllPermissions() {
        return this.viewAllPermissions;
    }

    public List<String> getViewPermissions() {
        return this.viewPermissions;
    }

    public List<StatisticWatcher> getUIWatchers() {
        return this.uiWatchers;
    }

    public StatisticWatcher getUIWatcher(String name) {
        return this.getUIWatchers().stream().filter(watcher -> StringUtils.equals((CharSequence)name, (CharSequence)watcher.getName())).findFirst().orElse(null);
    }

    public void addUIWatcherPlugin(StatisticUIWatcherPlugin uiWatcherPlugin) {
        this.uiWatcherPlugins.add(uiWatcherPlugin);
        this.uiWatchers.add(uiWatcherPlugin.getStatisticWatcher());
    }

    private void buildAnalyticsQuery(AnalyticsFilter analyticsFilter, boolean retrieveUsedTuples, StringBuilder esQuery) {
        esQuery.append("{");
        this.buildSearchFilterQuery(esQuery, analyticsFilter.getFilters(), null, analyticsFilter.getOffset(), analyticsFilter.getLimit(), !retrieveUsedTuples, false);
        this.buildAggregationQuery(esQuery, analyticsFilter.getAggregations());
        esQuery.append("}");
    }

    private List<AnalyticsSortField> getSortFields(List<AnalyticsAggregation> aggregations) {
        ArrayList<AnalyticsSortField> sortFields = new ArrayList<AnalyticsSortField>();
        aggregations.forEach(agg -> {
            AnalyticsSortField sortField = new AnalyticsSortField(agg.getField(), agg.getSortDirection());
            sortFields.add(sortField);
        });
        return sortFields;
    }

    private StringBuilder buildFilterQuery(AnalyticsFilter analyticsFilter, boolean isCount) {
        long limit;
        List<AnalyticsSortField> sortFields = isCount || analyticsFilter == null ? null : this.getSortFields(analyticsFilter.getXAxisAggregations());
        List filters = analyticsFilter == null ? Collections.emptyList() : analyticsFilter.getFilters();
        long offset = analyticsFilter == null ? 0L : analyticsFilter.getOffset();
        long l = limit = analyticsFilter == null ? 0L : analyticsFilter.getLimit();
        if (!isCount && (sortFields == null || sortFields.isEmpty())) {
            sortFields = new ArrayList<AnalyticsSortField>();
            sortFields.add(new AnalyticsSortField("timestamp", "desc"));
        }
        StringBuilder esQuery = new StringBuilder();
        esQuery.append("{");
        this.buildSearchFilterQuery(esQuery, filters, sortFields, offset, limit, isCount, !isCount);
        esQuery.append("}");
        return esQuery;
    }

    private void buildSearchFilterQuery(StringBuilder esQuery, List<AnalyticsFieldFilter> filters, List<AnalyticsSortField> sortFields, long offset, long limit, boolean isCount, boolean useSort) {
        if (isCount) {
            esQuery.append("     \"size\" : 0");
            if (useSort) {
                esQuery.append(",");
            }
        } else {
            if (offset > 0L) {
                esQuery.append("     \"from\" : ").append(offset).append(",");
            }
            if (limit <= 0L || limit > Integer.MAX_VALUE) {
                limit = 10000L;
            }
            esQuery.append("     \"size\" : ").append(limit).append(",");
        }
        if (useSort) {
            if (sortFields == null || sortFields.isEmpty()) {
                esQuery.append("     \"sort\" : [{ \"timestamp\":{\"order\" : \"desc\"}}]");
            } else {
                esQuery.append("     \"sort\" : [");
                for (int i = 0; i < sortFields.size(); ++i) {
                    String direction;
                    AnalyticsSortField sortField = sortFields.get(i);
                    if (sortField == null || sortField.getField() == null) continue;
                    if (i > 0) {
                        esQuery.append(",");
                    }
                    if ((direction = sortField.getDirection()) == null) {
                        direction = "desc";
                    }
                    esQuery.append("{ \"").append(sortField.getField()).append("\":{\"order\" : \"").append(direction).append("\"}}");
                }
                esQuery.append("]");
            }
        }
        this.appendSearchFilterConditions(filters, esQuery);
    }

    private void appendSearchFilterConditions(List<AnalyticsFieldFilter> filters, StringBuilder esQuery) {
        filters = filters == null ? new ArrayList<AnalyticsFieldFilter>() : new ArrayList<AnalyticsFieldFilter>(filters);
        filters.add(ES_TYPE_FILTER);
        esQuery.append(",");
        esQuery.append("    \"query\": {");
        esQuery.append("      \"bool\" : {");
        esQuery.append("        \"must\" : [");
        for (AnalyticsFieldFilter fieldFilter : filters) {
            String esFieldName = fieldFilter.getField();
            StatisticFieldMapping fieldMapping = this.esMappings.get(esFieldName);
            if (fieldMapping != null) {
                esFieldName = fieldMapping.getAggregationFieldName();
            }
            String esQueryValue = fieldMapping == null ? StatisticFieldMapping.computeESQueryValue((String)fieldFilter.getValueString()) : fieldMapping.getESQueryValue(fieldFilter.getValueString());
            switch (fieldFilter.getType()) {
                case NOT_NULL: {
                    esQuery.append("        {\"exists\" : {\"").append("field").append("\" : \"").append(esFieldName).append("\"      }},");
                    break;
                }
                case IS_NULL: {
                    esQuery.append("        {\"bool\": {\"must_not\": {\"exists\": {\"field\": \"").append(esFieldName).append("\"      }}}},");
                    break;
                }
                case EQUAL: {
                    esQuery.append("        {\"match\" : {\"").append(esFieldName).append("\" : ").append(esQueryValue).append("        }},");
                    break;
                }
                case NOT_EQUAL: {
                    esQuery.append("        {\"bool\": {\"must_not\": {\"match\" : {\"").append(esFieldName).append("\" : ").append(esQueryValue).append("        }}}},");
                    break;
                }
                case GREATER: {
                    esQuery.append("        {\"range\" : {\"").append(esFieldName).append("\" : {").append("\"gte\" : ").append(esQueryValue).append("        }}},");
                    break;
                }
                case LESS: {
                    esQuery.append("        {\"range\" : {\"").append(esFieldName).append("\" : {").append("\"lte\" : ").append(esQueryValue).append("        }}},");
                    break;
                }
                case RANGE: {
                    AnalyticsFilter.Range range = fieldFilter.getRange();
                    esQuery.append("        {\"range\" : {\"").append(esFieldName).append("\" : {").append("\"gte\" : ").append(range.getMin()).append(",\"lte\" : ").append(range.getMax()).append("        }}},");
                    break;
                }
                case IN_SET: {
                    esQuery.append("        {\"terms\" : {\"").append(esFieldName).append("\" : ").append(AnalyticsUtils.collectionToJSONString((String)fieldFilter.getValueString())).append("        }},");
                    break;
                }
                case NOT_IN_SET: {
                    esQuery.append("        {\"bool\": {\"must_not\": {\"terms\" : {\"").append(esFieldName).append("\" : ").append(AnalyticsUtils.collectionToJSONString((String)fieldFilter.getValueString())).append("        }}}},");
                    break;
                }
            }
        }
        esQuery.append("        ],");
        esQuery.append("      },");
        esQuery.append("     },");
    }

    private void buildAggregationQuery(StringBuilder esQuery, List<AnalyticsAggregation> aggregations) {
        if (aggregations != null && !aggregations.isEmpty()) {
            StringBuffer endOfQuery = new StringBuffer();
            for (AnalyticsAggregation analyticsAggregation : aggregations) {
                esQuery.append("     ,\"aggs\": {");
                String fieldName = null;
                AnalyticsAggregationType aggregationType = analyticsAggregation.getType();
                fieldName = AnalyticsAggregationType.COUNT == aggregationType || AnalyticsAggregationType.DATE == aggregationType || AnalyticsAggregationType.HISTOGRAM == aggregationType ? AGGREGATION_RESULT_PARAM : AGGREGATION_RESULT_VALUE_PARAM;
                esQuery.append("       \"").append(fieldName).append("\": {");
                esQuery.append("         \"").append(aggregationType.getName()).append("\": {");
                esQuery.append("           \"field\": \"").append(analyticsAggregation.getField()).append("\"");
                if (AnalyticsAggregationType.COUNT == aggregationType) {
                    esQuery.append("           ,\"size\": ").append(this.aggregationReturnedDocumentsSize);
                }
                if (aggregationType.isUseInterval()) {
                    if (StringUtils.isBlank((CharSequence)analyticsAggregation.getInterval())) {
                        throw new IllegalStateException("Analytics aggregation type '" + aggregationType + "' is using intervals while it has empty interval");
                    }
                    esQuery.append(",").append("           \"interval\": \"").append(analyticsAggregation.getInterval()).append("\"");
                } else if (aggregationType.allowSort()) {
                    String sortDirection = analyticsAggregation.getSortDirection() == null ? "asc" : analyticsAggregation.getSortDirection();
                    esQuery.append(",").append("           \"order\": {\"_term\": \"").append(sortDirection).append("\"}");
                }
                esQuery.append("         }");
                endOfQuery.append("       }");
                endOfQuery.append("     }");
            }
            esQuery.append(endOfQuery);
        }
    }

    private ChartDataList buildChartDataFromESResponse(AnalyticsFilter filter, String jsonResponse) throws JSONException {
        ChartDataList chartsData = new ChartDataList(filter.getLang());
        JSONObject json = new JSONObject(jsonResponse);
        JSONObject aggregations = json.getJSONObject("aggregations");
        if (aggregations == null) {
            return chartsData;
        }
        JSONObject hitsResult = (JSONObject)json.get("hits");
        chartsData.setComputingTime(json.getLong("took"));
        chartsData.setDataCount(hitsResult.getLong("total"));
        int level = filter.isMultipleCharts() ? -1 : 0;
        AnalyticsAggregation multipleChartsAggregation = filter.getMultipleChartsAggregation();
        this.computeAggregatedResultEntry(filter, aggregations, chartsData, multipleChartsAggregation, null, null, level);
        this.addEmptyResultsToNotExistingEntries(chartsData);
        return chartsData;
    }

    private void computeAggregatedResultEntry(AnalyticsFilter filter, JSONObject aggregations, ChartDataList chartsData, AnalyticsAggregation multipleChartsAggregation, ChartAggregationValue parentAggregation, ArrayList<ChartAggregationValue> aggregationValues, int level) throws JSONException {
        JSONObject aggsResult = aggregations.getJSONObject(AGGREGATION_RESULT_PARAM);
        JSONArray buckets = aggsResult.getJSONArray("buckets");
        String lang = filter.getLang();
        if (buckets.length() > 0) {
            int nextLevel = level + 1;
            for (int i = 0; i < buckets.length(); ++i) {
                String key;
                JSONObject bucketResult = buckets.getJSONObject(i);
                ArrayList<ChartAggregationValue> childAggregationValues = new ArrayList<ChartAggregationValue>();
                if (aggregationValues != null) {
                    childAggregationValues.addAll(aggregationValues);
                }
                if (bucketResult.isNull(AGGREGATION_RESULT_PARAM)) {
                    key = bucketResult.getString("key");
                    String result = null;
                    if (bucketResult.isNull(AGGREGATION_RESULT_VALUE_PARAM)) {
                        result = bucketResult.get("doc_count").toString();
                    } else {
                        JSONObject valueResult = bucketResult.getJSONObject(AGGREGATION_RESULT_VALUE_PARAM);
                        result = valueResult.get("value").toString();
                    }
                    this.addAggregationValue(key, filter, childAggregationValues, level);
                    List labels = childAggregationValues.stream().map(value -> value.getFieldLabel()).collect(Collectors.toList());
                    String label = StringUtils.join(labels, (String)AGGREGATION_KEYS_SEPARATOR);
                    ChartAggregationLabel chartLabel = new ChartAggregationLabel(childAggregationValues, label, lang);
                    ChartAggregationResult aggregationResult = new ChartAggregationResult(chartLabel, chartLabel.getLabel(), result);
                    chartsData.addAggregationResult(parentAggregation, aggregationResult);
                    continue;
                }
                key = bucketResult.getString("key");
                ChartAggregationValue parentAggregationToUse = parentAggregation;
                if (multipleChartsAggregation != null && level == -1) {
                    String fieldLabel = multipleChartsAggregation.getLabel(key, filter.getLang());
                    parentAggregationToUse = new ChartAggregationValue(multipleChartsAggregation, key, fieldLabel);
                } else {
                    this.addAggregationValue(key, filter, childAggregationValues, level);
                }
                this.computeAggregatedResultEntry(filter, bucketResult, chartsData, multipleChartsAggregation, parentAggregationToUse, childAggregationValues, nextLevel);
            }
        }
    }

    private void addAggregationValue(String key, AnalyticsFilter filter, ArrayList<ChartAggregationValue> aggregationValues, int level) {
        AnalyticsAggregation aggregation = null;
        if (filter.getXAxisAggregations().size() < level) {
            if (filter.getYAxisAggregation() == null) {
                throw new IllegalStateException("Can't find relative aggregation to index " + level);
            }
            aggregation = filter.getYAxisAggregation();
        } else {
            aggregation = (AnalyticsAggregation)filter.getXAxisAggregations().get(level);
        }
        String fieldLabel = null;
        fieldLabel = aggregation == null ? key : aggregation.getLabel(key, filter.getLang());
        ChartAggregationValue aggregationValue = new ChartAggregationValue(aggregation, key, fieldLabel);
        aggregationValues.add(aggregationValue);
    }

    private List<StatisticData> buildSearchResultFromESResponse(String jsonResponse) throws JSONException {
        ArrayList<StatisticData> results = new ArrayList<StatisticData>();
        JSONObject json = new JSONObject(jsonResponse);
        JSONObject jsonResult = (JSONObject)json.get("hits");
        if (jsonResult == null) {
            return results;
        }
        JSONArray jsonHits = jsonResult.getJSONArray("hits");
        for (int i = 0; i < jsonHits.length(); ++i) {
            JSONObject statisticDataJsonObject = jsonHits.getJSONObject(i).getJSONObject("_source");
            int statusOrdinal = statisticDataJsonObject.getInt("status");
            statisticDataJsonObject.put("status", (Object)StatisticData.StatisticStatus.values()[statusOrdinal]);
            StatisticData statisticData = (StatisticData)AnalyticsUtils.fromJsonString((String)statisticDataJsonObject.toString(), StatisticData.class);
            AnalyticsUtils.DEFAULT_FIELDS.stream().forEach(fieldName -> statisticDataJsonObject.remove(fieldName));
            statisticData.setParameters(new HashMap());
            Iterator remainingKeys = statisticDataJsonObject.keys();
            while (remainingKeys.hasNext()) {
                String key = (String)remainingKeys.next();
                statisticData.getParameters().put(key, statisticDataJsonObject.getString(key));
            }
            results.add(statisticData);
        }
        return results;
    }

    private void readFieldsMapping() {
        SettingValue existingMapping = this.settingService.get(CONTEXT, ES_SCOPE, ES_AGGREGATED_MAPPING);
        if (existingMapping == null) {
            return;
        }
        String esMappingSerialized = existingMapping.getValue().toString();
        try {
            JSONObject jsonObject = new JSONObject(esMappingSerialized);
            Iterator keys = jsonObject.keys();
            while (keys.hasNext()) {
                String key = keys.next().toString();
                String fieldMappingString = jsonObject.getString(key);
                StatisticFieldMapping fieldMapping = (StatisticFieldMapping)AnalyticsUtils.fromJsonString((String)fieldMappingString, StatisticFieldMapping.class);
                this.esMappings.put(key, fieldMapping);
            }
        }
        catch (JSONException e) {
            LOG.error((Object)"Error reading ES mapped fields", (Throwable)e);
        }
    }

    private void storeFieldsMappings() throws JSONException {
        JSONObject jsonObject = new JSONObject();
        Set<String> keys = this.esMappings.keySet();
        for (String key : keys) {
            jsonObject.put(key, (Object)AnalyticsUtils.toJsonString((Object)this.esMappings.get(key)));
        }
        this.settingService.set(CONTEXT, ES_SCOPE, ES_AGGREGATED_MAPPING, SettingValue.create((String)jsonObject.toString()));
    }

    private void addEmptyResultsToNotExistingEntries(ChartDataList chartsData) {
        LinkedHashSet aggregationLabels = chartsData.getAggregationLabels();
        int index = 0;
        for (ChartAggregationLabel chartAggregationLabel : aggregationLabels) {
            ChartAggregationResult emptyResult = new ChartAggregationResult(chartAggregationLabel, chartAggregationLabel.getLabel(), null);
            LinkedHashSet charts = chartsData.getCharts();
            for (ChartData chartData : charts) {
                chartData.addAggregationResult(emptyResult, index, false);
            }
            ++index;
        }
    }
}

