/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.analytics.listener.tasks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.analytics.model.StatisticData;
import org.exoplatform.analytics.utils.AnalyticsUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.task.domain.Label;
import org.exoplatform.task.domain.Project;
import org.exoplatform.task.domain.Task;
import org.exoplatform.task.legacy.service.ProjectService;
import org.exoplatform.task.legacy.service.TaskPayload;
import org.exoplatform.task.legacy.service.TaskService;

public class TaskSavedListener
extends Listener<TaskService, TaskPayload> {
    private static final Log LOG = ExoLogger.getLogger(TaskSavedListener.class);
    private PortalContainer container = PortalContainer.getInstance();
    private ProjectService projectService;
    private TaskService taskService;
    private IdentityManager identityManager;
    private SpaceService spaceService;
    private final String operation;

    public TaskSavedListener(InitParams params) {
        this.operation = params.getValueParam("operation").getValue();
    }

    public void onEvent(Event<TaskService, TaskPayload> event) throws Exception {
        TaskPayload data = (TaskPayload)event.getData();
        Task oldTask = data.before();
        Task newTask = data.after();
        ConversationState conversationstate = ConversationState.getCurrent();
        String modifierUsername = conversationstate == null || conversationstate.getIdentity() == null ? null : conversationstate.getIdentity().getUserId();
        CompletableFuture.supplyAsync(() -> {
            ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
            RequestLifeCycle.begin((ExoContainer)this.container);
            try {
                long userIdentityId = this.getUserIdentityId(modifierUsername);
                ListAccess taskLabelsListAccess = this.getTaskService().findLabelsByTask(newTask.getId(), modifierUsername);
                int labelsSize = taskLabelsListAccess.getSize();
                List<Object> taskLabels = null;
                taskLabels = labelsSize > 0 ? Arrays.asList(taskLabelsListAccess.load(0, labelsSize)) : Collections.emptyList();
                this.createTaskStatistic(oldTask, newTask, taskLabels, userIdentityId);
            }
            catch (Exception e) {
                LOG.warn((Object)"Error computing task statistics", (Throwable)e);
            }
            finally {
                RequestLifeCycle.end();
            }
            return null;
        });
    }

    private void createTaskStatistic(Task oldTask, Task newTask, List<Label> taskLabels, long userIdentityId) {
        StatisticData statisticData = new StatisticData();
        statisticData.setModule("tasks");
        statisticData.setSubModule("task");
        statisticData.setUserId(userIdentityId);
        Space space = this.getSpaceOfProject(newTask);
        long spaceId = 0L;
        String spaceTemplate = null;
        if (space != null) {
            spaceId = Long.parseLong(space.getId());
            spaceTemplate = space.getTemplate();
        }
        statisticData.setSpaceId(spaceId);
        statisticData.addParameter("spaceTemplate", (Object)spaceTemplate);
        statisticData.addParameter("taskId", (Object)newTask.getId());
        List taskLabelIds = taskLabels.stream().map(Label::getId).collect(Collectors.toList());
        statisticData.addParameter("taskLabelIds", taskLabelIds);
        this.appendTaskProperties(statisticData, newTask, null);
        String taskOperation = this.computeTaskOperation(oldTask, newTask);
        statisticData.setOperation(taskOperation);
        AnalyticsUtils.addStatisticData((StatisticData)statisticData);
    }

    private String computeTaskOperation(Task oldTask, Task newTask) {
        String taskOperation = this.operation;
        if (oldTask != null) {
            if (this.isDiff(oldTask.isCompleted(), newTask.isCompleted())) {
                taskOperation = "taskCompleted";
            } else if (this.isDiff(oldTask.getDescription(), newTask.getDescription())) {
                taskOperation = "taskDescriptionChanged";
            } else if (this.isDiff(oldTask.getTitle(), newTask.getTitle())) {
                taskOperation = "taskTitleChanged";
            } else if (this.isDiff(oldTask.getDueDate(), newTask.getDueDate())) {
                taskOperation = "taskDueDateChanged";
            } else if (this.isDiff(oldTask.getPriority(), newTask.getPriority())) {
                taskOperation = "taskPriorityChanged";
            } else if (this.isDiff(oldTask.getRank(), newTask.getRank())) {
                taskOperation = "taskRankChanged";
            } else if (this.isDiff(oldTask.getAssignee(), newTask.getAssignee())) {
                taskOperation = "taskAssigneeChanged";
            } else if (this.isDiff(oldTask.getCoworker(), newTask.getCoworker())) {
                taskOperation = "taskCoworderChanged";
            } else if (oldTask.getStatus() != null && newTask.getStatus() != null && oldTask.getStatus().getProject() != null && newTask.getStatus().getProject() != null && this.isDiff(oldTask.getStatus().getProject().getId(), newTask.getStatus().getProject().getId())) {
                taskOperation = "taskProjectChanged";
            } else if (oldTask.getStatus() != null && newTask.getStatus() != null && this.isDiff(oldTask.getStatus().getName(), newTask.getStatus().getName())) {
                taskOperation = "taskStatusChanged";
            } else if (this.isDiff(oldTask.getStartDate(), newTask.getStartDate()) || this.isDiff(oldTask.getEndDate(), newTask.getEndDate())) {
                taskOperation = "taskDatesChanged";
            }
        }
        return taskOperation;
    }

    private void appendTaskProperties(StatisticData statisticData, Task task, String prefix) {
        Project project;
        if (task == null) {
            return;
        }
        if (prefix == null) {
            prefix = "";
        }
        Project project2 = project = task.getStatus() == null ? null : task.getStatus().getProject();
        if (project != null) {
            statisticData.addParameter(prefix + "projectId", (Object)project.getId());
        }
        statisticData.addParameter(prefix + "activityId", (Object)task.getActivityId());
        long assigneeId = this.getUserIdentityId(task.getAssignee());
        statisticData.addParameter(prefix + "assigneeId", (Object)assigneeId);
        ArrayList<Long> assigneeIds = new ArrayList<Long>();
        assigneeIds.add(assigneeId);
        Set coworkers = task.getCoworker();
        if (coworkers != null && !coworkers.isEmpty()) {
            ArrayList coworkerIds = new ArrayList();
            coworkers.forEach(coworker -> {
                long coworderId = this.getUserIdentityId((String)coworker);
                coworkerIds.add(coworderId);
            });
            statisticData.addParameter(prefix + "coworkerIds", coworkerIds);
            assigneeIds.addAll(coworkerIds);
        }
        statisticData.addParameter(prefix + "assigneeIds", assigneeIds);
        statisticData.addParameter(prefix + "creatorId", (Object)this.getUserIdentityId(task.getCreatedBy()));
        statisticData.addParameter(prefix + "rank", (Object)task.getRank());
        if (task.getDueDate() != null) {
            statisticData.addParameter(prefix + "dueDate", (Object)task.getDueDate());
        }
        if (task.getCreatedTime() != null) {
            statisticData.addParameter(prefix + "createdTime", (Object)task.getCreatedTime());
        }
        if (task.getStartDate() != null) {
            statisticData.addParameter(prefix + "startDate", (Object)task.getStartDate());
        }
        if (task.getEndDate() != null) {
            statisticData.addParameter(prefix + "endDate", (Object)task.getEndDate());
        }
        if (task.getPriority() != null) {
            statisticData.addParameter(prefix + "priority", (Object)task.getPriority().name());
        }
        if (task.getTitle() != null) {
            statisticData.addParameter(prefix + "titleLength", (Object)task.getTitle().length());
        }
        if (task.getDescription() != null) {
            statisticData.addParameter(prefix + "descriptionLength", (Object)task.getDescription().length());
        }
        if (task.getStatus() != null) {
            statisticData.addParameter(prefix + "statusId", (Object)task.getStatus().getId());
            statisticData.addParameter(prefix + "statusName", (Object)task.getStatus().getName());
            statisticData.addParameter(prefix + "statusRank", (Object)task.getStatus().getRank());
        }
    }

    private Space getSpaceOfProject(Task task) {
        Project project;
        if (task == null) {
            return null;
        }
        Project project2 = project = task.getStatus() == null ? null : task.getStatus().getProject();
        if (project == null) {
            return null;
        }
        Space space = null;
        Space spaceByManagerGroupId = null;
        for (String permission : this.getProjectService().getManager(project.getId())) {
            int index = permission.indexOf(58);
            if (index <= -1) continue;
            String groupId = permission.substring(index + 1);
            spaceByManagerGroupId = this.getSpaceService().getSpaceByGroupId(groupId);
        }
        if (spaceByManagerGroupId == null) {
            String projectName = project.getName();
            space = this.getSpaceService().getSpaceByDisplayName(projectName);
        } else {
            space = spaceByManagerGroupId;
        }
        return space;
    }

    private boolean isDiff(Object before, Object after) {
        return !Objects.equals(before, after);
    }

    private long getUserIdentityId(String username) {
        if (StringUtils.isBlank((CharSequence)username)) {
            return 0L;
        }
        Identity userIdentity = this.getIdentityManager().getOrCreateIdentity("organization", username);
        if (userIdentity == null) {
            return 0L;
        }
        return Long.parseLong(userIdentity.getId());
    }

    private SpaceService getSpaceService() {
        if (this.spaceService == null) {
            this.spaceService = (SpaceService)this.container.getComponentInstanceOfType(SpaceService.class);
        }
        return this.spaceService;
    }

    private IdentityManager getIdentityManager() {
        if (this.identityManager == null) {
            this.identityManager = (IdentityManager)this.container.getComponentInstanceOfType(IdentityManager.class);
        }
        return this.identityManager;
    }

    private ProjectService getProjectService() {
        if (this.projectService == null) {
            this.projectService = (ProjectService)this.container.getComponentInstanceOfType(ProjectService.class);
        }
        return this.projectService;
    }

    private TaskService getTaskService() {
        if (this.taskService == null) {
            this.taskService = (TaskService)this.container.getComponentInstanceOfType(TaskService.class);
        }
        return this.taskService;
    }
}

