/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.analytics.listener.websocket;

import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.analytics.api.service.AnalyticsService;
import org.exoplatform.analytics.api.service.StatisticWatcher;
import org.exoplatform.analytics.api.websocket.AnalyticsWebSocketMessage;
import org.exoplatform.analytics.api.websocket.AnalyticsWebSocketService;
import org.exoplatform.analytics.model.StatisticData;
import org.exoplatform.analytics.utils.AnalyticsUtils;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

@Asynchronous
public class WebSocketUIStatisticListener
extends Listener<AnalyticsWebSocketService, AnalyticsWebSocketMessage> {
    private static final Log LOG = ExoLogger.getLogger(WebSocketUIStatisticListener.class);
    private AnalyticsService analyticsService;

    public WebSocketUIStatisticListener(AnalyticsService analyticsService) {
        this.analyticsService = analyticsService;
    }

    public void onEvent(Event<AnalyticsWebSocketService, AnalyticsWebSocketMessage> event) throws Exception {
        HashMap<String, String> data;
        AnalyticsWebSocketMessage message = (AnalyticsWebSocketMessage)event.getData();
        long userId = AnalyticsUtils.getUserIdentityId((String)message.getUserName());
        if (userId <= 0L) {
            LOG.debug("User not found in state, userId= {} ", new Object[]{userId});
            return;
        }
        StatisticWatcher uiWatcher = this.analyticsService.getUIWatcher(message.getName());
        if (uiWatcher == null) {
            LOG.warn("Can't find watcher with name '{}'", new Object[]{message.getName()});
            return;
        }
        StatisticData statisticData = new StatisticData();
        statisticData.setModule("portal");
        statisticData.setSubModule("ui");
        statisticData.setOperation(uiWatcher.getOperation());
        statisticData.setUserId(userId);
        if (StringUtils.isNotBlank((CharSequence)message.getSpaceId())) {
            statisticData.setSpaceId(Long.parseLong(message.getSpaceId()));
        }
        if ((data = message.getParameters()) == null) {
            data = new HashMap<String, String>();
        }
        data.put("portalUri", message.getPortalUri());
        data.put("watcher", message.getName());
        if (uiWatcher.getParameters() != null && !uiWatcher.getParameters().isEmpty()) {
            data.putAll(uiWatcher.getParameters());
        }
        statisticData.setParameters(data);
        AnalyticsUtils.addStatisticData((StatisticData)statisticData);
    }
}

