/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.analytics.es;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.exoplatform.analytics.es.AnalyticsIndexingServiceConnector;
import org.exoplatform.analytics.model.StatisticDataQueueEntry;
import org.exoplatform.commons.search.es.client.ElasticClient;
import org.exoplatform.commons.search.es.client.ElasticClientException;
import org.exoplatform.commons.search.es.client.ElasticContentRequestBuilder;
import org.exoplatform.commons.search.es.client.ElasticIndexingAuditTrail;
import org.exoplatform.commons.search.es.client.ElasticResponse;
import org.exoplatform.commons.search.index.impl.ElasticIndexingServiceConnector;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.json.JSONException;
import org.json.JSONObject;

public class AnalyticsESClient
extends ElasticClient {
    private static final Log LOG = ExoLogger.getExoLogger(AnalyticsESClient.class);
    private static final String DEFAULT_ES_CLIENT_SERVER_URL = "http://127.0.0.1:9200";
    private static final String ES_CLIENT_SERVER_URL = "exo.es.index.server.url";
    private static final String ES_CLIENT_USERNAME = "exo.es.index.server.username";
    private static final String ES_CLIENT_PWD = "exo.es.index.server.password";
    private static final String ES_ANALYTICS_CLIENT_SERVER_URL = "exo.es.analytics.index.server.url";
    private static final String ES_ANALYTICS_CLIENT_USERNAME = "exo.es.analytics.index.server.username";
    private static final String ES_ANALYTICS_CLIENT_PWD = "exo.es.analytics.index.server.password";
    private AnalyticsIndexingServiceConnector analyticsIndexingConnector;
    private ElasticContentRequestBuilder elasticContentRequestBuilder;
    private Set<String> existingIndexes = new HashSet<String>();
    protected String username;
    private String password;

    public AnalyticsESClient(ElasticIndexingAuditTrail auditTrail, ElasticContentRequestBuilder elasticContentRequestBuilder, AnalyticsIndexingServiceConnector analyticsIndexingConnector, InitParams initParams) {
        super(auditTrail);
        this.analyticsIndexingConnector = analyticsIndexingConnector;
        this.elasticContentRequestBuilder = elasticContentRequestBuilder;
        if (initParams != null) {
            if (initParams.containsKey((Object)ES_ANALYTICS_CLIENT_SERVER_URL)) {
                this.urlClient = initParams.getValueParam(ES_ANALYTICS_CLIENT_SERVER_URL).getValue();
            }
            if (initParams.containsKey((Object)ES_ANALYTICS_CLIENT_USERNAME)) {
                this.username = initParams.getValueParam(ES_ANALYTICS_CLIENT_USERNAME).getValue();
            }
            if (initParams.containsKey((Object)ES_ANALYTICS_CLIENT_PWD)) {
                this.password = initParams.getValueParam(ES_ANALYTICS_CLIENT_PWD).getValue();
            }
        }
        if (StringUtils.isBlank((String)this.urlClient)) {
            this.urlClient = System.getProperty(ES_CLIENT_SERVER_URL);
            this.username = System.getProperty(ES_CLIENT_USERNAME);
            this.password = System.getProperty(ES_CLIENT_PWD);
        }
        if (StringUtils.isBlank((String)this.urlClient)) {
            this.urlClient = DEFAULT_ES_CLIENT_SERVER_URL;
        }
    }

    public boolean sendCreateIndexRequest(String index) {
        if (this.sendIsIndexExistsRequest(index)) {
            LOG.debug("Index {} already exists. Index creation requests will not be sent.", new Object[]{index});
            return false;
        }
        String indexURL = this.urlClient + "/" + index;
        String esIndexSettings = this.elasticContentRequestBuilder.getCreateIndexRequestContent((ElasticIndexingServiceConnector)this.analyticsIndexingConnector);
        this.sendHttpPutRequest(indexURL, esIndexSettings);
        String esTypeURL = this.urlClient + "/" + index + "/_mapping/" + this.analyticsIndexingConnector.getType();
        this.sendHttpPutRequest(esTypeURL, this.analyticsIndexingConnector.getMapping());
        if (this.sendIsIndexExistsRequest(index)) {
            LOG.info("Index {} created.", new Object[]{index});
        } else {
            LOG.warn("Index {} seems not created successfully on ES.", new Object[]{index});
        }
        return true;
    }

    public boolean sendIsIndexExistsRequest(String esIndex) {
        boolean indexExists;
        if (this.existingIndexes.contains(esIndex)) {
            return true;
        }
        ElasticResponse responseExists = this.sendHttpGetRequest(this.urlClient + "/" + esIndex);
        boolean bl = indexExists = responseExists.getStatusCode() == 200;
        if (indexExists) {
            this.existingIndexes.add(esIndex);
        }
        return indexExists;
    }

    public void sendDeleteIndexRequest(String index) {
        this.sendHttpDeleteRequest(this.urlClient + "/" + index);
    }

    public void sendCreateBulkDocumentsRequest(List<StatisticDataQueueEntry> dataQueueEntries) {
        if (dataQueueEntries == null || dataQueueEntries.isEmpty()) {
            return;
        }
        LOG.info("Indexing in bulk {} documents", new Object[]{dataQueueEntries.size()});
        this.checkIndexExistence(dataQueueEntries);
        StringBuilder request = new StringBuilder();
        HashSet<String> indexesToUpdate = new HashSet<String>();
        for (StatisticDataQueueEntry statisticDataQueueEntry : dataQueueEntries) {
            String documentId = String.valueOf(statisticDataQueueEntry.getId());
            String singleDocumentQuery = this.elasticContentRequestBuilder.getCreateDocumentRequestContent((ElasticIndexingServiceConnector)this.analyticsIndexingConnector, documentId);
            String index = this.analyticsIndexingConnector.getIndex(statisticDataQueueEntry.getStatisticData().getTimestamp());
            singleDocumentQuery = this.analyticsIndexingConnector.replaceByIndexName(singleDocumentQuery, index);
            request.append(singleDocumentQuery);
            indexesToUpdate.add(index);
        }
        LOG.debug("Create documents request to ES: {}", new Object[]{request});
        String indexDocumentURL = this.urlClient + "/_bulk";
        this.sendHttpPutRequest(indexDocumentURL, request.toString());
        for (String index : indexesToUpdate) {
            this.refreshIndex(index);
        }
    }

    public String sendRequest(String esQuery) {
        String url = this.urlClient + "/_search";
        ElasticResponse elasticResponse = this.sendHttpPostRequest(url, esQuery);
        String response = elasticResponse.getMessage();
        int statusCode = elasticResponse.getStatusCode();
        if (ElasticIndexingAuditTrail.isError((Integer)statusCode) || StringUtils.isBlank((String)response)) {
            if (StringUtils.isBlank((String)response)) {
                response = "Empty response was sent by ES";
            }
        } else {
            JSONObject json = null;
            try {
                json = new JSONObject(response);
                if (json.has("status") && ElasticIndexingAuditTrail.isError((Integer)json.getInt("status"))) {
                    throw new IllegalStateException("Error occured while requesting ES HTTP error code: '" + statusCode + "', HTTP response: '" + response + "'");
                }
            }
            catch (JSONException e) {
                throw new IllegalStateException("Error occured while requesting ES HTTP code: '" + statusCode + "', Error parsing response to JSON format, content = '" + response + "'", e);
            }
        }
        return response;
    }

    public String getMapping(long timestamp) {
        String esIndex = this.analyticsIndexingConnector.getIndex(timestamp);
        if (!this.sendIsIndexExistsRequest(esIndex)) {
            return null;
        }
        String url = this.urlClient + "/" + esIndex + "/_mapping";
        ElasticResponse response = this.sendHttpGetRequest(url);
        if (ElasticIndexingAuditTrail.isError((Integer)response.getStatusCode())) {
            LOG.warn("Error getting mapping of analytics : - \t\tcode : {} - \t\tmessage: {}", new Object[]{response.getStatusCode(), response.getMessage()});
            return null;
        }
        return response.getMessage();
    }

    protected ElasticResponse sendHttpPutRequest(String url, String content) {
        ElasticResponse response = super.sendHttpPutRequest(url, content);
        try {
            this.handleESResponse(response);
        }
        catch (Exception e) {
            throw new ElasticClientException("Error sending PUT request '" + url + "' with content = '" + content + "'", (Throwable)e);
        }
        return response;
    }

    protected ElasticResponse sendHttpDeleteRequest(String url) {
        ElasticResponse response = super.sendHttpDeleteRequest(url);
        try {
            this.handleESResponse(response);
        }
        catch (Exception e) {
            throw new ElasticClientException("Error sending 'DELETE' request '" + url + "'", (Throwable)e);
        }
        return response;
    }

    protected ElasticResponse sendHttpPostRequest(String url, String content) {
        ElasticResponse response = super.sendHttpPostRequest(url, content);
        try {
            this.handleESResponse(response);
        }
        catch (Exception e) {
            throw new ElasticClientException("Error sending POST request '" + url + "' with content = '" + content + "'", (Throwable)e);
        }
        return response;
    }

    protected String getEsUsernameProperty() {
        return this.username;
    }

    protected String getEsPasswordProperty() {
        return this.password;
    }

    protected HttpClientConnectionManager getClientConnectionManager() {
        return new PoolingHttpClientConnectionManager();
    }

    private void handleESResponse(ElasticResponse response) {
        if (response.getStatusCode() != 200) {
            throw new ElasticClientException(response.getMessage());
        }
        if (StringUtils.contains((String)response.getMessage(), (String)"\"type\":\"version_conflict_engine_exception\"")) {
            LOG.warn("ID conflict in some content", new Object[]{response.getMessage()});
            return;
        }
        if (response.getStatusCode() != 200 || StringUtils.contains((String)response.getMessage(), (String)"\"errors\":true")) {
            throw new ElasticClientException(response.getMessage());
        }
    }

    private void checkIndexExistence(List<StatisticDataQueueEntry> dataQueueEntries) {
        HashSet<String> indexes = new HashSet<String>();
        for (StatisticDataQueueEntry statisticDataQueueEntry : dataQueueEntries) {
            long timestamp = statisticDataQueueEntry.getStatisticData().getTimestamp();
            indexes.add(this.analyticsIndexingConnector.getIndex(timestamp));
        }
        for (String index : indexes) {
            this.sendCreateIndexRequest(index);
        }
    }

    private void refreshIndex(String index) {
        String indexRefreshURL = this.urlClient + "/" + index + "/_refresh";
        this.sendHttpPostRequest(indexRefreshURL, null);
    }
}

