/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.analytics.es;

import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.analytics.api.service.StatisticDataQueueService;
import org.exoplatform.analytics.model.StatisticData;
import org.exoplatform.commons.search.domain.Document;
import org.exoplatform.commons.search.index.impl.ElasticIndexingServiceConnector;
import org.exoplatform.commons.utils.IOUtil;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class AnalyticsIndexingServiceConnector
extends ElasticIndexingServiceConnector {
    private static final long serialVersionUID = -3143010828698498081L;
    private static final Log LOG = ExoLogger.getLogger(AnalyticsIndexingServiceConnector.class);
    private static final String MAPPING_FILE_PATH_PARAM = "mapping.file.path";
    private static final String ES_INDEX_PLACEHOLDER = "@ES_INDEX_PLACEHOLDER@";
    private static final String DEFAULT_ES_ANALYTICS_INDEX_NAME = "analytics";
    private static final String ES_ANALYTICS_TYPE = "analytics";
    private static final String ES_ANALYTICS_INDEX_PER_DAYS = "exo.es.analytics.index.per.days";
    private static final String ES_ANALYTICS_INDEX_PREFIX = "exo.es.analytics.index.prefix";
    private static final long DAY_IN_MS = 86400000L;
    private transient StatisticDataQueueService analyticsQueueService;
    private String esInitialMapping;
    private String indexPrefix;
    private int indexPerDays;

    public AnalyticsIndexingServiceConnector(ConfigurationManager configurationManager, StatisticDataQueueService analyticsQueueService, InitParams initParams) {
        super(initParams);
        this.analyticsQueueService = analyticsQueueService;
        if (initParams != null) {
            if (initParams.containsKey((Object)MAPPING_FILE_PATH_PARAM)) {
                String mappingFilePath = initParams.getValueParam(MAPPING_FILE_PATH_PARAM).getValue();
                try {
                    InputStream mappingFileIS = configurationManager.getInputStream(mappingFilePath);
                    this.esInitialMapping = IOUtil.getStreamContentAsString((InputStream)mappingFileIS);
                }
                catch (Exception e) {
                    LOG.error("Can't read elasticsearch index mapping from path {}", new Object[]{mappingFilePath, e});
                }
            }
            if (initParams.containsKey((Object)ES_ANALYTICS_INDEX_PER_DAYS)) {
                this.indexPerDays = Integer.parseInt(initParams.getValueParam(ES_ANALYTICS_INDEX_PER_DAYS).getValue());
            }
            if (initParams.containsKey((Object)ES_ANALYTICS_INDEX_PREFIX)) {
                this.indexPrefix = initParams.getValueParam(ES_ANALYTICS_INDEX_PREFIX).getValue();
            }
        }
        if (StringUtils.isBlank((CharSequence)this.indexPrefix)) {
            this.indexPrefix = "analytics";
        }
        if (StringUtils.isBlank((CharSequence)this.esInitialMapping)) {
            LOG.error((Object)"Empty elasticsearch index mapping file path parameter");
        }
    }

    public String getIndex() {
        return ES_INDEX_PLACEHOLDER;
    }

    public String getType() {
        return "analytics";
    }

    public String getMapping() {
        return this.esInitialMapping;
    }

    public Document create(String idString) {
        if (StringUtils.isBlank((CharSequence)idString)) {
            throw new IllegalArgumentException("id is mandatory");
        }
        long id = Long.parseLong(idString);
        StatisticData data = this.analyticsQueueService.get(id);
        if (data == null) {
            LOG.warn("Can't find document with id {}", new Object[]{id});
            return null;
        }
        String timestampString = String.valueOf(data.getTimestamp());
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("id", idString);
        fields.put("timestamp", timestampString);
        fields.put("userId", String.valueOf(data.getUserId()));
        fields.put("spaceId", String.valueOf(data.getSpaceId()));
        fields.put("module", data.getModule());
        fields.put("subModule", data.getSubModule());
        fields.put("operation", data.getOperation());
        fields.put("status", String.valueOf(data.getStatus().ordinal()));
        fields.put("errorCode", String.valueOf(data.getErrorCode()));
        fields.put("errorMessage", data.getErrorMessage());
        fields.put("duration", String.valueOf(data.getDuration()));
        fields.put("isAnalytics", "true");
        if (data.getParameters() != null && !data.getParameters().isEmpty()) {
            fields.putAll(data.getParameters());
        }
        Document esDocument = new Document("analytics", String.valueOf(id), null, null, (Set)null, fields);
        if (data.getListParameters() != null && !data.getListParameters().isEmpty()) {
            esDocument.setListFields(data.getListParameters());
        }
        return esDocument;
    }

    public Document update(String id) {
        throw new UnsupportedOperationException();
    }

    public List<String> getAllIds(int offset, int limit) {
        throw new UnsupportedOperationException();
    }

    public final String getIndex(long timestamp) {
        if (this.indexPerDays > 0) {
            long indexSuffix = timestamp / (86400000L * (long)this.indexPerDays);
            return this.indexPrefix + "_" + indexSuffix;
        }
        return this.indexPrefix;
    }

    public String replaceByIndexName(String esQuery, String index) {
        return esQuery.replace(ES_INDEX_PLACEHOLDER, index);
    }
}

