/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.analytics.listener.websocket;

import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.analytics.api.service.AnalyticsService;
import org.exoplatform.analytics.api.service.StatisticWatcher;
import org.exoplatform.analytics.api.websocket.AnalyticsWebSocketMessage;
import org.exoplatform.analytics.api.websocket.AnalyticsWebSocketService;
import org.exoplatform.analytics.model.StatisticData;
import org.exoplatform.analytics.utils.AnalyticsUtils;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.space.model.Space;

@Asynchronous
public class WebSocketUIStatisticListener
extends Listener<AnalyticsWebSocketService, AnalyticsWebSocketMessage> {
    private static final Log LOG = ExoLogger.getLogger(WebSocketUIStatisticListener.class);
    private AnalyticsService analyticsService;

    public WebSocketUIStatisticListener(AnalyticsService analyticsService) {
        this.analyticsService = analyticsService;
    }

    public void onEvent(Event<AnalyticsWebSocketService, AnalyticsWebSocketMessage> event) throws Exception {
        Space space;
        AnalyticsWebSocketMessage message = (AnalyticsWebSocketMessage)event.getData();
        long userId = AnalyticsUtils.getUserIdentityId((String)message.getUserName());
        if (userId <= 0L) {
            LOG.debug("User not found in state, userId= {} ", new Object[]{userId});
            return;
        }
        StatisticData statisticData = new StatisticData();
        if (StringUtils.isNotBlank((CharSequence)message.getSpaceId())) {
            space = AnalyticsUtils.getSpaceById((String)message.getSpaceId());
            AnalyticsUtils.addSpaceStatistics((StatisticData)statisticData, (Space)space);
        } else if (StringUtils.isNotBlank((CharSequence)message.getSpacePrettyName())) {
            space = AnalyticsUtils.getSpaceByPrettyName((String)message.getSpacePrettyName());
            AnalyticsUtils.addSpaceStatistics((StatisticData)statisticData, (Space)space);
        }
        String module = null;
        String subModule = null;
        String operation = null;
        HashMap<String, String> data = message.getParameters();
        if (data == null) {
            data = new HashMap<String, String>();
        }
        if (StringUtils.isNotBlank((CharSequence)message.getName())) {
            StatisticWatcher uiWatcher = this.analyticsService.getUIWatcher(message.getName());
            if (uiWatcher == null) {
                LOG.warn("Can't find watcher with name '{}'", new Object[]{message.getName()});
                return;
            }
            module = uiWatcher.getModule() == null ? "portal" : uiWatcher.getModule();
            subModule = uiWatcher.getSubModule() == null ? "ui" : uiWatcher.getSubModule();
            operation = uiWatcher.getOperation();
            if (uiWatcher.getParameters() != null && !uiWatcher.getParameters().isEmpty()) {
                data.putAll(uiWatcher.getParameters());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)message.getModule())) {
            module = message.getModule();
        }
        if (StringUtils.isNotBlank((CharSequence)message.getSubModule())) {
            subModule = message.getSubModule();
        }
        if (StringUtils.isNotBlank((CharSequence)message.getOperation())) {
            operation = message.getOperation();
        }
        statisticData.setModule(module);
        statisticData.setSubModule(subModule);
        statisticData.setOperation(operation);
        statisticData.setUserId(userId);
        if (StringUtils.isNotBlank((CharSequence)message.getPortalUri())) {
            data.put("portalUri", message.getPortalUri());
        }
        if (StringUtils.isNotBlank((CharSequence)message.getName())) {
            data.put("watcher", message.getName());
        }
        statisticData.setParameters(data);
        AnalyticsUtils.addStatisticData((StatisticData)statisticData);
    }
}

