/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.analytics.model.filter;

import groovy.transform.ToString;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.analytics.model.filter.AnalyticsFilter;
import org.exoplatform.analytics.model.filter.aggregation.AnalyticsAggregation;
import org.exoplatform.analytics.model.filter.search.AnalyticsFieldFilter;
import org.exoplatform.analytics.model.filter.search.AnalyticsFieldFilterType;

@ToString
public class AnalyticsPercentageItemFilter
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 2412056356203118469L;
    private List<AnalyticsFieldFilter> filters = new ArrayList<AnalyticsFieldFilter>();
    private AnalyticsAggregation yAxisAggregation = null;

    public void addNotEqualFilter(String field, String value) {
        AnalyticsFieldFilter fieldFilter = new AnalyticsFieldFilter(field, AnalyticsFieldFilterType.NOT_EQUAL, String.valueOf(value));
        this.filters.add(fieldFilter);
    }

    public void addEqualFilter(String field, String value) {
        AnalyticsFieldFilter fieldFilter = new AnalyticsFieldFilter(field, AnalyticsFieldFilterType.EQUAL, String.valueOf(value));
        this.filters.add(fieldFilter);
    }

    public void addInSetFilter(String field, String ... values) {
        if (values != null && values.length > 0) {
            AnalyticsFieldFilter fieldFilter = new AnalyticsFieldFilter(field, AnalyticsFieldFilterType.IN_SET, StringUtils.join((Object[])values, (String)","));
            this.filters.add(fieldFilter);
        }
    }

    public void addNotInSetFilter(String field, String ... values) {
        if (values != null && values.length > 0) {
            AnalyticsFieldFilter fieldFilter = new AnalyticsFieldFilter(field, AnalyticsFieldFilterType.NOT_IN_SET, StringUtils.join((Object[])values, (String)","));
            this.filters.add(fieldFilter);
        }
    }

    public void addRangeFilter(String field, String start, String end) {
        AnalyticsFieldFilter fieldFilter = new AnalyticsFieldFilter(field, AnalyticsFieldFilterType.RANGE, new AnalyticsFilter.Range(start, end));
        this.filters.add(fieldFilter);
    }

    public void addGreaterFilter(String field, long value) {
        AnalyticsFieldFilter fieldFilter = new AnalyticsFieldFilter(field, AnalyticsFieldFilterType.GREATER, String.valueOf(value));
        this.filters.add(fieldFilter);
    }

    public void addLessFilter(String field, long value) {
        AnalyticsFieldFilter fieldFilter = new AnalyticsFieldFilter(field, AnalyticsFieldFilterType.LESS, String.valueOf(value));
        this.filters.add(fieldFilter);
    }

    public AnalyticsPercentageItemFilter clone() {
        List<AnalyticsFieldFilter> clonedFilters = new ArrayList<AnalyticsFieldFilter>(this.filters).stream().map(AnalyticsFieldFilter::clone).collect(Collectors.toList());
        AnalyticsAggregation cloneyAggregation = this.yAxisAggregation == null ? null : this.yAxisAggregation.clone();
        return new AnalyticsPercentageItemFilter(clonedFilters, cloneyAggregation);
    }

    public List<AnalyticsFieldFilter> getFilters() {
        return this.filters;
    }

    public AnalyticsAggregation getYAxisAggregation() {
        return this.yAxisAggregation;
    }

    public void setFilters(List<AnalyticsFieldFilter> filters) {
        this.filters = filters;
    }

    public void setYAxisAggregation(AnalyticsAggregation yAxisAggregation) {
        this.yAxisAggregation = yAxisAggregation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AnalyticsPercentageItemFilter)) {
            return false;
        }
        AnalyticsPercentageItemFilter other = (AnalyticsPercentageItemFilter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<AnalyticsFieldFilter> this$filters = this.getFilters();
        List<AnalyticsFieldFilter> other$filters = other.getFilters();
        if (this$filters == null ? other$filters != null : !((Object)this$filters).equals(other$filters)) {
            return false;
        }
        AnalyticsAggregation this$yAxisAggregation = this.getYAxisAggregation();
        AnalyticsAggregation other$yAxisAggregation = other.getYAxisAggregation();
        return !(this$yAxisAggregation == null ? other$yAxisAggregation != null : !((Object)this$yAxisAggregation).equals(other$yAxisAggregation));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AnalyticsPercentageItemFilter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<AnalyticsFieldFilter> $filters = this.getFilters();
        result = result * 59 + ($filters == null ? 43 : ((Object)$filters).hashCode());
        AnalyticsAggregation $yAxisAggregation = this.getYAxisAggregation();
        result = result * 59 + ($yAxisAggregation == null ? 43 : ((Object)$yAxisAggregation).hashCode());
        return result;
    }

    public String toString() {
        return "AnalyticsPercentageItemFilter(filters=" + this.getFilters() + ", yAxisAggregation=" + this.getYAxisAggregation() + ")";
    }

    public AnalyticsPercentageItemFilter() {
    }

    public AnalyticsPercentageItemFilter(List<AnalyticsFieldFilter> filters, AnalyticsAggregation yAxisAggregation) {
        this.filters = filters;
        this.yAxisAggregation = yAxisAggregation;
    }

    @ToString
    public static class Range
    implements Serializable,
    Cloneable {
        private static final long serialVersionUID = 570632355720481459L;
        private String min;
        private String max;

        public AnalyticsFilter.Range clone() {
            return new AnalyticsFilter.Range(this.min, this.max);
        }

        public String getMin() {
            return this.min;
        }

        public String getMax() {
            return this.max;
        }

        public void setMin(String min) {
            this.min = min;
        }

        public void setMax(String max) {
            this.max = max;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Range)) {
                return false;
            }
            Range other = (Range)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$min = this.getMin();
            String other$min = other.getMin();
            if (this$min == null ? other$min != null : !this$min.equals(other$min)) {
                return false;
            }
            String this$max = this.getMax();
            String other$max = other.getMax();
            return !(this$max == null ? other$max != null : !this$max.equals(other$max));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Range;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $min = this.getMin();
            result = result * 59 + ($min == null ? 43 : $min.hashCode());
            String $max = this.getMax();
            result = result * 59 + ($max == null ? 43 : $max.hashCode());
            return result;
        }

        public String toString() {
            return "AnalyticsPercentageItemFilter.Range(min=" + this.getMin() + ", max=" + this.getMax() + ")";
        }

        public Range() {
        }

        public Range(String min, String max) {
            this.min = min;
            this.max = max;
        }
    }
}

