/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.analytics.model;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class StatisticData
implements Serializable {
    private static final long serialVersionUID = -2660993500359866340L;
    private static final int PRIME = 59;
    private DateFormat dateFormat;
    private long timestamp;
    private long userId;
    private long spaceId;
    private String module;
    private String subModule;
    private String operation;
    private StatisticStatus status = StatisticStatus.OK;
    private String errorMessage;
    private long duration;
    private long errorCode;
    private Map<String, String> parameters;
    private Map<String, Collection<String>> listParameters;

    public void addParameter(String key, Object value) {
        if (this.parameters == null) {
            this.parameters = new HashMap<String, String>();
        }
        if (value == null) {
            return;
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            Collection values = collection.stream().filter(Objects::nonNull).map(this::getFieldValue).collect(Collectors.toList());
            if (this.listParameters == null) {
                this.listParameters = new HashMap<String, Collection<String>>();
            }
            this.listParameters.put(key, values);
        } else {
            this.parameters.put(key, this.getFieldValue(value));
        }
    }

    private String getFieldValue(Object value) {
        if (value instanceof Date) {
            return this.buildDateFormat().format(value);
        }
        return String.valueOf(value);
    }

    private DateFormat buildDateFormat() {
        if (this.dateFormat == null) {
            this.dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss Z");
        }
        return this.dateFormat;
    }

    public long computeId() {
        long result = this.timestamp;
        result = result * 59L + (long)((int)(this.userId >>> 32 ^ this.userId));
        result = result * 59L + (long)((int)(this.spaceId >>> 32 ^ this.spaceId));
        result = result * 59L + (long)(this.module == null ? 43 : this.module.hashCode());
        result = result * 59L + (long)(this.subModule == null ? 43 : this.subModule.hashCode());
        result = result * 59L + (long)(this.operation == null ? 43 : this.operation.hashCode());
        result = result * 59L + (long)(this.parameters == null ? 43 : this.parameters.hashCode());
        return result;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StatisticData)) {
            return false;
        }
        StatisticData other = (StatisticData)o;
        return this.hashCode() == other.hashCode();
    }

    public int hashCode() {
        return (int)this.computeId();
    }

    public String toString() {
        return "StatisticData(timestamp=" + this.getTimestamp() + ", userId=" + this.getUserId() + ", spaceId=" + this.getSpaceId() + ", module=" + this.getModule() + ", subModule=" + this.getSubModule() + ", operation=" + this.getOperation() + ", status=" + this.getStatus() + ", errorMessage=" + this.getErrorMessage() + ", duration=" + this.getDuration() + ", errorCode=" + this.getErrorCode() + ", parameters=" + this.getParameters() + ", listParameters=" + this.getListParameters() + ")";
    }

    public StatisticData(DateFormat dateFormat, long timestamp, long userId, long spaceId, String module, String subModule, String operation, StatisticStatus status, String errorMessage, long duration, long errorCode, Map<String, String> parameters, Map<String, Collection<String>> listParameters) {
        this.dateFormat = dateFormat;
        this.timestamp = timestamp;
        this.userId = userId;
        this.spaceId = spaceId;
        this.module = module;
        this.subModule = subModule;
        this.operation = operation;
        this.status = status;
        this.errorMessage = errorMessage;
        this.duration = duration;
        this.errorCode = errorCode;
        this.parameters = parameters;
        this.listParameters = listParameters;
    }

    public StatisticData() {
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public long getUserId() {
        return this.userId;
    }

    public void setUserId(long userId) {
        this.userId = userId;
    }

    public long getSpaceId() {
        return this.spaceId;
    }

    public void setSpaceId(long spaceId) {
        this.spaceId = spaceId;
    }

    public String getModule() {
        return this.module;
    }

    public void setModule(String module) {
        this.module = module;
    }

    public String getSubModule() {
        return this.subModule;
    }

    public void setSubModule(String subModule) {
        this.subModule = subModule;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public StatisticStatus getStatus() {
        return this.status;
    }

    public void setStatus(StatisticStatus status) {
        this.status = status;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public long getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(long errorCode) {
        this.errorCode = errorCode;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public Map<String, Collection<String>> getListParameters() {
        return this.listParameters;
    }

    public void setListParameters(Map<String, Collection<String>> listParameters) {
        this.listParameters = listParameters;
    }

    public static enum StatisticStatus {
        OK,
        KO;

    }
}

