/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.analytics.job;

import org.exoplatform.analytics.model.StatisticData;
import org.exoplatform.analytics.utils.AnalyticsUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.UserStatus;
import org.exoplatform.social.core.manager.IdentityManager;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

@DisallowConcurrentExecution
public class UsersStatisticsCountJob
implements Job {
    private static final Log LOG = ExoLogger.getLogger(UsersStatisticsCountJob.class);
    private ExoContainer container = PortalContainer.getInstance();
    private OrganizationService organizationService;
    private IdentityManager identityManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext context) throws JobExecutionException {
        long startTime = System.currentTimeMillis();
        ExoContainer currentContainer = ExoContainerContext.getCurrentContainer();
        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
        RequestLifeCycle.begin((ExoContainer)this.container);
        try {
            ListAccess allUsers = this.getOrganizationService().getUserHandler().findAllUsers(UserStatus.ANY);
            int allUsersCount = allUsers.getSize();
            ListAccess enabledIdentities = this.getIdentityManager().getIdentitiesByProfileFilter("organization", null, false);
            int enabledUsersCount = enabledIdentities.getSize();
            int disabledUsersCount = allUsersCount - enabledUsersCount;
            this.addUsersCountStatistic("allUsers", allUsersCount, startTime);
            this.addUsersCountStatistic("enabledUsers", enabledUsersCount, startTime);
            this.addUsersCountStatistic("disabledUsers", disabledUsersCount, startTime);
            startTime = System.currentTimeMillis();
            Group externalsGroup = this.getOrganizationService().getGroupHandler().findGroupById("/platform/externals");
            int enabledExternalUsersCount = 0;
            if (externalsGroup != null) {
                ListAccess externalMemberships = this.getOrganizationService().getMembershipHandler().findAllMembershipsByGroup(externalsGroup);
                enabledExternalUsersCount = externalMemberships.getSize();
            }
            this.addUsersCountStatistic("enabledExternalUsers", enabledExternalUsersCount, startTime);
            this.addUsersCountStatistic("enabledInternalUsers", enabledUsersCount - enabledExternalUsersCount, startTime);
        }
        catch (Exception e) {
            LOG.error((Object)"Error while computing users statistics", (Throwable)e);
        }
        finally {
            RequestLifeCycle.end();
            ExoContainerContext.setCurrentContainer((ExoContainer)currentContainer);
        }
    }

    private void addUsersCountStatistic(String countType, int count, long startTime) {
        StatisticData statisticData = new StatisticData();
        statisticData.setModule("portal");
        statisticData.setSubModule("account");
        statisticData.setOperation("usersCount");
        statisticData.setDuration(System.currentTimeMillis() - startTime);
        statisticData.addParameter("countType", (Object)countType);
        statisticData.addParameter("count", (Object)count);
        AnalyticsUtils.addStatisticData((StatisticData)statisticData);
    }

    private OrganizationService getOrganizationService() {
        if (this.organizationService == null) {
            this.organizationService = (OrganizationService)this.container.getComponentInstanceOfType(OrganizationService.class);
        }
        return this.organizationService;
    }

    private IdentityManager getIdentityManager() {
        if (this.identityManager == null) {
            this.identityManager = (IdentityManager)this.container.getComponentInstanceOfType(IdentityManager.class);
        }
        return this.identityManager;
    }
}

