/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.analytics.model.filter;

import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;

public class AnalyticsPeriod
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 2730342636949170231L;
    private long fromInMS;
    private long toInMS;
    private String interval;
    private ZoneId timeZone = ZoneOffset.UTC;

    public AnalyticsPeriod(long fromInMS, long toInMS) {
        this.fromInMS = fromInMS;
        this.toInMS = toInMS;
        this.interval = this.getDiffInDays() + "d";
    }

    public AnalyticsPeriod(long fromInMS, long toInMS, ZoneId timeZone) {
        this(fromInMS, toInMS);
        this.timeZone = timeZone;
    }

    public AnalyticsPeriod(LocalDate from, LocalDate to) {
        this.fromInMS = from.atStartOfDay(ZoneOffset.UTC).toInstant().toEpochMilli();
        this.toInMS = to.atStartOfDay(ZoneOffset.UTC).toInstant().toEpochMilli();
        this.interval = this.getDiffInDays() + "d";
    }

    public AnalyticsPeriod(LocalDate from, LocalDate to, String interval) {
        this.fromInMS = from.atStartOfDay(ZoneOffset.UTC).toInstant().toEpochMilli();
        this.toInMS = to.atStartOfDay(ZoneOffset.UTC).toInstant().toEpochMilli();
        this.interval = interval;
    }

    public AnalyticsPeriod(LocalDate from, LocalDate to, String interval, ZoneId timeZone) {
        this.fromInMS = from.atStartOfDay(timeZone).toInstant().toEpochMilli();
        this.toInMS = to.atStartOfDay(timeZone).toInstant().toEpochMilli();
        this.interval = interval;
        this.timeZone = timeZone;
    }

    public LocalDate getFrom() {
        return Instant.ofEpochMilli(this.fromInMS).atZone(this.getTimeZone()).toLocalDate();
    }

    public LocalDate getTo() {
        return Instant.ofEpochMilli(this.toInMS).atZone(this.getTimeZone()).toLocalDate();
    }

    public AnalyticsPeriod previousPeriod() {
        return new AnalyticsPeriod(this.fromInMS - (this.toInMS - this.fromInMS), this.fromInMS);
    }

    public long getDiffInDays() {
        return ChronoUnit.DAYS.between(this.getFrom(), this.getTo());
    }

    public boolean isInPeriod(long timestamp) {
        return timestamp >= this.getFromInMS() && timestamp < this.getToInMS();
    }

    public boolean isInPeriod(LocalDate date) {
        long dateInMS = date.atStartOfDay(this.getTimeZone()).toInstant().toEpochMilli();
        return dateInMS >= this.fromInMS && dateInMS < this.toInMS;
    }

    protected AnalyticsPeriod clone() {
        return new AnalyticsPeriod(this.fromInMS, this.toInMS, this.interval, this.timeZone);
    }

    public long getFromInMS() {
        return this.fromInMS;
    }

    public long getToInMS() {
        return this.toInMS;
    }

    public String getInterval() {
        return this.interval;
    }

    public ZoneId getTimeZone() {
        return this.timeZone;
    }

    public void setFromInMS(long fromInMS) {
        this.fromInMS = fromInMS;
    }

    public void setToInMS(long toInMS) {
        this.toInMS = toInMS;
    }

    public void setInterval(String interval) {
        this.interval = interval;
    }

    public void setTimeZone(ZoneId timeZone) {
        this.timeZone = timeZone;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AnalyticsPeriod)) {
            return false;
        }
        AnalyticsPeriod other = (AnalyticsPeriod)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getFromInMS() != other.getFromInMS()) {
            return false;
        }
        if (this.getToInMS() != other.getToInMS()) {
            return false;
        }
        String this$interval = this.getInterval();
        String other$interval = other.getInterval();
        if (this$interval == null ? other$interval != null : !this$interval.equals(other$interval)) {
            return false;
        }
        ZoneId this$timeZone = this.getTimeZone();
        ZoneId other$timeZone = other.getTimeZone();
        return !(this$timeZone == null ? other$timeZone != null : !((Object)this$timeZone).equals(other$timeZone));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AnalyticsPeriod;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $fromInMS = this.getFromInMS();
        result = result * 59 + (int)($fromInMS >>> 32 ^ $fromInMS);
        long $toInMS = this.getToInMS();
        result = result * 59 + (int)($toInMS >>> 32 ^ $toInMS);
        String $interval = this.getInterval();
        result = result * 59 + ($interval == null ? 43 : $interval.hashCode());
        ZoneId $timeZone = this.getTimeZone();
        result = result * 59 + ($timeZone == null ? 43 : ((Object)$timeZone).hashCode());
        return result;
    }

    public String toString() {
        return "AnalyticsPeriod(fromInMS=" + this.getFromInMS() + ", toInMS=" + this.getToInMS() + ", interval=" + this.getInterval() + ", timeZone=" + String.valueOf(this.getTimeZone()) + ")";
    }

    public AnalyticsPeriod() {
    }

    public AnalyticsPeriod(long fromInMS, long toInMS, String interval, ZoneId timeZone) {
        this.fromInMS = fromInMS;
        this.toInMS = toInMS;
        this.interval = interval;
        this.timeZone = timeZone;
    }
}

