/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.analytics.portlet;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jetty.util.StringUtil;
import org.exoplatform.addon.analytics.portlet.AnalyticsPortlet;
import org.exoplatform.analytics.api.service.AnalyticsService;
import org.exoplatform.analytics.model.chart.ChartDataList;
import org.exoplatform.analytics.model.filter.AnalyticsFilter;
import org.exoplatform.analytics.model.filter.aggregation.AnalyticsAggregation;
import org.exoplatform.analytics.utils.AnalyticsUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.webui.Utils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AnalyticsPortlet
extends GenericPortlet {
    private static final String CAN_MODIFY_CHART_SETTINGS = "canModifyChartSettings";
    private static final String ANALYTICS_SEARCH_SCOPE = "analyticsSearchScope";
    private static final String READ_SETTINGS_OPERATOPN = "GET_SETTINGS";
    private static final String READ_FILTERS_OPERATOPN = "GET_FILTERS";
    private static final String READ_MAPPINGS_OPERATOPN = "GET_MAPPINGS";
    private static final String READ_CHART_DATA_OPERATOPN = "GET_CHART_DATA";
    private static final String READ_CHART_SAMPLES_OPERATOPN = "GET_CHART_SAMPLES_DATA";
    private static final Map<String, AnalyticsFilter> FILTERS = new HashMap();
    private SpaceService spaceService;
    private AnalyticsService analyticsService;

    protected void doView(RenderRequest request, RenderResponse response) throws IOException, PortletException {
        PortletRequestDispatcher dispatcher = this.getPortletContext().getRequestDispatcher("/analytics.jsp");
        dispatcher.forward((PortletRequest)request, (PortletResponse)response);
    }

    public void processAction(ActionRequest request, ActionResponse response) throws IOException, PortletException {
        if (!this.canModifyChartSettings(request.getPortletSession())) {
            throw new PortletException("User is not allowed to save chart settings");
        }
        PortletPreferences preferences = request.getPreferences();
        Enumeration parameterNames = request.getParameterNames();
        if (parameterNames != null && parameterNames.hasMoreElements()) {
            while (parameterNames.hasMoreElements()) {
                String name = (String)parameterNames.nextElement();
                String paramValue = request.getParameter(name);
                preferences.setValue(name, paramValue);
            }
        }
        preferences.store();
        this.clearAnlyticsFilterCache(request.getWindowID());
        response.setPortletMode(PortletMode.VIEW);
    }

    public void serveResource(ResourceRequest request, ResourceResponse response) throws PortletException, IOException {
        PortletPreferences preferences = request.getPreferences();
        PortletSession portletSession = request.getPortletSession();
        String operation = request.getParameter("operation");
        String windowId = request.getWindowID();
        if (StringUtils.equals((String)operation, (String)READ_SETTINGS_OPERATOPN)) {
            AnalyticsFilter filter = this.getFilterFromPreferences(windowId, preferences, false);
            JSONObject jsonResponse = new JSONObject();
            this.addJSONParam(jsonResponse, "title", (Object)filter.getTitle());
            this.addJSONParam(jsonResponse, "chartType", (Object)filter.getChartType());
            List colors = filter.getColors() == null ? Collections.emptyList() : filter.getColors();
            this.addJSONParam(jsonResponse, "colors", (Object)new JSONArray((Collection)colors));
            this.addJSONParam(jsonResponse, "canEdit", (Object)this.canModifyChartSettings(portletSession));
            this.addJSONParam(jsonResponse, "scope", (Object)this.getSearchScope(portletSession).name());
            response.setContentType("application/json");
            response.getWriter().write(jsonResponse.toString());
        } else if (StringUtils.equals((String)operation, (String)READ_FILTERS_OPERATOPN)) {
            AnalyticsFilter filter = this.getFilterFromPreferences(windowId, preferences, false);
            response.setContentType("application/json");
            response.getWriter().write(AnalyticsUtils.toJsonString((Object)filter));
        } else if (StringUtils.equals((String)operation, (String)READ_MAPPINGS_OPERATOPN)) {
            Set mappings = this.getAnalyticsService().retrieveMapping(false);
            List objectMappings = mappings.stream().map(mapping -> new JSONObject(mapping)).collect(Collectors.toList());
            JSONArray jsonArrayResponse = new JSONArray(objectMappings);
            response.setContentType("application/json");
            response.getWriter().write(jsonArrayResponse.toString());
        } else if (StringUtils.equals((String)operation, (String)READ_CHART_SAMPLES_OPERATOPN)) {
            if (!this.canModifyChartSettings(portletSession)) {
                throw new PortletException("Not allowed to access samples");
            }
            AnalyticsFilter filter = this.getFilterFromPreferences(windowId, preferences, true);
            this.addPeriodFilter(request, filter);
            this.addScopeFilter(portletSession, filter);
            this.addLanguageFilter(request, filter);
            this.addLimitFilter(request, filter);
            this.addSortFilter(filter, "desc");
            List statisticDatas = this.getAnalyticsService().retrieveData(filter);
            List objectMappings = statisticDatas.stream().map(statisticData -> {
                JSONObject object = new JSONObject(statisticData);
                object.remove("class");
                return object;
            }).collect(Collectors.toList());
            JSONArray jsonArrayResponse = new JSONArray(objectMappings);
            response.setContentType("application/json");
            response.getWriter().write(jsonArrayResponse.toString());
        } else if (StringUtils.equals((String)operation, (String)READ_CHART_DATA_OPERATOPN)) {
            AnalyticsFilter filter = this.getFilterFromPreferences(windowId, preferences, true);
            this.addPeriodFilter(request, filter);
            this.addScopeFilter(portletSession, filter);
            this.addLanguageFilter(request, filter);
            ChartDataList result = this.getAnalyticsService().computeChartData(filter);
            response.setContentType("application/json");
            response.getWriter().write(AnalyticsUtils.toJsonString((Object)result));
        }
        super.serveResource(request, response);
    }

    private void addLanguageFilter(ResourceRequest request, AnalyticsFilter filter) {
        String lang = request.getParameter("lang");
        filter.setLang(lang);
    }

    private void addSortFilter(AnalyticsFilter filter, String direction) {
        List xAxisAggregations = filter.getXAxisAggregations();
        for (AnalyticsAggregation analyticsAggregation : xAxisAggregations) {
            if (!StringUtils.equals((String)"timestamp", (String)analyticsAggregation.getField())) continue;
            analyticsAggregation.setSortDirection(direction);
        }
    }

    private void addLimitFilter(ResourceRequest request, AnalyticsFilter filter) {
        String limitString = request.getParameter("limit");
        if (StringUtils.isBlank((String)limitString)) {
            limitString = "10";
        }
        filter.setLimit(Long.parseLong(limitString));
    }

    private void addPeriodFilter(ResourceRequest request, AnalyticsFilter filter) {
        String fromDateString = request.getParameter("min");
        String toDateString = request.getParameter("max");
        filter.addRangeFilter("timestamp", fromDateString, toDateString);
    }

    private void addScopeFilter(PortletSession portletSession, AnalyticsFilter filter) throws PortletException {
        SearchScope scope = this.getSearchScope(portletSession);
        switch (1.$SwitchMap$org$exoplatform$addon$analytics$portlet$AnalyticsPortlet$SearchScope[scope.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                throw new PortletException("Not allowed to access information");
            }
            case 3: {
                Space space = SpaceUtils.getSpaceByContext();
                filter.addEqualFilter("spaceId", space.getId());
                break;
            }
            case 4: {
                String viewerIdentityId = Utils.getViewerIdentity().getId();
                filter.addEqualFilter("userId", viewerIdentityId);
            }
        }
    }

    private AnalyticsFilter getFilterFromPreferences(String windowId, PortletPreferences preferences, boolean clone) {
        AnalyticsFilter filter = this.getAnlyticsFilterCache(windowId);
        if (filter == null) {
            String analyticsFilterString;
            if (preferences != null && StringUtils.isNotBlank((String)(analyticsFilterString = preferences.getValue("settings", null)))) {
                filter = (AnalyticsFilter)AnalyticsUtils.fromJsonString((String)analyticsFilterString, AnalyticsFilter.class);
            }
            if (filter == null) {
                filter = new AnalyticsFilter();
            }
            this.setAnlyticsFilterCache(windowId, filter);
        }
        return clone ? filter.clone() : filter;
    }

    private SearchScope getSearchScope(PortletSession portletSession) {
        SearchScope searchScopeFromCache = this.getSearchScopeFromCache(portletSession);
        if (searchScopeFromCache != null) {
            return searchScopeFromCache;
        }
        ConversationState current = ConversationState.getCurrent();
        if (current == null || current.getIdentity() == null) {
            return this.cacheSearchScope(portletSession, SearchScope.NONE);
        }
        Identity identity = current.getIdentity();
        String userId = identity.getUserId();
        if (StringUtils.isBlank((String)userId) || StringUtils.equals((String)userId, (String)IdentityConstants.ANONIM) || StringUtils.equals((String)userId, (String)IdentityConstants.SYSTEM)) {
            return this.cacheSearchScope(portletSession, SearchScope.NONE);
        }
        List groupIds = this.getAnalyticsService().getAdministratorsPermissions();
        for (Object groupId : groupIds) {
            if (!StringUtils.isNotBlank((String)groupId) || !identity.isMemberOf(MembershipEntry.parse((String)groupId))) continue;
            return this.cacheSearchScope(portletSession, SearchScope.GLOBAL);
        }
        groupIds = this.getAnalyticsService().getViewAllPermissions();
        for (Object groupId : groupIds) {
            if (!StringUtils.isNotBlank((String)groupId) || !identity.isMemberOf(MembershipEntry.parse((String)groupId))) continue;
            return this.cacheSearchScope(portletSession, SearchScope.GLOBAL);
        }
        groupIds = this.getAnalyticsService().getViewPermissions();
        boolean canView = false;
        for (String groupId : groupIds) {
            if (!StringUtils.isNotBlank((String)groupId) || !identity.isMemberOf(MembershipEntry.parse((String)groupId))) continue;
            canView = true;
            break;
        }
        if (!canView) {
            return this.cacheSearchScope(portletSession, SearchScope.NONE);
        }
        Space space = SpaceUtils.getSpaceByContext();
        if (space != null) {
            if (this.getSpaceService().isSuperManager(userId) || this.getSpaceService().isMember(space, userId)) {
                return this.cacheSearchScope(portletSession, SearchScope.SPACE);
            }
            return this.cacheSearchScope(portletSession, SearchScope.NONE);
        }
        if (Utils.isOwner() || StringUtil.isBlank((String)Utils.getOwnerRemoteId())) {
            return this.cacheSearchScope(portletSession, SearchScope.USER);
        }
        return this.cacheSearchScope(portletSession, SearchScope.NONE);
    }

    private boolean canModifyChartSettings(PortletSession portletSession) {
        Boolean canModifyFromCache = this.getCanModifySettingsFromCache(portletSession);
        if (canModifyFromCache != null) {
            return canModifyFromCache;
        }
        ConversationState current = ConversationState.getCurrent();
        if (current == null || current.getIdentity() == null) {
            return this.cacheChartModificationAccessPermission(portletSession, false);
        }
        Identity identity = current.getIdentity();
        String userId = identity.getUserId();
        if (StringUtils.isBlank((String)userId) || StringUtils.equals((String)userId, (String)IdentityConstants.ANONIM) || StringUtils.equals((String)userId, (String)IdentityConstants.SYSTEM)) {
            return this.cacheChartModificationAccessPermission(portletSession, false);
        }
        List groupIds = this.getAnalyticsService().getAdministratorsPermissions();
        for (String groupId : groupIds) {
            if (!StringUtils.isNotBlank((String)groupId) || !identity.isMemberOf(MembershipEntry.parse((String)groupId))) continue;
            return this.cacheChartModificationAccessPermission(portletSession, true);
        }
        Space space = SpaceUtils.getSpaceByContext();
        if (space != null) {
            boolean canModify = this.getSpaceService().isSuperManager(userId) || this.getSpaceService().isManager(space, userId);
            return this.cacheChartModificationAccessPermission(portletSession, canModify);
        }
        return this.cacheChartModificationAccessPermission(portletSession, false);
    }

    private Boolean getCanModifySettingsFromCache(PortletSession portletSession) {
        return (Boolean)portletSession.getAttribute(CAN_MODIFY_CHART_SETTINGS);
    }

    private boolean cacheChartModificationAccessPermission(PortletSession portletSession, boolean canModify) {
        if (!PropertyManager.isDevelopping()) {
            portletSession.setAttribute(CAN_MODIFY_CHART_SETTINGS, (Object)canModify);
        }
        return canModify;
    }

    private SearchScope getSearchScopeFromCache(PortletSession portletSession) {
        return (SearchScope)portletSession.getAttribute(ANALYTICS_SEARCH_SCOPE);
    }

    private SearchScope cacheSearchScope(PortletSession portletSession, SearchScope searchScope) {
        if (!PropertyManager.isDevelopping()) {
            portletSession.setAttribute(ANALYTICS_SEARCH_SCOPE, (Object)searchScope);
        }
        return searchScope;
    }

    private void addJSONParam(JSONObject jsonResponse, String paramName, Object paramValue) throws PortletException {
        try {
            jsonResponse.put(paramName, paramValue);
        }
        catch (JSONException e) {
            throw new PortletException("Error adding parameter to JSON", (Throwable)e);
        }
    }

    private AnalyticsService getAnalyticsService() {
        if (this.analyticsService == null) {
            this.analyticsService = (AnalyticsService)CommonsUtils.getService(AnalyticsService.class);
        }
        return this.analyticsService;
    }

    private SpaceService getSpaceService() {
        if (this.spaceService == null) {
            this.spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
        }
        return this.spaceService;
    }

    private void setAnlyticsFilterCache(String windowId, AnalyticsFilter filter) {
        if (filter == null) {
            this.clearAnlyticsFilterCache(windowId);
        } else {
            FILTERS.put(windowId, filter);
        }
    }

    private AnalyticsFilter getAnlyticsFilterCache(String windowId) {
        AnalyticsFilter analyticsFilter = (AnalyticsFilter)FILTERS.get(windowId);
        return analyticsFilter == null ? null : analyticsFilter.clone();
    }

    private void clearAnlyticsFilterCache(String windowId) {
        FILTERS.remove(windowId);
    }
}

