/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.analytics.portlet;

import java.io.IOException;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.addon.analytics.portlet.AbstractAnalyticsPortlet;
import org.exoplatform.analytics.api.service.AnalyticsService;
import org.exoplatform.analytics.model.filter.AbstractAnalyticsFilter;
import org.exoplatform.analytics.model.filter.AnalyticsFilter;
import org.exoplatform.analytics.model.filter.aggregation.AnalyticsAggregation;
import org.exoplatform.analytics.utils.AnalyticsUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.webui.Utils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class AbstractAnalyticsPortlet<T>
extends GenericPortlet {
    private static final Log LOG = ExoLogger.getLogger(AbstractAnalyticsPortlet.class);
    private static final String CAN_MODIFY_CHART_SETTINGS = "canModifyChartSettings";
    private static final String ANALYTICS_SEARCH_SCOPE = "analyticsSearchScope";
    private static final String READ_SETTINGS_OPERATION = "GET_SETTINGS";
    private static final String READ_FILTERS_OPERATION = "GET_FILTERS";
    private static final String READ_MAPPINGS_OPERATION = "GET_MAPPINGS";
    private static final String READ_DATA_OPERATION = "GET_DATA";
    private static final String READ_SAMPLES_OPERATION = "GET_SAMPLES";
    private static final String READ_FIELD_VALUES_OPERATION = "GET_FIELD_VALUES";
    private SpaceService spaceService;
    private AnalyticsService analyticsService;

    public void doView(RenderRequest request, RenderResponse response) throws IOException, PortletException {
        PortletRequestDispatcher dispatcher = this.getPortletContext().getRequestDispatcher(this.getViewPagePath());
        dispatcher.forward((PortletRequest)request, (PortletResponse)response);
    }

    public final void serveResource(ResourceRequest request, ResourceResponse response) throws PortletException, IOException {
        String operation = request.getParameter("operation");
        if (StringUtils.equals((String)operation, (String)READ_SETTINGS_OPERATION)) {
            this.readSettingsReadOnly(request, response);
        } else if (StringUtils.equals((String)operation, (String)READ_FILTERS_OPERATION)) {
            this.readSettings(request, response);
        } else if (StringUtils.equals((String)operation, (String)READ_MAPPINGS_OPERATION)) {
            Set mappings = this.getAnalyticsService().retrieveMapping(false);
            List objectMappings = mappings.stream().map(JSONObject::new).collect(Collectors.toList());
            JSONArray jsonArrayResponse = new JSONArray(objectMappings);
            response.setContentType("application/json");
            response.getWriter().write(jsonArrayResponse.toString());
        } else if (StringUtils.equals((String)operation, (String)READ_SAMPLES_OPERATION)) {
            if (!this.canModifySettings((PortletRequest)request)) {
                throw new PortletException("Not allowed to access samples");
            }
            this.readSamples(request, response);
        } else if (StringUtils.equals((String)operation, (String)READ_DATA_OPERATION)) {
            this.readData(request, response);
        } else if (StringUtils.equals((String)operation, (String)READ_FIELD_VALUES_OPERATION)) {
            int limit;
            String field = request.getParameter("field");
            String limitString = request.getParameter("limit");
            int n = limit = StringUtils.isBlank((String)limitString) ? 10 : Integer.parseInt(limitString);
            if (StringUtils.isNotBlank((String)field)) {
                List fieldValues = this.getAnalyticsService().retrieveFieldValues(field, limit);
                response.getWriter().write(AnalyticsUtils.toJsonString((Object)fieldValues));
                response.setContentType("application/json");
            } else {
                response.getWriter().write("[]");
                response.setContentType("application/json");
            }
        }
        super.serveResource(request, response);
    }

    public void processAction(ActionRequest request, ActionResponse response) throws IOException, PortletException {
        if (!this.canModifySettings((PortletRequest)request)) {
            throw new PortletException("User is not allowed to save chart settings");
        }
        PortletPreferences preferences = request.getPreferences();
        Enumeration parameterNames = request.getParameterNames();
        if (parameterNames != null && parameterNames.hasMoreElements()) {
            while (parameterNames.hasMoreElements()) {
                String name = (String)parameterNames.nextElement();
                String paramValue = request.getParameter(name);
                preferences.setValue(name, paramValue);
            }
        }
        preferences.store();
        response.setPortletMode(PortletMode.VIEW);
    }

    protected void readSettingsReadOnly(ResourceRequest request, ResourceResponse response) throws PortletException, IOException {
        throw new UnsupportedOperationException();
    }

    protected abstract String getViewPagePath();

    protected abstract Class<T> getFilterClass();

    protected abstract void readSettings(ResourceRequest var1, ResourceResponse var2) throws PortletException, IOException;

    protected abstract void readData(ResourceRequest var1, ResourceResponse var2) throws PortletException, IOException;

    protected void readSamples(ResourceRequest request, ResourceResponse response) throws PortletException, IOException {
        throw new UnsupportedOperationException();
    }

    protected T getFilterFromPreferences(ResourceRequest request) {
        String analyticsFilterString;
        PortletPreferences preferences;
        Object filter = null;
        PortletPreferences portletPreferences = preferences = request == null ? null : request.getPreferences();
        if (preferences != null && StringUtils.isNotBlank((String)(analyticsFilterString = preferences.getValue("settings", null)))) {
            filter = AnalyticsUtils.fromJsonString((String)analyticsFilterString, (Class)this.getFilterClass());
        }
        try {
            if (filter == null) {
                filter = this.getFilterClass().getConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (Exception e) {
            LOG.debug((Object)"Error while instanciating object.", (Throwable)e);
        }
        return (T)this.clone(filter);
    }

    protected SearchScope getSearchScope(PortletRequest request) {
        PortletSession portletSession = request.getPortletSession();
        SearchScope searchScopeFromCache = this.getSearchScopeFromCache(portletSession);
        if (searchScopeFromCache != null) {
            return searchScopeFromCache;
        }
        ConversationState current = ConversationState.getCurrent();
        if (current == null || current.getIdentity() == null) {
            return this.cacheSearchScope(portletSession, SearchScope.NONE);
        }
        Identity identity = current.getIdentity();
        String userId = identity.getUserId();
        if (StringUtils.isBlank((String)userId) || StringUtils.equals((String)userId, (String)IdentityConstants.ANONIM) || StringUtils.equals((String)userId, (String)IdentityConstants.SYSTEM)) {
            return this.cacheSearchScope(portletSession, SearchScope.NONE);
        }
        List groupIds = this.getAnalyticsService().getAdministratorsPermissions();
        for (Object groupId : groupIds) {
            if (!StringUtils.isNotBlank((String)groupId) || !identity.isMemberOf(MembershipEntry.parse((String)groupId))) continue;
            return this.cacheSearchScope(portletSession, SearchScope.GLOBAL);
        }
        groupIds = this.getAnalyticsService().getViewAllPermissions();
        for (Object groupId : groupIds) {
            if (!StringUtils.isNotBlank((String)groupId) || !identity.isMemberOf(MembershipEntry.parse((String)groupId))) continue;
            return this.cacheSearchScope(portletSession, SearchScope.GLOBAL);
        }
        groupIds = this.getAnalyticsService().getViewPermissions();
        boolean canView = false;
        for (String groupId : groupIds) {
            if (!StringUtils.isNotBlank((String)groupId) || !identity.isMemberOf(MembershipEntry.parse((String)groupId))) continue;
            canView = true;
            break;
        }
        if (!canView) {
            return this.cacheSearchScope(portletSession, SearchScope.NONE);
        }
        Space space = SpaceUtils.getSpaceByContext();
        if (space != null) {
            if (this.getSpaceService().isSuperManager(userId) || this.getSpaceService().isMember(space, userId)) {
                return this.cacheSearchScope(portletSession, SearchScope.SPACE);
            }
            return this.cacheSearchScope(portletSession, SearchScope.NONE);
        }
        if (Utils.isOwner() || StringUtils.isBlank((String)Utils.getOwnerRemoteId())) {
            return this.cacheSearchScope(portletSession, SearchScope.USER);
        }
        return this.cacheSearchScope(portletSession, SearchScope.NONE);
    }

    protected boolean canModifySettings(PortletRequest request) {
        PortletSession portletSession = request.getPortletSession();
        Boolean canModifyFromCache = this.getCanModifySettingsFromCache(portletSession);
        if (canModifyFromCache != null) {
            return canModifyFromCache;
        }
        ConversationState current = ConversationState.getCurrent();
        if (current == null || current.getIdentity() == null) {
            return this.cacheChartModificationAccessPermission(portletSession, false);
        }
        Identity identity = current.getIdentity();
        String userId = identity.getUserId();
        if (StringUtils.isBlank((String)userId) || StringUtils.equals((String)userId, (String)IdentityConstants.ANONIM) || StringUtils.equals((String)userId, (String)IdentityConstants.SYSTEM)) {
            return this.cacheChartModificationAccessPermission(portletSession, false);
        }
        List groupIds = this.getAnalyticsService().getAdministratorsPermissions();
        for (String groupId : groupIds) {
            if (!StringUtils.isNotBlank((String)groupId) || !identity.isMemberOf(MembershipEntry.parse((String)groupId))) continue;
            return this.cacheChartModificationAccessPermission(portletSession, true);
        }
        Space space = SpaceUtils.getSpaceByContext();
        if (space != null) {
            boolean canModify = this.getSpaceService().isSuperManager(userId) || this.getSpaceService().isManager(space, userId);
            return this.cacheChartModificationAccessPermission(portletSession, canModify);
        }
        return this.cacheChartModificationAccessPermission(portletSession, false);
    }

    protected void addJSONParam(JSONObject jsonResponse, String paramName, Object paramValue) throws PortletException {
        try {
            jsonResponse.put(paramName, paramValue);
        }
        catch (JSONException e) {
            throw new PortletException("Error adding parameter to JSON", (Throwable)e);
        }
    }

    protected void addTimeZoneFilter(ResourceRequest request, AbstractAnalyticsFilter filter) {
        String timeZone = request.getParameter("timeZone");
        filter.setTimeZone(timeZone);
    }

    protected void addLanguageFilter(ResourceRequest request, AnalyticsFilter filter) {
        String lang = request.getParameter("lang");
        filter.setLang(lang);
    }

    protected void addSortFilter(AnalyticsFilter filter, String direction) {
        List xAxisAggregations = filter.getXAxisAggregations();
        for (AnalyticsAggregation analyticsAggregation : xAxisAggregations) {
            if (!StringUtils.equals((String)"timestamp", (String)analyticsAggregation.getField())) continue;
            analyticsAggregation.setSortDirection(direction);
        }
    }

    protected void addLimitFilter(ResourceRequest request, AnalyticsFilter filter) {
        String limitString = request.getParameter("limit");
        if (StringUtils.isBlank((String)limitString)) {
            limitString = "10";
        }
        filter.setLimit(Long.parseLong(limitString));
    }

    protected void addPeriodFilter(ResourceRequest request, AnalyticsFilter filter) {
        String fromDateString = request.getParameter("min");
        String toDateString = request.getParameter("max");
        filter.addRangeFilter("timestamp", fromDateString, toDateString);
    }

    protected void addScopeFilter(ResourceRequest request, AnalyticsFilter filter) throws PortletException {
        SearchScope scope = this.getSearchScope((PortletRequest)request);
        switch (1.$SwitchMap$org$exoplatform$addon$analytics$portlet$AbstractAnalyticsPortlet$SearchScope[scope.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                throw new PortletException("Not allowed to access information");
            }
            case 3: {
                Space space = SpaceUtils.getSpaceByContext();
                filter.addEqualFilter("spaceId", space.getId());
                break;
            }
            case 4: {
                String viewerIdentityId = Utils.getViewerIdentity().getId();
                filter.addEqualFilter("userId", viewerIdentityId);
            }
        }
    }

    protected AnalyticsService getAnalyticsService() {
        if (this.analyticsService == null) {
            this.analyticsService = (AnalyticsService)CommonsUtils.getService(AnalyticsService.class);
        }
        return this.analyticsService;
    }

    protected SpaceService getSpaceService() {
        if (this.spaceService == null) {
            this.spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
        }
        return this.spaceService;
    }

    private Boolean getCanModifySettingsFromCache(PortletSession portletSession) {
        return (Boolean)portletSession.getAttribute(CAN_MODIFY_CHART_SETTINGS);
    }

    private boolean cacheChartModificationAccessPermission(PortletSession portletSession, boolean canModify) {
        if (!PropertyManager.isDevelopping()) {
            portletSession.setAttribute(CAN_MODIFY_CHART_SETTINGS, (Object)canModify);
        }
        return canModify;
    }

    private SearchScope getSearchScopeFromCache(PortletSession portletSession) {
        return (SearchScope)portletSession.getAttribute(ANALYTICS_SEARCH_SCOPE);
    }

    private SearchScope cacheSearchScope(PortletSession portletSession, SearchScope searchScope) {
        if (!PropertyManager.isDevelopping()) {
            portletSession.setAttribute(ANALYTICS_SEARCH_SCOPE, (Object)searchScope);
        }
        return searchScope;
    }

    private T clone(T filter) {
        try {
            return (T)(filter == null ? null : filter.getClass().getDeclaredMethod("clone", new Class[0]).invoke(filter, new Object[0]));
        }
        catch (Exception e) {
            LOG.debug((Object)"Error while cloning object. Returning original one.", (Throwable)e);
            return filter;
        }
    }
}

