/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faq.service;

import java.util.HashSet;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.faq.service.Utils;
import org.exoplatform.faq.service.impl.JCRDataStorage;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class QuestionNodeListener
implements EventListener {
    private Log log = ExoLogger.getLogger(QuestionNodeListener.class);

    public void onEvent(EventIterator events) {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        JCRDataStorage storage = (JCRDataStorage)container.getComponentInstanceOfType(JCRDataStorage.class);
        try {
            HashSet<String> checkedAnswerNodes = new HashSet<String>();
            while (events.hasNext()) {
                String answerNodePath;
                int lastSlash;
                String propName;
                Event event = events.nextEvent();
                String pathString = event.getPath();
                if (pathString.substring(0, pathString.length() - 1).indexOf(Utils.COMMENT_HOME) > 0 && (event.getType() == 1 || event.getType() == 2)) {
                    storage.reCalculateInfoOfQuestion(pathString);
                }
                if (pathString.substring(0, pathString.length() - 3).indexOf(Utils.ANSWER_HOME) <= 0) continue;
                if (event.getType() == 2) {
                    storage.reCalculateInfoOfQuestion(pathString);
                    continue;
                }
                if (event.getType() != 4 && event.getType() != 16 && event.getType() != 8 || !(propName = pathString.substring((lastSlash = pathString.lastIndexOf("/")) + 1)).equalsIgnoreCase("exo:activateResponses") && !propName.equalsIgnoreCase("exo:approveResponses") || checkedAnswerNodes.contains(answerNodePath = pathString.substring(0, lastSlash))) continue;
                checkedAnswerNodes.add(answerNodePath);
                storage.reCalculateInfoOfQuestion(pathString);
            }
        }
        catch (Exception re) {
            this.log.error((Object)"can not update last activity of question", (Throwable)re);
        }
    }
}

