/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.appcenter.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.jaxrs.PATCH;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.exoplatform.appcenter.dto.Application;
import org.exoplatform.appcenter.dto.ApplicationImage;
import org.exoplatform.appcenter.dto.ApplicationList;
import org.exoplatform.appcenter.dto.ApplicationOrder;
import org.exoplatform.appcenter.dto.GeneralSettings;
import org.exoplatform.appcenter.service.ApplicationAlreadyExistsException;
import org.exoplatform.appcenter.service.ApplicationCenterService;
import org.exoplatform.appcenter.service.ApplicationNotFoundException;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.MembershipEntry;

@Path(value="app-center")
@RolesAllowed(value={"users"})
@Api(value="/app-center", description="Manage and access application center applications")
public class ApplicationCenterREST
implements ResourceContainer {
    private static final String APPLICATIONS_ENDPOINT = "applications";
    private static final String SETTINGS_ENDPOINT = "settings";
    private static final String FAVORITES_APPLICATIONS_ENDPOINT = "applications/favorites";
    private static final String AUTHORIZED_APPLICATIONS_ENDPOINT = "applications/authorized";
    private static final String LOG_OPEN_DRAWER_ENDPOINT = "applications/logOpenDrawer";
    private static final String LOG_CLICK_ALL_APPLICATIONS_ENDPOINT = "applications/logClickAllApplications";
    private static final String LOG_CLICK_ONE_APPLICATION_ENDPOINT = "applications/logClickApplication";
    private static final String ADMINISTRATORS_GROUP = "/platform/administrators";
    private static final Log LOG = ExoLogger.getLogger(ApplicationCenterREST.class);
    private ApplicationCenterService appCenterService;
    private final String baseURI;

    public ApplicationCenterREST(ApplicationCenterService appCenterService, PortalContainer container) {
        this.appCenterService = appCenterService;
        this.baseURI = "/" + container.getName() + "/" + container.getRestContextName() + "/";
    }

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieves all available subresources of current endpoint", httpMethod="GET", response=Response.class, produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error")})
    public Response getAvailableSubResources() {
        try {
            HashMap<String, List<String>> availableEnpoints = new HashMap<String, List<String>>();
            ConversationState current = ConversationState.getCurrent();
            if (current.getIdentity().isMemberOf(new MembershipEntry(ADMINISTRATORS_GROUP, "*"))) {
                availableEnpoints.put("subResourcesHref", Arrays.asList(this.baseURI + FAVORITES_APPLICATIONS_ENDPOINT, this.baseURI + AUTHORIZED_APPLICATIONS_ENDPOINT, this.baseURI + SETTINGS_ENDPOINT, this.baseURI + APPLICATIONS_ENDPOINT));
            } else {
                availableEnpoints.put("subResourcesHref", Arrays.asList(this.baseURI + FAVORITES_APPLICATIONS_ENDPOINT, this.baseURI + AUTHORIZED_APPLICATIONS_ENDPOINT, this.baseURI + SETTINGS_ENDPOINT));
            }
            return Response.ok(availableEnpoints).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while updating application", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="applications")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    @ApiOperation(value="Retrieves all available applications", httpMethod="GET", response=Response.class, produces="application/json", notes="Return list of applications in json format")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error")})
    public Response getApplicationsList(@ApiParam(value="Query Offset", required=true) @QueryParam(value="offset") int offset, @ApiParam(value="Query results limit", required=true) @QueryParam(value="limit") int limit, @ApiParam(value="Keyword to search in applications title and url", required=true) @QueryParam(value="keyword") String keyword) {
        try {
            ApplicationList applicationList = this.appCenterService.getApplicationsList(offset, limit, keyword);
            return Response.ok((Object)applicationList).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while updating application", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="applications/authorized")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Retrieves all authorized applications for currently authenticated user", httpMethod="GET", response=Response.class, produces="application/json", notes="Return list of applications in json format")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error")})
    public Response getAuthorizedApplicationsList(@ApiParam(value="Query Offset", required=true) @QueryParam(value="offset") int offset, @ApiParam(value="Query results limit", required=true) @QueryParam(value="limit") int limit, @ApiParam(value="Keyword to search in applications title and url", required=true) @QueryParam(value="keyword") String keyword) {
        try {
            ApplicationList applicationList = this.appCenterService.getAuthorizedApplicationsList(offset, limit, keyword, this.getCurrentUserName());
            return Response.ok((Object)applicationList).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while updating application", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="applications/favorites")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Retrieves favorite applications for currently authenticated user", httpMethod="GET", response=Response.class, produces="application/json", notes="Return list of applications in json format")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error")})
    public Response getFavoriteApplicationsList() {
        try {
            ApplicationList applicationList = this.appCenterService.getMandatoryAndFavoriteApplicationsList(this.getCurrentUserName());
            return Response.ok((Object)applicationList).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while updating application", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="applications/logClickAllApplications")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Log that the currently authenticated user clicked on View All Applications button", httpMethod="GET", response=Response.class, notes="empty response")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error")})
    public Response logClickAllApplications() {
        try {
            LOG.info("service={} operation={} parameters=\"user:{}\" status=ok duration_ms={}", new Object[]{ApplicationCenterService.LOG_SERVICE_NAME, ApplicationCenterService.LOG_CLICK_ALL_APPLICATIONS, this.getCurrentUserName(), "0"});
            return Response.ok().build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while updating application", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="applications/logClickApplication/{applicationId}")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Log that the currently authenticated user clicked on one Application", httpMethod="GET", response=Response.class, notes="empty response")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error")})
    public Response logClickOneApplications(@ApiParam(value="Application technical id to log", required=true) @PathParam(value="applicationId") Long applicationId) {
        try {
            Application application = this.appCenterService.findApplication(applicationId);
            LOG.info("service={} operation={} parameters=\"user:{},applicationId={},applicationName={}\" status=ok duration_ms={}", new Object[]{ApplicationCenterService.LOG_SERVICE_NAME, "open-application", this.getCurrentUserName(), applicationId, application.getTitle(), "0"});
            return Response.ok().build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while updating application", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="applications/logOpenDrawer")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Log that the currently authenticated user has openend the favorites drawer", httpMethod="GET", response=Response.class, notes="empty response")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error")})
    public Response logOpenDrawer() {
        try {
            LOG.info("service={} operation={} parameters=\"user:{}\" status=ok duration_ms={}", new Object[]{ApplicationCenterService.LOG_SERVICE_NAME, ApplicationCenterService.LOG_OPEN_FAVORITE_DRAWER, this.getCurrentUserName(), "0"});
            return Response.ok().build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while updating application", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="settings")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Modifies default application image setting", httpMethod="GET", response=Response.class, notes="empty response")
    @ApiResponses(value={@ApiResponse(code=204, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error")})
    public Response getAppGeneralSettings() {
        try {
            GeneralSettings generalSettings = this.appCenterService.getAppGeneralSettings();
            return Response.ok((Object)generalSettings).build();
        }
        catch (ApplicationNotFoundException e) {
            LOG.warn((Object)e);
            return Response.serverError().build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while updating application", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @POST
    @Path(value="applications")
    @Consumes(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    @ApiOperation(value="Creates a new application in application center", httpMethod="GET", response=Response.class, notes="empty response")
    @ApiResponses(value={@ApiResponse(code=204, message="Request fulfilled"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response createApplication(@ApiParam(value="Application to save", required=true) Application application) {
        try {
            this.appCenterService.createApplication(application);
        }
        catch (ApplicationAlreadyExistsException e) {
            LOG.warn((Object)e);
            return Response.serverError().build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while creating application", (Throwable)e);
            return Response.serverError().build();
        }
        return Response.noContent().build();
    }

    @PUT
    @Path(value="applications")
    @RolesAllowed(value={"administrators"})
    @ApiOperation(value="Updates an existing application identified by its id or title or url", httpMethod="GET", response=Response.class, notes="empty response")
    @ApiResponses(value={@ApiResponse(code=204, message="Request fulfilled"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response updateApplication(@ApiParam(value="Application to update", required=true) Application application) {
        try {
            this.appCenterService.updateApplication(application, this.getCurrentUserName());
        }
        catch (IllegalAccessException e) {
            LOG.warn((Object)e);
            return Response.status((int)401).build();
        }
        catch (ApplicationAlreadyExistsException e) {
            LOG.warn((Object)e);
            return Response.serverError().build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while updating application", (Throwable)e);
            return Response.serverError().build();
        }
        return Response.noContent().build();
    }

    @DELETE
    @Path(value="applications/{applicationId}")
    @RolesAllowed(value={"administrators"})
    @ApiOperation(value="Deletes an existing application identified by its id", httpMethod="GET", response=Response.class, notes="empty response")
    @ApiResponses(value={@ApiResponse(code=204, message="Request fulfilled"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response deleteApplication(@ApiParam(value="Application technical id to delete", required=true) @PathParam(value="applicationId") Long applicationId) {
        try {
            this.appCenterService.deleteApplication(applicationId, this.getCurrentUserName());
        }
        catch (IllegalAccessException e) {
            LOG.warn((Object)e);
            return Response.status((int)401).build();
        }
        catch (ApplicationNotFoundException e) {
            LOG.warn((Object)e);
            return Response.serverError().build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while deleting application", (Throwable)e);
            return Response.serverError().build();
        }
        return Response.noContent().build();
    }

    @POST
    @Path(value="applications/favorites/{applicationId}")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Adds an existing application identified by its id as favorite for current authenticated user", httpMethod="GET", response=Response.class, notes="empty response")
    @ApiResponses(value={@ApiResponse(code=204, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error")})
    public Response addFavoriteApplication(@ApiParam(value="Application technical id to add as favorite", required=true) @PathParam(value="applicationId") Long applicationId) {
        try {
            long startTime = System.currentTimeMillis();
            Application application = this.appCenterService.findApplication(applicationId);
            this.appCenterService.addFavoriteApplication(applicationId, this.getCurrentUserName());
            long endTime = System.currentTimeMillis();
            long totalTime = endTime - startTime;
            LOG.info("service={} operation={} parameters=\"user:{},applicationId={},applicationName={}\" status=ok duration_ms={}", new Object[]{ApplicationCenterService.LOG_SERVICE_NAME, "add-favorite", this.getCurrentUserName(), applicationId, application.getTitle(), totalTime});
            return Response.noContent().build();
        }
        catch (IllegalAccessException e) {
            LOG.warn((Object)e);
            return Response.status((int)401).build();
        }
        catch (ApplicationNotFoundException e) {
            LOG.warn((Object)e);
            return Response.serverError().build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while adding application as favorite", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @PUT
    @Path(value="applications/favorites")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Updates an existing application's order identified by its id", httpMethod="GET", response=Response.class, notes="empty response")
    @ApiResponses(value={@ApiResponse(code=204, message="Request fulfilled"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response updateApplicationsOrder(@ApiParam(value="Application to update", required=true) List<ApplicationOrder> applicationOrders) {
        try {
            long startTime = System.currentTimeMillis();
            for (ApplicationOrder applicationOrder : applicationOrders) {
                this.appCenterService.updateFavoriteApplicationOrder(applicationOrder, this.getCurrentUserName());
            }
            long endTime = System.currentTimeMillis();
            long totalTime = endTime - startTime;
            LOG.info("service={} operation={} parameters=\"user:{}\" status=ok duration_ms={}", new Object[]{ApplicationCenterService.LOG_SERVICE_NAME, "reorganize-favorites", this.getCurrentUserName(), totalTime});
        }
        catch (ApplicationNotFoundException e) {
            LOG.warn((Object)e);
            return Response.serverError().build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while adding application as favorite", (Throwable)e);
            return Response.serverError().build();
        }
        return Response.noContent().build();
    }

    @DELETE
    @Path(value="applications/favorites/{applicationId}")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Deletes an existing application identified by its id from current authenticated user favorites", httpMethod="GET", response=Response.class, notes="empty response")
    @ApiResponses(value={@ApiResponse(code=204, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error")})
    public Response deleteFavoriteApplication(@ApiParam(value="Application technical id to delete from favorite", required=true) @PathParam(value="applicationId") Long applicationId) {
        try {
            long startTime = System.currentTimeMillis();
            Application application = this.appCenterService.findApplication(applicationId);
            this.appCenterService.deleteFavoriteApplication(applicationId, this.getCurrentUserName());
            long endTime = System.currentTimeMillis();
            long totalTime = endTime - startTime;
            LOG.info("service={} operation={} parameters=\"user:{},applicationId={},applicationName={}\" status=ok duration_ms={}", new Object[]{ApplicationCenterService.LOG_SERVICE_NAME, "remove-favorite", this.getCurrentUserName(), applicationId, application.getTitle(), totalTime});
            return Response.noContent().build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while deleting application from favorites", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @PATCH
    @Path(value="settings/maxFavorites")
    @RolesAllowed(value={"administrators"})
    @ApiOperation(value="Modifies maximum application count to add as favorites for all users", httpMethod="GET", response=Response.class, notes="empty response")
    @ApiResponses(value={@ApiResponse(code=204, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error")})
    public Response setMaxFavoriteApps(@ApiParam(value="Max favorites number", required=true) @QueryParam(value="number") long number) {
        try {
            this.appCenterService.setMaxFavoriteApps(number);
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while updating application", (Throwable)e);
            return Response.serverError().build();
        }
        return Response.noContent().build();
    }

    @PATCH
    @Path(value="settings/image")
    @Consumes(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    @ApiOperation(value="Modifies default application image setting", httpMethod="GET", response=Response.class, notes="empty response")
    @ApiResponses(value={@ApiResponse(code=204, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error")})
    public Response setDefaultAppImage(@ApiParam(value="Application image id, body and name", required=true) ApplicationImage defaultAppImage) {
        try {
            this.appCenterService.setDefaultAppImage(defaultAppImage);
            return Response.noContent().build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while updating application", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="applications/illustration/{applicationId}")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Gets an application illustration by application id", httpMethod="GET", response=Response.class, notes="This can only be done by the logged in user.")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=404, message="Resource not found")})
    public Response getApplicationIllustration(@Context Request request, @ApiParam(value="Application id", required=true) @PathParam(value="applicationId") long applicationId) {
        try {
            Long lastUpdated = this.appCenterService.getApplicationImageLastUpdated(applicationId, this.getCurrentUserName());
            if (lastUpdated == null) {
                return Response.status((int)404).build();
            }
            EntityTag eTag = new EntityTag(Integer.toString(lastUpdated.hashCode()));
            Response.ResponseBuilder builder = request.evaluatePreconditions(eTag);
            if (builder == null) {
                InputStream stream = this.appCenterService.getApplicationImageInputStream(applicationId, this.getCurrentUserName());
                if (stream == null) {
                    return Response.status((int)404).build();
                }
                builder = Response.ok((Object)stream, (String)"image/png");
                builder.tag(eTag);
            }
            CacheControl cc = new CacheControl();
            cc.setMaxAge(86400);
            builder.cacheControl(cc);
            return builder.cacheControl(cc).build();
        }
        catch (IllegalAccessException e) {
            LOG.warn((Object)e);
            return Response.status((int)401).build();
        }
        catch (ApplicationNotFoundException e) {
            LOG.warn((Object)e);
            return Response.serverError().build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while getting application illustration", (Throwable)e);
            return Response.serverError().build();
        }
    }

    private String getCurrentUserName() {
        ConversationState state = ConversationState.getCurrent();
        return state == null || state.getIdentity() == null ? null : state.getIdentity().getUserId();
    }
}

