/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.appCenter.services.rest;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.appCenter.services.dao.ApplicationDAO;
import org.exoplatform.appCenter.services.dao.FavoriteApplicationDAO;
import org.exoplatform.appCenter.services.entity.ApplicationForm;
import org.exoplatform.appCenter.services.entity.ApplicationImage;
import org.exoplatform.appCenter.services.entity.jpa.Application;
import org.exoplatform.appCenter.services.entity.jpa.FavoriteApplication;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.file.model.FileItem;
import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.service.rest.Util;
import org.json.JSONArray;
import org.json.JSONObject;

@Path(value="appCenter/applications")
public class ApplicationsRestService
implements ResourceContainer {
    private static final Log log = ExoLogger.getLogger(ApplicationsRestService.class);
    private ApplicationDAO applicationDAO;
    private FavoriteApplicationDAO favoriteApplicationDAO;
    private FileService fileService;
    private SettingService settingService;
    private OrganizationService organizationService;
    public static final String NAME_SPACE = "appCenter";
    public static final String MAX_FAVORITE_APPS = "maxFavoriteApps";
    public static final String DEFAULT_APP_IMAGE_ID = "defaultAppImageId";
    public static final String DEFAULT_APP_IMAGE_NAME = "defaultAppImageName";
    public static final String DEFAULT_APP_IMAGE_BODY = "defaultAppImageBody";
    public static final String APP_ID = "appId";
    public static final String APP_TITLE = "appTitle";
    public static final String APP_URL = "appUrl";
    public static final String APP_IMAGE_FILE_ID = "appImageFileId";
    public static final String APP_IMAGE_FILE_NAME = "appImageFileName";
    public static final String APP_IMAGE_FILE_BODY = "appImageFileBody";
    public static final String APP_DESCRIPTION = "appDescription";
    public static final String APP_ACTIVE = "appActive";
    public static final String APP_DEFAULT = "appDefault";
    public static final String APP_PERMISSIONS = "appPermissions";
    public static final String ADMINISTRATORS_PERMISSION = "*:/platform/administrators";

    public ApplicationsRestService(ApplicationDAO applicationDAO, FavoriteApplicationDAO favoriteApplicationDAO, FileService fileService, SettingService settingService, OrganizationService organizationService) {
        this.applicationDAO = applicationDAO;
        this.favoriteApplicationDAO = favoriteApplicationDAO;
        this.fileService = fileService;
        this.settingService = settingService;
        this.organizationService = organizationService;
    }

    @POST
    @Path(value="/addApplication")
    @RolesAllowed(value={"administrators"})
    public Response addApplication(@Context UriInfo uriInfo, ApplicationForm applicationForm) throws Exception {
        Application existingApplication = this.applicationDAO.getAppByTitleOrUrl(applicationForm.getTitle(), applicationForm.getUrl());
        if (existingApplication != null) {
            return existingApplication.getTitle().equals(applicationForm.getTitle()) ? Util.getResponse((Object)(applicationForm.getTitle() + " application already exists"), (UriInfo)uriInfo, (MediaType)MediaType.TEXT_PLAIN_TYPE, (Response.Status)Response.Status.UNAUTHORIZED) : Util.getResponse((Object)(applicationForm.getUrl() + " application already exists"), (UriInfo)uriInfo, (MediaType)MediaType.TEXT_PLAIN_TYPE, (Response.Status)Response.Status.UNAUTHORIZED);
        }
        FileItem fileItem = this.createAppImageFileItem(applicationForm.getImageFileName(), applicationForm.getImageFileBody());
        Long fileId = fileItem != null ? fileItem.getFileInfo().getId() : null;
        Application application = new Application(applicationForm.getTitle(), applicationForm.getUrl(), fileId, applicationForm.getDescription(), applicationForm.isActive(), applicationForm.isByDefault(), applicationForm.getPermissions().length == 0 ? ADMINISTRATORS_PERMISSION : String.join((CharSequence)",", applicationForm.getPermissions()));
        this.applicationDAO.create(application);
        return Util.getResponse((Object)(application.getTitle() + " application is created successfully"), (UriInfo)uriInfo, (MediaType)MediaType.TEXT_PLAIN_TYPE, (Response.Status)Response.Status.OK);
    }

    @GET
    @Path(value="/addFavoriteApplication/{applicationId}")
    @RolesAllowed(value={"users"})
    public Response addFavoriteApplication(@Context UriInfo uriInfo, @PathParam(value="applicationId") Long applicationId) throws Exception {
        String currentUser = ConversationState.getCurrent().getIdentity().getUserId();
        Application application = (Application)this.applicationDAO.find(applicationId);
        if (application == null) {
            return Util.getResponse((Object)("Can not find application with id " + applicationId), (UriInfo)uriInfo, (MediaType)MediaType.TEXT_PLAIN_TYPE, (Response.Status)Response.Status.NOT_FOUND);
        }
        FavoriteApplication favoriteApplication = new FavoriteApplication(application, currentUser);
        this.favoriteApplicationDAO.create(favoriteApplication);
        return this.getFavoriteApplicationsList(uriInfo);
    }

    @POST
    @Path(value="/editApplication")
    @RolesAllowed(value={"administrators"})
    @ExoTransactional
    public Response editApplication(@Context UriInfo uriInfo, ApplicationForm applicationForm) throws Exception {
        Application application = (Application)this.applicationDAO.find(applicationForm.getId());
        if (application == null) {
            return Util.getResponse((Object)"No application found", (UriInfo)uriInfo, (MediaType)MediaType.TEXT_PLAIN_TYPE, (Response.Status)Response.Status.NOT_FOUND);
        }
        FileItem fileItem = this.createAppImageFileItem(applicationForm.getImageFileName(), applicationForm.getImageFileBody());
        Long fileId = fileItem != null ? fileItem.getFileInfo().getId() : null;
        application.setTitle(applicationForm.getTitle());
        application.setUrl(applicationForm.getUrl());
        application.setImageFileId(fileId);
        application.setDescription(applicationForm.getDescription());
        application.setActive(applicationForm.isActive());
        application.setByDefault(applicationForm.isByDefault());
        application.setPermissions(applicationForm.getPermissions().length == 0 ? ADMINISTRATORS_PERMISSION : String.join((CharSequence)",", applicationForm.getPermissions()));
        this.applicationDAO.update(application);
        List<FavoriteApplication> favoriteApplications = this.favoriteApplicationDAO.getFavoriteAppsByAppId(application.getId());
        if (favoriteApplications.size() > 0) {
            if (!application.isActive()) {
                favoriteApplications.forEach(favoriteApplication -> this.favoriteApplicationDAO.delete(favoriteApplication));
            } else {
                favoriteApplications.forEach(favoriteApplication -> {
                    try {
                        Collection groups = this.organizationService.getGroupHandler().findGroupsOfUser(favoriteApplication.getUserName());
                        boolean isMember = false;
                        for (Group group : groups) {
                            if (!favoriteApplication.getApplication().getPermissions().contains(group.getGroupName())) continue;
                            isMember = true;
                            break;
                        }
                        if (!isMember) {
                            this.favoriteApplicationDAO.delete(favoriteApplication);
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)("Can not get groups of user " + favoriteApplication.getUserName()), (Throwable)e);
                    }
                });
            }
        }
        return Util.getResponse((Object)(application.getTitle() + " application is updated successfully"), (UriInfo)uriInfo, (MediaType)MediaType.TEXT_PLAIN_TYPE, (Response.Status)Response.Status.OK);
    }

    @GET
    @Path(value="/deleteApplication/{applicationId}")
    @RolesAllowed(value={"administrators"})
    public Response deleteApplication(@Context UriInfo uriInfo, @PathParam(value="applicationId") Long applicationId) throws Exception {
        Application application = (Application)this.applicationDAO.find(applicationId);
        if (application == null) {
            return Util.getResponse((Object)"No application found", (UriInfo)uriInfo, (MediaType)MediaType.TEXT_PLAIN_TYPE, (Response.Status)Response.Status.NOT_FOUND);
        }
        String title = application.getTitle();
        this.applicationDAO.delete(application);
        return Util.getResponse((Object)(title + " application is deleted successfully"), (UriInfo)uriInfo, (MediaType)MediaType.TEXT_PLAIN_TYPE, (Response.Status)Response.Status.OK);
    }

    @GET
    @Path(value="/deleteFavoriteApplication/{applicationId}")
    @RolesAllowed(value={"users"})
    public Response deleteFavoriteApplication(@Context UriInfo uriInfo, @PathParam(value="applicationId") Long applicationId) throws Exception {
        Application application = (Application)this.applicationDAO.find(applicationId);
        if (application == null) {
            return Util.getResponse((Object)("Can not find application with id " + applicationId), (UriInfo)uriInfo, (MediaType)MediaType.TEXT_PLAIN_TYPE, (Response.Status)Response.Status.NOT_FOUND);
        }
        String currentUser = ConversationState.getCurrent().getIdentity().getUserId();
        FavoriteApplication favoriteApplication = this.favoriteApplicationDAO.getFavoriteAppByUserNameAndAppId(applicationId, currentUser);
        if (favoriteApplication == null) {
            return Util.getResponse((Object)("Application " + applicationId + " is not a favorite application for user " + currentUser), (UriInfo)uriInfo, (MediaType)MediaType.TEXT_PLAIN_TYPE, (Response.Status)Response.Status.OK);
        }
        this.favoriteApplicationDAO.delete(favoriteApplication);
        return this.getFavoriteApplicationsList(uriInfo);
    }

    @GET
    @Path(value="/setMaxFavorite")
    @RolesAllowed(value={"administrators"})
    public Response setMaxFavoriteApps(@Context UriInfo uriInfo, @QueryParam(value="number") String number) throws Exception {
        if (number != null) {
            this.settingService.set(org.exoplatform.commons.api.settings.data.Context.GLOBAL, Scope.GLOBAL, MAX_FAVORITE_APPS, SettingValue.create((String)number));
        } else {
            this.settingService.remove(org.exoplatform.commons.api.settings.data.Context.GLOBAL, Scope.GLOBAL, MAX_FAVORITE_APPS);
        }
        return Util.getResponse((Object)"Max favorite applications is set successfully", (UriInfo)uriInfo, (MediaType)MediaType.TEXT_PLAIN_TYPE, (Response.Status)Response.Status.OK);
    }

    @POST
    @Path(value="/setDefaultImage")
    @RolesAllowed(value={"administrators"})
    public Response setDefaultAppImage(@Context UriInfo uriInfo, ApplicationImage defaultAppImage) throws Exception {
        FileItem fileItem = this.createAppImageFileItem(defaultAppImage.getFileName(), defaultAppImage.getFileBody());
        if (fileItem != null) {
            this.settingService.set(org.exoplatform.commons.api.settings.data.Context.GLOBAL, Scope.GLOBAL, DEFAULT_APP_IMAGE_ID, SettingValue.create((String)String.valueOf(fileItem.getFileInfo().getId())));
        } else {
            this.settingService.remove(org.exoplatform.commons.api.settings.data.Context.GLOBAL, Scope.GLOBAL, DEFAULT_APP_IMAGE_ID);
        }
        return Util.getResponse((Object)"Default application image is set successfully", (UriInfo)uriInfo, (MediaType)MediaType.TEXT_PLAIN_TYPE, (Response.Status)Response.Status.OK);
    }

    @GET
    @Path(value="/getGeneralSettings")
    @RolesAllowed(value={"users"})
    public Response getAppGeneralSettings(@Context UriInfo uriInfo) throws Exception {
        JSONObject generalsettings = new JSONObject();
        generalsettings.put(MAX_FAVORITE_APPS, (Object)this.getMaxFavoriteApps());
        if (this.settingService.get(org.exoplatform.commons.api.settings.data.Context.GLOBAL, Scope.GLOBAL, DEFAULT_APP_IMAGE_ID) != null) {
            String defaultAppImageId = this.settingService.get(org.exoplatform.commons.api.settings.data.Context.GLOBAL, Scope.GLOBAL, DEFAULT_APP_IMAGE_ID).getValue().toString();
            Map<String, String> defaultAppImageFile = this.getAppImageFile(Long.parseLong(defaultAppImageId));
            if (defaultAppImageFile.containsKey(APP_IMAGE_FILE_NAME)) {
                generalsettings.put(DEFAULT_APP_IMAGE_NAME, (Object)defaultAppImageFile.get(APP_IMAGE_FILE_NAME));
            }
            if (defaultAppImageFile.containsKey(APP_IMAGE_FILE_BODY)) {
                generalsettings.put(DEFAULT_APP_IMAGE_BODY, (Object)defaultAppImageFile.get(APP_IMAGE_FILE_BODY));
            }
        }
        return Util.getResponse((Object)generalsettings.toString(), (UriInfo)uriInfo, (MediaType)MediaType.APPLICATION_JSON_TYPE, (Response.Status)Response.Status.OK);
    }

    @GET
    @Path(value="/getApplicationsList")
    @RolesAllowed(value={"administrators"})
    public Response getApplicationsList(@Context UriInfo uriInfo, @QueryParam(value="offset") String offset, @QueryParam(value="limit") String limit, @QueryParam(value="keyword") String keyword) throws Exception {
        List<Application> applicationsList = this.applicationDAO.findAll().stream().filter(app -> StringUtils.containsIgnoreCase((CharSequence)app.getTitle(), (CharSequence)keyword) || StringUtils.containsIgnoreCase((CharSequence)app.getDescription(), (CharSequence)keyword)).collect(Collectors.toList());
        JSONObject applicationsListJson = this.getApplicationsListJson(applicationsList, offset, limit, null);
        return Util.getResponse((Object)applicationsListJson.toString(), (UriInfo)uriInfo, (MediaType)MediaType.APPLICATION_JSON_TYPE, (Response.Status)Response.Status.OK);
    }

    @GET
    @Path(value="/getAuthorizedApplicationsList")
    @RolesAllowed(value={"users"})
    public Response getAuthorizedApplicationsList(@Context UriInfo uriInfo, @QueryParam(value="offset") String offset, @QueryParam(value="limit") String limit, @QueryParam(value="keyword") String keyword) throws Exception {
        String currentUser = ConversationState.getCurrent().getIdentity().getUserId();
        Collection groups = this.organizationService.getGroupHandler().findGroupsOfUser(currentUser);
        List<Application> authorizedApplicationsList = this.applicationDAO.getAuthorizedApplications(currentUser, groups, keyword);
        JSONObject authorizedApplicationsListJson = this.getApplicationsListJson(authorizedApplicationsList, offset, limit, "authorized");
        return Util.getResponse((Object)authorizedApplicationsListJson.toString(), (UriInfo)uriInfo, (MediaType)MediaType.APPLICATION_JSON_TYPE, (Response.Status)Response.Status.OK);
    }

    @GET
    @Path(value="/getFavoriteApplicationsList")
    @RolesAllowed(value={"users"})
    public Response getFavoriteApplicationsList(@Context UriInfo uriInfo) throws Exception {
        List<Application> favoriteApplicationsList = this.getFavoriteApplications();
        JSONObject favoriteApplicationsListJson = this.getApplicationsListJson(favoriteApplicationsList, null, null, "favorite");
        return Util.getResponse((Object)favoriteApplicationsListJson.toString(), (UriInfo)uriInfo, (MediaType)MediaType.APPLICATION_JSON_TYPE, (Response.Status)Response.Status.OK);
    }

    private JSONObject getApplicationsListJson(List<Application> applicationsList, String offset, String limit, String type) throws Exception {
        applicationsList = applicationsList.stream().sorted(Comparator.comparing(Application::getTitle)).collect(Collectors.toList());
        JSONObject applicationtsListJson = new JSONObject();
        if (offset != null && limit != null) {
            applicationtsListJson.put("totalApplications", applicationsList.size());
            applicationtsListJson.put("totalPages", applicationsList.size() % Integer.parseInt(limit) == 0 ? applicationsList.size() / Integer.parseInt(limit) : applicationsList.size() / Integer.parseInt(limit) + 1);
            applicationsList = applicationsList.stream().skip(Integer.parseInt(offset) * Integer.parseInt(limit)).limit(Integer.parseInt(limit)).collect(Collectors.toList());
        }
        JSONArray applicationsListJsonArray = new JSONArray();
        applicationsList.stream().forEachOrdered(application -> {
            try {
                JSONObject applicationtJson = new JSONObject();
                applicationtJson.put(APP_ID, (Object)application.getId());
                applicationtJson.put(APP_TITLE, (Object)application.getTitle());
                applicationtJson.put(APP_URL, (Object)application.getUrl());
                Map<String, String> appImageFile = this.getAppImageFile(application.getImageFileId());
                if (appImageFile.containsKey(APP_IMAGE_FILE_NAME)) {
                    applicationtJson.put(APP_IMAGE_FILE_NAME, (Object)appImageFile.get(APP_IMAGE_FILE_NAME));
                }
                if (appImageFile.containsKey(APP_IMAGE_FILE_BODY)) {
                    applicationtJson.put(APP_IMAGE_FILE_BODY, (Object)appImageFile.get(APP_IMAGE_FILE_BODY));
                }
                applicationtJson.put(APP_DESCRIPTION, (Object)application.getDescription());
                applicationtJson.put(APP_ACTIVE, application.isActive());
                applicationtJson.put(APP_DEFAULT, application.isByDefault());
                String[] permissions = (String[])Arrays.stream(application.getPermissions().split(",")).toArray(String[]::new);
                applicationtJson.put(APP_PERMISSIONS, (Object)permissions);
                if (type != null && type.equals("authorized")) {
                    applicationtJson.put("isFavorite", this.isFavoriteApplication(application.getId()));
                }
                applicationsListJsonArray.put((Object)applicationtJson);
            }
            catch (Exception e) {
                log.error((Object)"Can not build application json", (Throwable)e);
            }
        });
        applicationtsListJson.put("applications", (Object)applicationsListJsonArray);
        if (type != null && type.equals("authorized")) {
            applicationtsListJson.put("canAddFavorite", this.getMaxFavoriteApps() == null || this.getFavoriteApplications().size() < Integer.parseInt(this.getMaxFavoriteApps()));
        }
        return applicationtsListJson;
    }

    private FileItem createAppImageFileItem(String fileName, String fileBody) throws Exception {
        FileItem fileItem = null;
        if (fileName != null && !fileName.equals("") && fileBody != null && !fileBody.equals("")) {
            String[] file = fileBody.split(",");
            String fileContent = file[1];
            String fileMime = file[0].replace("data:", "").replace(";base64", "");
            Date currentDate = new Date();
            byte[] fileContentBytes = Base64.getDecoder().decode(fileContent);
            long size = 0L;
            String currentUser = ConversationState.getCurrent().getIdentity().getUserId();
            fileItem = new FileItem(null, fileName, fileMime, NAME_SPACE, size, currentDate, currentUser, false, (InputStream)new ByteArrayInputStream(fileContentBytes));
            fileItem = this.fileService.writeFile(fileItem);
        }
        return fileItem;
    }

    private Map<String, String> getAppImageFile(Long fileId) throws Exception {
        if (fileId == null && this.settingService.get(org.exoplatform.commons.api.settings.data.Context.GLOBAL, Scope.GLOBAL, DEFAULT_APP_IMAGE_ID) == null) {
            return new HashMap<String, String>();
        }
        if (fileId == null) {
            fileId = Long.parseLong(this.settingService.get(org.exoplatform.commons.api.settings.data.Context.GLOBAL, Scope.GLOBAL, DEFAULT_APP_IMAGE_ID).getValue().toString());
        }
        FileItem fileItem = this.fileService.getFile(fileId.longValue());
        HashMap<String, String> file = new HashMap<String, String>();
        if (fileItem != null) {
            byte[] bytes = fileItem.getAsByte();
            String fileBody = Base64.getEncoder().encodeToString(bytes);
            String fileMime = fileItem.getFileInfo().getMimetype();
            String fileName = fileItem.getFileInfo().getName();
            file.put(APP_IMAGE_FILE_NAME, fileName);
            file.put(APP_IMAGE_FILE_BODY, "data:" + fileMime + ";base64," + fileBody);
        }
        return file;
    }

    private boolean isFavoriteApplication(Long applicationId) throws Exception {
        Application application = (Application)this.applicationDAO.find(applicationId);
        if (application == null) {
            return false;
        }
        String currentUser = ConversationState.getCurrent().getIdentity().getUserId();
        FavoriteApplication favoriteApplication = this.favoriteApplicationDAO.getFavoriteAppByUserNameAndAppId(applicationId, currentUser);
        return favoriteApplication != null;
    }

    private String getMaxFavoriteApps() {
        return this.settingService.get(org.exoplatform.commons.api.settings.data.Context.GLOBAL, Scope.GLOBAL, MAX_FAVORITE_APPS) != null ? this.settingService.get(org.exoplatform.commons.api.settings.data.Context.GLOBAL, Scope.GLOBAL, MAX_FAVORITE_APPS).getValue().toString() : null;
    }

    private List<Application> getFavoriteApplications() throws Exception {
        String currentUser = ConversationState.getCurrent().getIdentity().getUserId();
        List<Object> favoriteApplications = new ArrayList();
        Collection groups = this.organizationService.getGroupHandler().findGroupsOfUser(currentUser);
        favoriteApplications = Stream.concat(this.favoriteApplicationDAO.getFavoriteApps(currentUser).stream().map(userFavoriteApp -> userFavoriteApp.getApplication()), this.applicationDAO.getDefaultApplications(currentUser, groups).stream()).distinct().sorted(Comparator.comparing(Application::getTitle)).collect(Collectors.toList());
        if (this.getMaxFavoriteApps() != null) {
            favoriteApplications = favoriteApplications.stream().limit(Long.parseLong(this.getMaxFavoriteApps())).collect(Collectors.toList());
        }
        return favoriteApplications;
    }
}

