/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.appcenter.service;

import io.meeds.appcenter.model.Application;
import io.meeds.appcenter.model.ApplicationDescriptor;
import io.meeds.appcenter.service.ApplicationCenterInjectService;
import io.meeds.appcenter.service.ApplicationCenterService;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;

@SpringBootTest(classes={ApplicationCenterInjectService.class})
@ExtendWith(value={MockitoExtension.class})
public class ApplicationCenterInjectServiceTest {
    private static final long IMAGE_FILE_ID = 5L;
    private static final long IMAGE_LAST_MODIFIED = 588L;
    private static final String HELP_PAGE_URL = "./helpPageUrl";
    private static final String URL = "./url";
    private static final String PERMISSIONS_1 = "/permissions1";
    private static final String DESCRIPTION = "description";
    private static final String TITLE = "title";
    private static final Long ID = 2L;
    @MockBean
    private ConfigurationManager configurationManager;
    @MockBean
    private SettingService settingService;
    @MockBean
    private ApplicationCenterService applicationCenterService;
    @Autowired
    private ApplicationCenterInjectService applicationCenterInjectService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void injectDefaultApplications() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.applicationCenterInjectService.addApplicationPlugin(null));
        this.applicationCenterInjectService.injectDefaultApplications();
        Assertions.assertEquals((int)1, (int)this.applicationCenterInjectService.getDefaultApplications().size(), (String)"Should have injected data from 'applications.json' file");
        String pluginName = "testapp";
        Application application = this.application();
        ApplicationDescriptor applicationPlugin1 = new ApplicationDescriptor(null, application);
        Assertions.assertThrows(IllegalStateException.class, () -> this.applicationCenterInjectService.addApplicationPlugin(applicationPlugin1));
        applicationPlugin1.setName(pluginName);
        this.applicationCenterInjectService.addApplicationPlugin(applicationPlugin1);
        this.applicationCenterInjectService.injectDefaultApplications();
        ((ApplicationCenterService)Mockito.verify((Object)this.applicationCenterService, (VerificationMode)Mockito.never())).createApplication((Application)ArgumentMatchers.any());
        applicationPlugin1.setEnabled(true);
        try {
            this.applicationCenterInjectService.addApplicationPlugin(applicationPlugin1);
            this.applicationCenterInjectService.injectDefaultApplications();
            ((ApplicationCenterService)Mockito.verify((Object)this.applicationCenterService)).createApplication(applicationPlugin1.getApplication());
        }
        finally {
            this.applicationCenterInjectService.removeApplicationPlugin(pluginName);
        }
        ApplicationDescriptor applicationPlugin2 = new ApplicationDescriptor(pluginName, application, "jar:/test.png", "write", true, true);
        try {
            this.applicationCenterInjectService.addApplicationPlugin(applicationPlugin2);
            Mockito.when((Object)this.applicationCenterService.getApplicationByTitle(application.getTitle())).thenReturn((Object)application);
            application.setChangedManually(true);
            this.applicationCenterInjectService.injectDefaultApplications();
            ((ApplicationCenterService)Mockito.verify((Object)this.applicationCenterService)).updateApplication(application);
        }
        finally {
            this.applicationCenterInjectService.removeApplicationPlugin(pluginName);
        }
        applicationPlugin2 = new ApplicationDescriptor(pluginName, application, "jar:/test.png", "merge", false, true);
        applicationPlugin2.setName(pluginName);
        try {
            this.applicationCenterInjectService.addApplicationPlugin(applicationPlugin2);
            this.applicationCenterInjectService.injectDefaultApplications();
            ((ConfigurationManager)Mockito.verify((Object)this.configurationManager, (VerificationMode)Mockito.atLeast((int)1))).getInputStream(applicationPlugin2.getImagePath());
        }
        finally {
            this.applicationCenterInjectService.removeApplicationPlugin(pluginName);
        }
    }

    private Application application() {
        return this.application(ID);
    }

    private Application application(Long id) {
        return new Application(id, TITLE, URL, HELP_PAGE_URL, Long.valueOf(5L), Long.valueOf(588L), "", "", DESCRIPTION, false, true, false, true, false, new String[]{PERMISSIONS_1});
    }
}

