/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.appcenter.storage;

import io.meeds.appcenter.dao.ApplicationDAO;
import io.meeds.appcenter.dao.FavoriteApplicationDAO;
import io.meeds.appcenter.entity.ApplicationEntity;
import io.meeds.appcenter.entity.FavoriteApplicationEntity;
import io.meeds.appcenter.model.Application;
import io.meeds.appcenter.model.ApplicationImage;
import io.meeds.appcenter.model.exception.ApplicationNotFoundException;
import io.meeds.appcenter.storage.ApplicationCenterStorage;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.exoplatform.commons.file.model.FileInfo;
import org.exoplatform.commons.file.model.FileItem;
import org.exoplatform.commons.file.services.FileService;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;

@SpringBootTest(classes={ApplicationCenterStorage.class})
@ExtendWith(value={MockitoExtension.class})
public class ApplicationCenterStorageTest {
    private static final long IMAGE_FILE_ID = 5L;
    private static final long IMAGE_LAST_MODIFIED = 588L;
    private static final String HELP_PAGE_URL = "helpPageUrl";
    private static final String URL = "url";
    private static final String PERMISSIONS_2 = "permissions2";
    private static final String PERMISSIONS_1 = "permissions1";
    private static final String DESCRIPTION = "description";
    private static final String TITLE = "title";
    private static final String TEST_USER = "testuser";
    private static final String FILE_CONTENT = "fileContent";
    private static final Long ID = 2L;
    @MockBean
    private FileService fileService;
    @MockBean
    private ApplicationDAO applicationDAO;
    @MockBean
    private FavoriteApplicationDAO favoriteApplicationDAO;
    @Autowired
    private ApplicationCenterStorage applicationCenterStorage;

    @BeforeEach
    void setup() {
        Mockito.when((Object)this.applicationDAO.save((Object)((ApplicationEntity)Mockito.any()))).thenAnswer(invocation -> {
            ApplicationEntity entity = (ApplicationEntity)invocation.getArgument(0);
            if (entity.getId() == null) {
                entity.setId(ID);
            }
            Mockito.when((Object)this.applicationDAO.findById((Object)ID)).thenReturn(Optional.of(entity));
            return entity;
        });
        ((ApplicationDAO)Mockito.doAnswer(invocation -> {
            ApplicationEntity entity = (ApplicationEntity)invocation.getArgument(0);
            Mockito.when((Object)this.applicationDAO.findById((Object)entity.getId())).thenReturn(Optional.empty());
            return null;
        }).when((Object)this.applicationDAO)).delete((Object)((ApplicationEntity)Mockito.any()));
    }

    @Test
    void testCreateApplication() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.applicationCenterStorage.createApplication(null));
        Application application = new Application(null, TITLE, URL, "", Long.valueOf(0L), Long.valueOf(0L), null, null, DESCRIPTION, false, true, false, false, false, new String[]{PERMISSIONS_1, PERMISSIONS_2});
        Application storedApplication = this.applicationCenterStorage.createApplication(application);
        Assertions.assertNotNull((Object)storedApplication);
        Assertions.assertNotNull((Object)storedApplication.getId());
        Assertions.assertEquals((Object)application.getTitle(), (Object)storedApplication.getTitle());
        Assertions.assertEquals((Object)application.getUrl(), (Object)storedApplication.getUrl());
        Assertions.assertEquals((Long)application.getImageFileId(), (Long)storedApplication.getImageFileId());
        Assertions.assertEquals((Object)application.getDescription(), (Object)storedApplication.getDescription());
        Assertions.assertEquals((Object)application.isActive(), (Object)storedApplication.isActive());
        Assertions.assertEquals((Object)application.isMandatory(), (Object)storedApplication.isMandatory());
        Assertions.assertEquals((Object)application.getPermissions(), (Object)storedApplication.getPermissions());
    }

    @Test
    void testUpdateApplication() {
        ApplicationEntity existingApplication = new ApplicationEntity(ID, "title1", "url1", "helpPageUrl1", Long.valueOf(6L), "description1", true, false, false, false, PERMISSIONS_2, false, null);
        Mockito.when((Object)this.applicationDAO.findById((Object)ID)).thenReturn(Optional.of(existingApplication));
        Application application = this.application(ID);
        Application storedApplication = this.applicationCenterStorage.updateApplication(application);
        Assertions.assertNotNull((Object)storedApplication);
        Assertions.assertNotNull((Object)storedApplication.getId());
        Assertions.assertEquals((Object)application.getTitle(), (Object)storedApplication.getTitle());
        Assertions.assertEquals((Object)application.getUrl(), (Object)storedApplication.getUrl());
        Assertions.assertEquals((Long)application.getImageFileId(), (Long)storedApplication.getImageFileId());
        Assertions.assertEquals((Object)application.getDescription(), (Object)storedApplication.getDescription());
        Assertions.assertEquals((Object)application.isActive(), (Object)storedApplication.isActive());
        Assertions.assertEquals((Object)application.isMandatory(), (Object)storedApplication.isMandatory());
        Assertions.assertEquals((Object)application.getPermissions(), (Object)storedApplication.getPermissions());
    }

    @Test
    void testDeleteApplication() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.applicationCenterStorage.deleteApplication(0L));
        Assertions.assertThrows(ApplicationNotFoundException.class, () -> this.applicationCenterStorage.deleteApplication(5000L));
        Application application = new Application(null, TITLE, URL, "", Long.valueOf(0L), Long.valueOf(0L), null, null, DESCRIPTION, false, true, false, false, false, new String[]{PERMISSIONS_1, PERMISSIONS_2});
        Application storedApplication = this.applicationCenterStorage.createApplication(application);
        this.applicationCenterStorage.deleteApplication(storedApplication.getId().longValue());
        Assertions.assertNull((Object)this.applicationCenterStorage.getApplicationById(storedApplication.getId().longValue()));
    }

    @Test
    void testGetApplication() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.applicationCenterStorage.getApplicationById(0L));
        Assertions.assertNull((Object)this.applicationCenterStorage.getApplicationById(50000L));
        Application application = new Application(null, TITLE, URL, "", Long.valueOf(0L), Long.valueOf(0L), null, null, DESCRIPTION, false, true, false, false, false, new String[]{PERMISSIONS_1, PERMISSIONS_2});
        Application storedApplication = this.applicationCenterStorage.createApplication(application);
        storedApplication = this.applicationCenterStorage.getApplicationById(storedApplication.getId().longValue());
        Assertions.assertNotNull((Object)storedApplication);
        Assertions.assertNotNull((Object)storedApplication.getId());
        Assertions.assertEquals((Object)application.getTitle(), (Object)storedApplication.getTitle());
        Assertions.assertEquals((Object)application.getUrl(), (Object)storedApplication.getUrl());
        Assertions.assertEquals((Long)application.getImageFileId(), (Long)storedApplication.getImageFileId());
        Assertions.assertEquals((Object)application.getDescription(), (Object)storedApplication.getDescription());
        Assertions.assertEquals((Object)application.isActive(), (Object)storedApplication.isActive());
        Assertions.assertEquals((Object)application.isMandatory(), (Object)storedApplication.isMandatory());
        Assertions.assertEquals((Object)application.getPermissions(), (Object)storedApplication.getPermissions());
    }

    @Test
    void testGetApplicationByTitleOrURL() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.applicationCenterStorage.getApplicationByTitle(null));
        Assertions.assertNull((Object)this.applicationCenterStorage.getApplicationByTitle(TITLE));
        Mockito.when((Object)this.applicationDAO.getApplicationByTitle(TITLE)).thenReturn((Object)this.applicationEntity(ID));
        Application storedApplication = this.applicationCenterStorage.getApplicationByTitle(TITLE);
        Assertions.assertNotNull((Object)storedApplication);
    }

    @Test
    void testAddApplicationToUserFavorite() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.applicationCenterStorage.addApplicationToUserFavorite(0L, TEST_USER));
        Assertions.assertThrows(ApplicationNotFoundException.class, () -> this.applicationCenterStorage.addApplicationToUserFavorite(50000L, TEST_USER));
        Application application = new Application(null, TITLE, URL, "", Long.valueOf(0L), Long.valueOf(0L), null, null, DESCRIPTION, false, true, false, false, false, new String[]{PERMISSIONS_1, PERMISSIONS_2});
        Application storedApplication = this.applicationCenterStorage.createApplication(application);
        this.applicationCenterStorage.addApplicationToUserFavorite(storedApplication.getId().longValue(), TEST_USER);
    }

    @Test
    void testUpdateApplicationFavoriteOrder() {
        FavoriteApplicationEntity favoriteApplicationEntity = (FavoriteApplicationEntity)Mockito.mock(FavoriteApplicationEntity.class);
        Mockito.when((Object)this.favoriteApplicationDAO.getFavoriteAppByUserNameAndAppId(ID, TEST_USER)).thenReturn((Object)favoriteApplicationEntity);
        this.applicationCenterStorage.updateFavoriteApplicationOrder(ID.longValue(), TEST_USER, Long.valueOf(1L));
        ((FavoriteApplicationDAO)Mockito.verify((Object)this.favoriteApplicationDAO)).save((Object)favoriteApplicationEntity);
        this.applicationCenterStorage.updateFavoriteApplicationOrder(ID.longValue(), TEST_USER, Long.valueOf(1L));
        ((FavoriteApplicationDAO)Mockito.verify((Object)this.favoriteApplicationDAO, (VerificationMode)Mockito.times((int)2))).save((Object)favoriteApplicationEntity);
    }

    @Test
    void testDeleteApplicationFavorite() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.applicationCenterStorage.deleteApplicationFavorite(Long.valueOf(0L), TEST_USER));
        this.applicationCenterStorage.deleteApplicationFavorite(Long.valueOf(50000L), TEST_USER);
        Application application = new Application(null, TITLE, URL, "", Long.valueOf(0L), Long.valueOf(0L), null, null, DESCRIPTION, false, true, false, false, false, new String[]{PERMISSIONS_1, PERMISSIONS_2});
        Application storedApplication = this.applicationCenterStorage.createApplication(application);
        this.applicationCenterStorage.addApplicationToUserFavorite(storedApplication.getId().longValue(), TEST_USER);
        this.applicationCenterStorage.deleteApplicationFavorite(storedApplication.getId(), TEST_USER);
    }

    @Test
    void testGetFavoriteApplicationsByUser() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.applicationCenterStorage.getFavoriteApplicationsByUser(null));
        List favoriteApplications = this.applicationCenterStorage.getFavoriteApplicationsByUser(TEST_USER);
        Assertions.assertNotNull((Object)favoriteApplications);
        Assertions.assertEquals((int)0, (int)favoriteApplications.size());
        FavoriteApplicationEntity favoriteApplicationEntity = (FavoriteApplicationEntity)Mockito.mock(FavoriteApplicationEntity.class);
        ApplicationEntity applicationEntity = (ApplicationEntity)Mockito.mock(ApplicationEntity.class);
        Mockito.when((Object)this.favoriteApplicationDAO.getFavoriteAppsByUser(TEST_USER)).thenReturn(Collections.singletonList(favoriteApplicationEntity));
        Mockito.when((Object)favoriteApplicationEntity.getApplication()).thenReturn((Object)applicationEntity);
        Mockito.when((Object)applicationEntity.isActive()).thenReturn((Object)true);
        Assertions.assertEquals((int)1, (int)this.applicationCenterStorage.getFavoriteApplicationsByUser(TEST_USER).size());
        Mockito.when((Object)applicationEntity.isMandatory()).thenReturn((Object)true);
        Assertions.assertEquals((int)1, (int)this.applicationCenterStorage.getFavoriteApplicationsByUser(TEST_USER).size());
        Mockito.when((Object)applicationEntity.isActive()).thenReturn((Object)false);
        Assertions.assertEquals((int)0, (int)this.applicationCenterStorage.getFavoriteApplicationsByUser(TEST_USER).size());
    }

    @Test
    void testGetMandatoryApplicationsByUser() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.applicationCenterStorage.getFavoriteApplicationsByUser(null));
        List mandatoryApplications = this.applicationCenterStorage.getMandatoryApplications();
        Assertions.assertNotNull((Object)mandatoryApplications);
        Assertions.assertEquals((int)0, (int)mandatoryApplications.size());
        Mockito.when((Object)this.applicationDAO.getMandatoryActiveApps()).thenReturn(Collections.singletonList(this.applicationEntity()));
        Assertions.assertEquals((int)1, (int)this.applicationCenterStorage.getMandatoryApplications().size());
    }

    @Test
    void testGetApplications() {
        List applications = this.applicationCenterStorage.getApplications(null);
        Assertions.assertNotNull((Object)applications);
        Assertions.assertEquals((int)0, (int)applications.size());
        applications = this.applicationCenterStorage.getApplications(TITLE);
        Assertions.assertNotNull((Object)applications);
        Assertions.assertEquals((int)0, (int)applications.size());
        Mockito.when((Object)this.applicationDAO.findAll()).thenReturn(Arrays.asList(this.applicationEntity(3L), this.applicationEntity(2L), this.applicationEntity(5L)));
        Mockito.when((Object)this.applicationDAO.getApplications(TITLE)).thenReturn(Arrays.asList(this.applicationEntity(3L), this.applicationEntity(5L)));
        Mockito.when((Object)this.applicationDAO.getApplications(URL)).thenReturn(Arrays.asList(this.applicationEntity(3L)));
        applications = this.applicationCenterStorage.getApplications(null);
        Assertions.assertNotNull((Object)applications);
        Assertions.assertEquals((int)3, (int)applications.size());
        applications = this.applicationCenterStorage.getApplications(TITLE);
        Assertions.assertNotNull((Object)applications);
        Assertions.assertEquals((int)2, (int)applications.size());
        applications = this.applicationCenterStorage.getApplications(URL);
        Assertions.assertNotNull((Object)applications);
        Assertions.assertEquals((int)1, (int)applications.size());
    }

    @Test
    void testCountApplications() {
        Assertions.assertEquals((long)0L, (long)this.applicationCenterStorage.countApplications());
        Mockito.when((Object)this.applicationDAO.count()).thenReturn((Object)1L);
        Assertions.assertEquals((long)1L, (long)this.applicationCenterStorage.countApplications());
    }

    @Test
    void testIsFavoriteApplication() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.applicationCenterStorage.isFavoriteApplication(null, null));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.applicationCenterStorage.isFavoriteApplication(null, TEST_USER));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.applicationCenterStorage.isFavoriteApplication(Long.valueOf(0L), TEST_USER));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.applicationCenterStorage.isFavoriteApplication(Long.valueOf(1L), null));
        Mockito.when((Object)this.favoriteApplicationDAO.getFavoriteAppByUserNameAndAppId(ID, TEST_USER)).thenReturn((Object)((FavoriteApplicationEntity)Mockito.mock(FavoriteApplicationEntity.class)));
        Assertions.assertFalse((boolean)this.applicationCenterStorage.isFavoriteApplication(Long.valueOf(1L), TEST_USER));
        Assertions.assertTrue((boolean)this.applicationCenterStorage.isFavoriteApplication(ID, TEST_USER));
    }

    @Test
    void testCountFavorites() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.applicationCenterStorage.countFavorites(null));
        Assertions.assertEquals((long)0L, (long)this.applicationCenterStorage.countFavorites(TEST_USER));
        Mockito.when((Object)this.favoriteApplicationDAO.countFavoritesForUser(TEST_USER)).thenReturn((Object)1L);
        Assertions.assertEquals((long)1L, (long)this.applicationCenterStorage.countFavorites(TEST_USER));
    }

    @Test
    void testCreateAppImageFileItem() {
        Assertions.assertNull((Object)this.applicationCenterStorage.createAppImageFileItem(null, null));
        Assertions.assertNull((Object)this.applicationCenterStorage.createAppImageFileItem("name", null));
        Assertions.assertNull((Object)this.applicationCenterStorage.createAppImageFileItem(null, FILE_CONTENT));
        ApplicationImage applicationImage = this.applicationCenterStorage.createAppImageFileItem("name", FILE_CONTENT);
        Assertions.assertNotNull((Object)applicationImage);
        Assertions.assertNotNull((Object)applicationImage.getFileName());
        Assertions.assertNotNull((Object)applicationImage.getFileBody());
    }

    @Test
    void testGetAppImageFile() {
        ApplicationImage applicationImage = this.applicationCenterStorage.createAppImageFileItem("name", FILE_CONTENT);
        Assertions.assertNotNull((Object)applicationImage);
        applicationImage = this.applicationCenterStorage.getAppImageFile(ID);
        Assertions.assertNull((Object)applicationImage);
        FileItem fileItem = (FileItem)Mockito.mock(FileItem.class);
        FileInfo fileInfo = (FileInfo)Mockito.mock(FileInfo.class);
        Mockito.when((Object)fileItem.getAsByte()).thenReturn((Object)FILE_CONTENT.getBytes());
        Mockito.when((Object)fileItem.getFileInfo()).thenReturn((Object)fileInfo);
        Mockito.when((Object)fileInfo.getName()).thenReturn((Object)"filename");
        Mockito.when((Object)this.fileService.getFile(5L)).thenReturn((Object)fileItem);
        applicationImage = this.applicationCenterStorage.getAppImageFile(Long.valueOf(5L));
        Assertions.assertNotNull((Object)applicationImage);
        Assertions.assertNotNull((Object)applicationImage.getFileName());
        Assertions.assertNotNull((Object)applicationImage.getFileBody());
    }

    private ApplicationEntity applicationEntity() {
        return this.applicationEntity(null);
    }

    private ApplicationEntity applicationEntity(Long id) {
        return new ApplicationEntity(id, "title1", "url1", "helpPageUrl1", Long.valueOf(6L), "description1", true, false, false, false, PERMISSIONS_2, false, null);
    }

    private Application application(Long id) {
        return new Application(id, "titre", URL, HELP_PAGE_URL, Long.valueOf(5L), Long.valueOf(588L), "", "", DESCRIPTION, false, true, false, true, false, new String[]{PERMISSIONS_1});
    }
}

