/*
 * Decompiled with CFR 0.152.
 */
package com.deepl.api.http;

import com.deepl.api.DeepLException;
import com.deepl.api.utils.KeyValuePair;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import org.jetbrains.annotations.Nullable;

public class HttpContent {
    private static final String LINE_BREAK = "\r\n";
    private final String contentType;
    private final byte[] content;

    private HttpContent(String contentType, byte[] content) {
        this.contentType = contentType;
        this.content = content;
    }

    public byte[] getContent() {
        return this.content;
    }

    public String getContentType() {
        return this.contentType;
    }

    public static HttpContent buildFormURLEncodedContent(@Nullable Iterable<KeyValuePair<String, String>> params) throws DeepLException {
        StringBuilder sb = new StringBuilder();
        if (params != null) {
            for (KeyValuePair<String, String> pair : params) {
                if (sb.length() != 0) {
                    sb.append("&");
                }
                sb.append(HttpContent.urlEncode((String)pair.getKey()));
                sb.append("=");
                sb.append(HttpContent.urlEncode((String)pair.getValue()));
            }
        }
        return new HttpContent("application/x-www-form-urlencoded", sb.toString().getBytes(StandardCharsets.UTF_8));
    }

    private static String urlEncode(String value) throws DeepLException {
        try {
            return URLEncoder.encode(value, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException exception) {
            throw new DeepLException("Error while URL-encoding request", exception);
        }
    }

    public static HttpContent buildMultipartFormDataContent(Iterable<KeyValuePair<String, Object>> params) throws Exception {
        String boundary = UUID.randomUUID().toString();
        return HttpContent.buildMultipartFormDataContent(params, boundary);
    }

    /*
     * Exception decompiling
     */
    private static HttpContent buildMultipartFormDataContent(Iterable<KeyValuePair<String, Object>> params, String boundary) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

