/*
 * Decompiled with CFR 0.152.
 */
package com.deepl.api;

import com.deepl.api.AppInfo;
import java.net.Proxy;
import java.time.Duration;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class TranslatorOptions {
    private int maxRetries = 5;
    private Duration timeout = Duration.ofSeconds(10L);
    @Nullable
    private Proxy proxy = null;
    @Nullable
    private Map<String, String> headers = null;
    @Nullable
    private String serverUrl = null;
    private boolean sendPlatformInfo = true;
    @Nullable
    private AppInfo appInfo = null;

    public TranslatorOptions setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
        return this;
    }

    public TranslatorOptions setTimeout(Duration timeout) {
        this.timeout = timeout;
        return this;
    }

    public TranslatorOptions setProxy(Proxy proxy) {
        this.proxy = proxy;
        return this;
    }

    public TranslatorOptions setHeaders(Map<String, String> headers) {
        this.headers = headers;
        return this;
    }

    public TranslatorOptions setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
        return this;
    }

    public TranslatorOptions setSendPlatformInfo(boolean sendPlatformInfo) {
        this.sendPlatformInfo = sendPlatformInfo;
        return this;
    }

    public TranslatorOptions setAppInfo(String appName, String appVersion) {
        this.appInfo = new AppInfo(appName, appVersion);
        return this;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    @Nullable
    public Proxy getProxy() {
        return this.proxy;
    }

    @Nullable
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Nullable
    public String getServerUrl() {
        return this.serverUrl;
    }

    public boolean getSendPlatformInfo() {
        return this.sendPlatformInfo;
    }

    @Nullable
    public AppInfo getAppInfo() {
        return this.appInfo;
    }
}

