/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.automatic.translation.rest;

import java.util.Locale;
import javax.ws.rs.core.Response;
import org.exoplatform.automatic.translation.api.AutomaticTranslationService;
import org.exoplatform.automatic.translation.api.dto.AutomaticTranslationFeaturesOptions;
import org.exoplatform.automatic.translation.rest.AutomaticTranslationRestService;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;

public class AutomaticTranslationRestServiceTest {
    AutomaticTranslationRestService automaticTranslationRestService;
    @Mock
    AutomaticTranslationService automaticTranslationService;
    @Mock
    SettingService settingService;

    @Before
    public void setUp() {
        this.automaticTranslationService = (AutomaticTranslationService)Mockito.mock(AutomaticTranslationService.class);
        this.settingService = (SettingService)Mockito.mock(SettingService.class);
        this.automaticTranslationRestService = new AutomaticTranslationRestService(this.automaticTranslationService);
    }

    private void startSessionAs(String username) {
        Identity identity = new Identity(username);
        ConversationState state = new ConversationState(identity);
        ConversationState.setCurrent((ConversationState)state);
    }

    @Test
    public void testSetActiveConnectorWhenOk() {
        ((AutomaticTranslationService)Mockito.doNothing().when((Object)this.automaticTranslationService)).setActiveConnector((String)ArgumentMatchers.any());
        Response response = this.automaticTranslationRestService.setActiveConnector("google");
        Assert.assertEquals((long)204L, (long)response.getStatus());
    }

    @Test
    public void testSetActiveConnectorWhenKo() {
        ((AutomaticTranslationService)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("Error")}).when((Object)this.automaticTranslationService)).setActiveConnector((String)ArgumentMatchers.any());
        Response response = this.automaticTranslationRestService.setActiveConnector("google");
        Assert.assertEquals((long)400L, (long)response.getStatus());
    }

    @Test
    public void testSetApiKeyWhenOk() {
        ((AutomaticTranslationService)Mockito.doNothing().when((Object)this.automaticTranslationService)).setApiKey((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
        Response response = this.automaticTranslationRestService.setApiKey("google", "123456");
        Assert.assertEquals((long)204L, (long)response.getStatus());
    }

    @Test
    public void testSetApiKeyWhenKo() {
        ((AutomaticTranslationService)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("Error")}).when((Object)this.automaticTranslationService)).setApiKey((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
        Response response = this.automaticTranslationRestService.setApiKey("google", "123456");
        Assert.assertEquals((long)400L, (long)response.getStatus());
    }

    @Test
    public void testSetFeatureOptionsWhenOk() {
        ((AutomaticTranslationService)Mockito.doNothing().when((Object)this.automaticTranslationService)).setFeaturesOptions((AutomaticTranslationFeaturesOptions)ArgumentMatchers.any());
        Response response = this.automaticTranslationRestService.setFeatureOptions(new AutomaticTranslationFeaturesOptions());
        Assert.assertEquals((long)204L, (long)response.getStatus());
    }

    @Test
    public void testSetFeatureOptionsWhenKo() {
        ((AutomaticTranslationService)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("Error")}).when((Object)this.automaticTranslationService)).setFeaturesOptions((AutomaticTranslationFeaturesOptions)ArgumentMatchers.any());
        Response response = this.automaticTranslationRestService.setFeatureOptions(new AutomaticTranslationFeaturesOptions());
        Assert.assertEquals((long)400L, (long)response.getStatus());
    }

    @Test
    public void testGetFeatureOptions() {
        Mockito.when((Object)this.automaticTranslationService.getFeaturesOptions()).thenReturn((Object)new AutomaticTranslationFeaturesOptions());
        Response response = this.automaticTranslationRestService.getFeaturesOptions();
        Assert.assertEquals((long)200L, (long)response.getStatus());
        AutomaticTranslationFeaturesOptions featuresOptions = (AutomaticTranslationFeaturesOptions)response.getEntity();
        Assert.assertTrue((boolean)featuresOptions.getNewsTranslateView());
        Assert.assertTrue((boolean)featuresOptions.getNotesTranslateEdition());
        Assert.assertTrue((boolean)featuresOptions.getNotesTranslateView());
        Assert.assertTrue((boolean)featuresOptions.getStreamTranslateShort());
        Assert.assertTrue((boolean)featuresOptions.getStreamTranslateComment());
    }

    @Test
    public void testTranslateWhenOk() {
        Mockito.when((Object)this.automaticTranslationService.translate((String)ArgumentMatchers.any(), (Locale)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), ArgumentMatchers.anyLong())).thenReturn((Object)"translated message !");
        Response response = this.automaticTranslationRestService.translate("google", "123456", "test/html", 1L);
        Assert.assertEquals((long)200L, (long)response.getStatus());
    }

    @Test
    public void testTranslateWhenKo() {
        Mockito.when((Object)this.automaticTranslationService.translate((String)ArgumentMatchers.any(), (Locale)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), ArgumentMatchers.anyLong())).thenReturn(null);
        Response response = this.automaticTranslationRestService.translate("google", "AR", "text/html", 1L);
        Assert.assertEquals((long)400L, (long)response.getStatus());
    }
}

