/*
 * Decompiled with CFR 0.152.
 */
package org.benjp.portlet.chat;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.portlet.PortletPreferences;
import juzu.Path;
import juzu.Resource;
import juzu.Response;
import juzu.SessionScoped;
import juzu.View;
import juzu.plugin.ajax.Ajax;
import juzu.request.RenderContext;
import juzu.template.Template;
import org.benjp.listener.ServerBootstrap;
import org.benjp.model.SpaceBean;
import org.benjp.services.UserService;
import org.benjp.utils.PropertyManager;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

@SessionScoped
public class ChatApplication {
    @Inject
    @Path(value="index.gtmpl")
    Template index;
    String token_ = "---";
    String remoteUser_ = null;
    String fullname_ = null;
    boolean isAdmin_ = false;
    boolean profileInitialized_ = false;
    Logger log = Logger.getLogger("ChatApplication");
    OrganizationService organizationService_;
    SpaceService spaceService_;
    @Inject
    Provider<PortletPreferences> providerPreferences;

    @Inject
    public ChatApplication(OrganizationService organizationService, SpaceService spaceService) {
        this.organizationService_ = organizationService;
        this.spaceService_ = spaceService;
    }

    @View
    public Response.Content index(RenderContext renderContext) {
        boolean isPublic;
        this.remoteUser_ = renderContext.getSecurityContext().getRemoteUser();
        boolean bl = isPublic = this.remoteUser_ == null;
        if (isPublic) {
            this.remoteUser_ = "__anonim_";
        }
        String chatServerURL = PropertyManager.getProperty((String)"chatServerUrl");
        String chatIntervalChat = PropertyManager.getProperty((String)"chatIntervalChat");
        String chatIntervalSession = PropertyManager.getProperty((String)"chatIntervalSession");
        String chatIntervalStatus = PropertyManager.getProperty((String)"chatIntervalStatus");
        String chatIntervalUsers = PropertyManager.getProperty((String)"chatIntervalUsers");
        String chatWeemoKey = PropertyManager.getProperty((String)"weemoKey");
        String publicModeEnabled = PropertyManager.getProperty((String)"publicMode");
        String fullname = this.fullname_ == null ? this.remoteUser_ : this.fullname_;
        PortletPreferences portletPreferences = (PortletPreferences)this.providerPreferences.get();
        String view = portletPreferences.getValue("view", "responsive");
        if (!("normal".equals(view) || "responsive".equals(view) || "public".equals(view))) {
            view = "responsive";
        }
        String fullscreen = portletPreferences.getValue("fullscreen", "false");
        return this.index.with().set("user", (Object)this.remoteUser_).set("room", (Object)"noroom").set("token", (Object)this.token_).set("chatServerURL", (Object)chatServerURL).set("fullname", (Object)fullname).set("chatIntervalChat", (Object)chatIntervalChat).set("chatIntervalSession", (Object)chatIntervalSession).set("chatIntervalStatus", (Object)chatIntervalStatus).set("chatIntervalUsers", (Object)chatIntervalUsers).set("publicMode", (Object)isPublic).set("publicModeEnabled", (Object)publicModeEnabled).set("view", (Object)view).set("fullscreen", (Object)fullscreen).set("weemoKey", (Object)chatWeemoKey).ok().withMetaTag("viewport", "width=device-width, initial-scale=1.0").withStylesheets(new String[]{"chat-" + view});
    }

    @Ajax
    @Resource
    public Response.Content maintainSession() {
        return Response.ok((CharSequence)"OK").withMimeType("text/html; charset=UTF-8").withHeader("Cache-Control", new String[]{"no-cache"});
    }

    @Ajax
    @Resource
    public Response.Content initChatProfile() {
        String out = "{\"token\": \"" + this.token_ + "\", \"fullname\": \"" + this.fullname_ + "\", \"msg\": \"nothing to update\", \"isAdmin\": \"" + this.isAdmin_ + "\"}";
        if (!this.profileInitialized_ && !"__anonim_".equals(this.remoteUser_)) {
            try {
                this.token_ = ServerBootstrap.getTokenService().getToken(this.remoteUser_);
                this.addUser(this.remoteUser_, this.token_);
                this.saveFullNameAndEmail(this.remoteUser_);
                if ("true".equals(PropertyManager.getProperty((String)"publicMode"))) {
                    Collection ms = this.organizationService_.getMembershipHandler().findMembershipsByUserAndGroup(this.remoteUser_, PropertyManager.getProperty((String)"publicAdminGroup"));
                    boolean bl = this.isAdmin_ = ms != null && ms.size() > 0;
                }
                if (!"__anonim_".equals(this.remoteUser_)) {
                    this.fullname_ = ServerBootstrap.getUserService().getUserFullName(this.remoteUser_);
                    ServerBootstrap.getUserService().setAsAdmin(this.remoteUser_, this.isAdmin_);
                }
                out = "{\"token\": \"" + this.token_ + "\", \"fullname\": \"" + this.fullname_ + "\", \"msg\": \"updated\", \"isAdmin\": \"" + this.isAdmin_ + "\"}";
                this.profileInitialized_ = true;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.profileInitialized_ = false;
                return Response.notFound((CharSequence)"Error during init, try later");
            }
        }
        if (!"__anonim_".equals(this.remoteUser_)) {
            this.saveSpaces(this.remoteUser_);
        }
        return Response.ok((CharSequence)out).withMimeType("text/event-stream; charset=UTF-8").withHeader("Cache-Control", new String[]{"no-cache"});
    }

    @Ajax
    @Resource
    public Response.Content createDemoUser(String fullname, String email, String isPublic) {
        String username;
        String out = "created";
        boolean isPublicUser = "true".equals(isPublic);
        this.remoteUser_ = username = "__anonim_" + fullname.trim().toLowerCase().replace(" ", "-").replace(".", "-");
        this.token_ = ServerBootstrap.getTokenService().getToken(this.remoteUser_);
        this.addUser(this.remoteUser_, this.token_);
        UserService userService = ServerBootstrap.getUserService();
        userService.addUserFullName(username, fullname);
        userService.addUserEmail(username, email);
        userService.setAsAdmin(username, false);
        if (!isPublicUser) {
            this.saveDemoSpace(username);
        }
        StringBuffer json = new StringBuffer();
        json.append("{ \"username\": \"").append(this.remoteUser_).append("\"");
        json.append(", \"token\": \"").append(this.token_).append("\" }");
        return Response.ok((CharSequence)json).withMimeType("text/html; charset=UTF-8").withHeader("Cache-Control", new String[]{"no-cache"});
    }

    protected void addUser(String remoteUser, String token) {
        ServerBootstrap.getTokenService().addUser(remoteUser, token);
    }

    protected String saveFullNameAndEmail(String username) {
        String fullname = username;
        try {
            User user;
            fullname = ServerBootstrap.getUserService().getUserFullName(username);
            if (fullname == null && (user = this.organizationService_.getUserHandler().findUserByName(username)) != null) {
                fullname = user.getFirstName() + " " + user.getLastName();
                ServerBootstrap.getUserService().addUserFullName(username, fullname);
                ServerBootstrap.getUserService().addUserEmail(username, user.getEmail());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fullname;
    }

    protected void setAsAdmin(String username, boolean isAdmin) {
        try {
            ServerBootstrap.getUserService().setAsAdmin(username, isAdmin);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void saveSpaces(String username) {
        try {
            ListAccess spacesListAccess = this.spaceService_.getAccessibleSpacesWithListAccess(username);
            List<Object> spaces = Arrays.asList(spacesListAccess.load(0, spacesListAccess.getSize()));
            ArrayList<SpaceBean> beans = new ArrayList<SpaceBean>();
            for (Space space : spaces) {
                SpaceBean spaceBean = new SpaceBean();
                spaceBean.setDisplayName(space.getDisplayName());
                spaceBean.setGroupId(space.getGroupId());
                spaceBean.setId(space.getId());
                spaceBean.setShortName(space.getShortName());
                beans.add(spaceBean);
            }
            ServerBootstrap.getUserService().setSpaces(username, beans);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void saveDemoSpace(String username) {
        try {
            ArrayList<SpaceBean> beans = new ArrayList<SpaceBean>();
            SpaceBean spaceBean = new SpaceBean();
            spaceBean.setDisplayName("Welcome Space");
            spaceBean.setGroupId("/public");
            spaceBean.setId("welcome_space");
            spaceBean.setShortName("welcome_space");
            beans.add(spaceBean);
            ServerBootstrap.getUserService().setSpaces(username, beans);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

