/*
 * Decompiled with CFR 0.152.
 */
package org.benjp.portlet.chat;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.portlet.PortletPreferences;
import juzu.Path;
import juzu.Resource;
import juzu.Response;
import juzu.SessionScoped;
import juzu.View;
import juzu.plugin.ajax.Ajax;
import juzu.request.RenderContext;
import juzu.request.ResourceContext;
import juzu.template.Template;
import org.apache.commons.fileupload.FileItem;
import org.benjp.bean.File;
import org.benjp.listener.ServerBootstrap;
import org.benjp.model.SpaceBean;
import org.benjp.model.SpaceBeans;
import org.benjp.portlet.chat.CalendarService;
import org.benjp.portlet.chat.DocumentsData;
import org.benjp.portlet.chat.WikiService;
import org.benjp.utils.PropertyManager;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

@SessionScoped
public class ChatApplication {
    @Inject
    @Path(value="index.gtmpl")
    Template index;
    String token_ = "---";
    String remoteUser_ = null;
    String fullname_ = null;
    boolean isAdmin_ = false;
    Boolean isTeamAdmin_ = null;
    boolean profileInitialized_ = false;
    Logger log = Logger.getLogger("ChatApplication");
    OrganizationService organizationService_;
    SpaceService spaceService_;
    @Inject
    Provider<PortletPreferences> providerPreferences;
    @Inject
    DocumentsData documentsData_;
    @Inject
    CalendarService calendarService_;
    @Inject
    WikiService wikiService_;

    @Inject
    public ChatApplication(OrganizationService organizationService, SpaceService spaceService) {
        this.organizationService_ = organizationService;
        this.spaceService_ = spaceService;
    }

    @View
    public Response.Content index(RenderContext renderContext) {
        boolean isPublic;
        this.remoteUser_ = renderContext.getSecurityContext().getRemoteUser();
        boolean bl = isPublic = this.remoteUser_ == null;
        if (isPublic) {
            this.remoteUser_ = "__anonim_";
        }
        String chatServerURL = PropertyManager.getProperty((String)"chatServerUrl");
        String chatIntervalChat = PropertyManager.getProperty((String)"chatIntervalChat");
        String chatIntervalSession = PropertyManager.getProperty((String)"chatIntervalSession");
        String chatIntervalStatus = PropertyManager.getProperty((String)"chatIntervalStatus");
        String chatIntervalUsers = PropertyManager.getProperty((String)"chatIntervalUsers");
        String chatWeemoKey = PropertyManager.getProperty((String)"weemoKey");
        String publicModeEnabled = PropertyManager.getProperty((String)"publicMode");
        String servicesImplementation = PropertyManager.getProperty((String)"servicesImplementation");
        String dbServerMode = PropertyManager.getProperty((String)"dbServerType");
        String demoMode = "embed".equals(dbServerMode) || "jcr".equals(servicesImplementation) ? "DEV" : "PROD";
        String fullname = this.fullname_ == null ? this.remoteUser_ : this.fullname_;
        PortletPreferences portletPreferences = (PortletPreferences)this.providerPreferences.get();
        String view = portletPreferences.getValue("view", "responsive");
        if (!("normal".equals(view) || "responsive".equals(view) || "public".equals(view))) {
            view = "responsive";
        }
        String fullscreen = portletPreferences.getValue("fullscreen", "false");
        SimpleDateFormat df = new SimpleDateFormat("MM/dd/yyyy");
        Date today = Calendar.getInstance().getTime();
        String todayDate = df.format(today);
        return this.index.with().set("user", (Object)this.remoteUser_).set("room", (Object)"noroom").set("token", (Object)this.token_).set("chatServerURL", (Object)chatServerURL).set("fullname", (Object)fullname).set("chatIntervalChat", (Object)chatIntervalChat).set("chatIntervalSession", (Object)chatIntervalSession).set("chatIntervalStatus", (Object)chatIntervalStatus).set("chatIntervalUsers", (Object)chatIntervalUsers).set("publicMode", (Object)isPublic).set("publicModeEnabled", (Object)publicModeEnabled).set("view", (Object)view).set("fullscreen", (Object)fullscreen).set("weemoKey", (Object)chatWeemoKey).set("demoMode", (Object)demoMode).set("today", (Object)todayDate).ok().withMetaTag("viewport", "width=device-width, initial-scale=1.0").withStylesheets(new String[]{"chat-" + view});
    }

    @Ajax
    @Resource
    public Response.Content maintainSession() {
        return Response.ok((CharSequence)"OK").withMimeType("text/html; charset=UTF-8").withHeader("Cache-Control", new String[]{"no-cache"});
    }

    @Ajax
    @Resource
    public Response.Content initChatProfile() {
        String out = "{\"token\": \"" + this.token_ + "\", \"fullname\": \"" + this.fullname_ + "\", \"msg\": \"nothing to update\", \"isAdmin\": \"" + this.isAdmin_ + "\", \"isTeamAdmin\": \"" + this.isTeamAdmin_ + "\"}";
        if (!this.profileInitialized_ && !"__anonim_".equals(this.remoteUser_)) {
            try {
                Collection ms;
                this.token_ = ServerBootstrap.getToken((String)this.remoteUser_);
                this.addUser(this.remoteUser_, this.token_);
                this.saveFullNameAndEmail(this.remoteUser_);
                if ("true".equals(PropertyManager.getProperty((String)"publicMode"))) {
                    ms = this.organizationService_.getMembershipHandler().findMembershipsByUserAndGroup(this.remoteUser_, PropertyManager.getProperty((String)"publicAdminGroup"));
                    boolean bl = this.isAdmin_ = ms != null && ms.size() > 0;
                }
                if (this.isTeamAdmin_ == null) {
                    ms = this.organizationService_.getMembershipHandler().findMembershipsByUserAndGroup(this.remoteUser_, PropertyManager.getProperty((String)"teamAdminGroup"));
                    this.isTeamAdmin_ = ms != null && ms.size() > 0;
                }
                if (!"__anonim_".equals(this.remoteUser_)) {
                    this.fullname_ = ServerBootstrap.getUserFullName((String)this.remoteUser_);
                    ServerBootstrap.setAsAdmin((String)this.remoteUser_, (boolean)this.isAdmin_);
                }
                out = "{\"token\": \"" + this.token_ + "\", \"fullname\": \"" + this.fullname_ + "\", \"msg\": \"updated\", \"isAdmin\": \"" + this.isAdmin_ + "\", \"isTeamAdmin\": \"" + this.isTeamAdmin_ + "\"}";
                this.profileInitialized_ = true;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.profileInitialized_ = false;
                return Response.notFound((CharSequence)"Error during init, try later");
            }
        }
        if (!"__anonim_".equals(this.remoteUser_)) {
            this.saveSpaces(this.remoteUser_);
        }
        return Response.ok((CharSequence)out).withMimeType("text/event-stream; charset=UTF-8").withHeader("Cache-Control", new String[]{"no-cache"});
    }

    @Resource
    @Ajax
    public Response.Content upload(String room, String targetUser, String targetFullname, FileItem userfile, ResourceContext resourceContext) {
        String fieldName;
        this.log.info("file upload in " + room);
        if (userfile.isFormField() && "room".equals(fieldName = userfile.getFieldName())) {
            room = userfile.getString();
            this.log.info("room : " + room);
        }
        if (userfile.getFieldName().equals("userfile")) {
            String uuid = null;
            if (targetUser.startsWith("space-")) {
                uuid = this.documentsData_.storeFile(userfile, targetFullname, false);
            } else {
                this.remoteUser_ = resourceContext.getSecurityContext().getRemoteUser();
                uuid = this.documentsData_.storeFile(userfile, this.remoteUser_, true);
                this.documentsData_.setPermission(uuid, targetUser);
            }
            File file = this.documentsData_.getNode(uuid);
            this.log.info(file.toJSON());
            return Response.ok((CharSequence)file.toJSON()).withMimeType("application/json; charset=UTF-8").withHeader("Cache-Control", new String[]{"no-cache"});
        }
        return Response.ok((CharSequence)"{\"status\":\"File has not been uploaded !\"}").withMimeType("application/json; charset=UTF-8").withHeader("Cache-Control", new String[]{"no-cache"});
    }

    @Ajax
    @Resource
    public Response.Content createTask(String username, String dueDate, String task) {
        SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy HH:mm");
        Date today = new Date();
        today.setHours(0);
        today.setMinutes(0);
        try {
            this.calendarService_.saveTask(this.remoteUser_, username, task, today, sdf.parse(dueDate + " 23:59"));
        }
        catch (ParseException e) {
            this.log.info("parse exception during task creation");
            return Response.notFound((CharSequence)"Error during task creation");
        }
        catch (Exception e) {
            this.log.info("exception during task creation");
            return Response.notFound((CharSequence)"Error during task creation");
        }
        return Response.ok((CharSequence)"{\"status\":\"ok\"}").withMimeType("application/json; charset=UTF-8").withHeader("Cache-Control", new String[]{"no-cache"});
    }

    @Ajax
    @Resource
    public Response.Content createEvent(String space, String users, String summary, String startDate, String startTime, String endDate, String endTime) {
        SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy HH:mm");
        try {
            this.calendarService_.saveEvent(this.remoteUser_, space, users, summary, sdf.parse(startDate + " " + startTime), sdf.parse(endDate + " " + endTime));
        }
        catch (ParseException e) {
            this.log.info("parse exception during task creation");
            return Response.notFound((CharSequence)"Error during task creation");
        }
        catch (Exception e) {
            this.log.info("exception during task creation");
            return Response.notFound((CharSequence)"Error during task creation");
        }
        return Response.ok((CharSequence)"{\"status\":\"ok\"}").withMimeType("application/json; charset=UTF-8").withHeader("Cache-Control", new String[]{"no-cache"});
    }

    @Ajax
    @Resource
    public Response.Content saveWiki(String targetFullname, String content) {
        SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy HH-mm");
        String group = null;
        String title = null;
        String path = "";
        Space spaceBean = this.spaceService_.getSpaceByDisplayName(targetFullname);
        if (spaceBean != null) {
            group = spaceBean.getGroupId();
            if (group.startsWith("/")) {
                group = group.substring(1);
            }
            title = "Meeting " + sdf.format(new Date());
            path = this.wikiService_.createSpacePage(title, content, group);
        } else {
            title = targetFullname + " Meeting " + sdf.format(new Date());
            path = this.wikiService_.createIntranetPage(title, content);
        }
        path = ServerBootstrap.getServerBase() + path;
        return Response.ok((CharSequence)("{\"status\":\"ok\", \"path\":\"" + path + "\"}")).withMimeType("application/json; charset=UTF-8").withHeader("Cache-Control", new String[]{"no-cache"});
    }

    public Response.Content createDemoUser(String fullname, String email, String isPublic) {
        String username;
        String out = "created";
        boolean isPublicUser = "true".equals(isPublic);
        this.remoteUser_ = username = "__anonim_" + fullname.trim().toLowerCase().replace(" ", "-").replace(".", "-");
        this.token_ = ServerBootstrap.getToken((String)this.remoteUser_);
        this.addUser(this.remoteUser_, this.token_);
        ServerBootstrap.addUserFullNameAndEmail((String)username, (String)fullname, (String)email);
        ServerBootstrap.setAsAdmin((String)username, (boolean)false);
        if (!isPublicUser) {
            this.saveDemoSpace(username);
        }
        StringBuffer json = new StringBuffer();
        json.append("{ \"username\": \"").append(this.remoteUser_).append("\"");
        json.append(", \"token\": \"").append(this.token_).append("\" }");
        return Response.ok((CharSequence)json).withMimeType("text/html; charset=UTF-8").withHeader("Cache-Control", new String[]{"no-cache"});
    }

    protected void addUser(String remoteUser, String token) {
        ServerBootstrap.addUser((String)remoteUser, (String)token);
    }

    protected String saveFullNameAndEmail(String username) {
        String fullname = username;
        try {
            User user;
            fullname = ServerBootstrap.getUserFullName((String)username);
            if (fullname == null && (user = this.organizationService_.getUserHandler().findUserByName(username)) != null) {
                fullname = user.getFirstName() + " " + user.getLastName();
                ServerBootstrap.addUserFullNameAndEmail((String)username, (String)fullname, (String)user.getEmail());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fullname;
    }

    protected void setAsAdmin(String username, boolean isAdmin) {
        try {
            ServerBootstrap.setAsAdmin((String)username, (boolean)isAdmin);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void saveSpaces(String username) {
        try {
            ListAccess spacesListAccess = this.spaceService_.getAccessibleSpacesWithListAccess(username);
            List<Object> spaces = Arrays.asList(spacesListAccess.load(0, spacesListAccess.getSize()));
            ArrayList<SpaceBean> beans = new ArrayList<SpaceBean>();
            for (Space space : spaces) {
                SpaceBean spaceBean = new SpaceBean();
                spaceBean.setDisplayName(space.getDisplayName());
                spaceBean.setGroupId(space.getGroupId());
                spaceBean.setId(space.getId());
                spaceBean.setShortName(space.getShortName());
                beans.add(spaceBean);
            }
            ServerBootstrap.setSpaces((String)username, (SpaceBeans)new SpaceBeans(beans));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void saveDemoSpace(String username) {
        try {
            ArrayList<SpaceBean> beans = new ArrayList<SpaceBean>();
            SpaceBean spaceBean = new SpaceBean();
            spaceBean.setDisplayName("Welcome Space");
            spaceBean.setGroupId("/public");
            spaceBean.setId("welcome_space");
            spaceBean.setShortName("welcome_space");
            beans.add(spaceBean);
            ServerBootstrap.setSpaces((String)username, (SpaceBeans)new SpaceBeans(beans));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

