/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.chat.portlet.chat;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.services.jcr.access.PermissionType;
import org.exoplatform.wiki.mow.api.Page;
import org.exoplatform.wiki.mow.core.api.wiki.PageImpl;
import org.exoplatform.wiki.resolver.TitleResolver;
import org.xwiki.rendering.syntax.Syntax;

@Named(value="wikiService")
@ApplicationScoped
public class WikiService {
    org.exoplatform.wiki.service.WikiService wikiService_;
    private static final Logger LOG = Logger.getLogger("WikiService");
    public static final String ANY = "any".intern();

    @Inject
    public WikiService(org.exoplatform.wiki.service.WikiService wikiService) {
        this.wikiService_ = wikiService;
    }

    protected String createIntranetPage(String title, String content, ArrayList<String> users) {
        return this.createOrEditPage("Meeting Notes", title, content, users, false, null);
    }

    protected String createSpacePage(String title, String content, String spaceGroupId, ArrayList<String> users) {
        return this.createOrEditPage("Meeting Notes", title, content, users, false, spaceGroupId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createOrEditPage(String parentTitle, String title, String content, ArrayList<String> users, boolean forceNew, String spaceGroupId) {
        String wikiType = PortalConfig.PORTAL_TYPE;
        String wikiOwner = "intranet";
        String path = "";
        if (spaceGroupId != null) {
            wikiType = PortalConfig.GROUP_TYPE;
            wikiOwner = spaceGroupId;
        }
        try {
            org.exoplatform.wiki.service.WikiService wikiService = this.wikiService_;
            synchronized (wikiService) {
                PageImpl page;
                if (!this.wikiService_.isExisting(wikiType, wikiOwner, TitleResolver.getId((String)parentTitle, (boolean)false))) {
                    PageImpl ppage = (PageImpl)this.wikiService_.createPage(wikiType, wikiOwner, parentTitle, TitleResolver.getId((String)"Wiki Home", (boolean)false));
                    ppage.getContent().setText("= " + parentTitle + " =\n");
                    ppage.setSyntax(Syntax.XWIKI_2_0.toIdString());
                    ppage.checkin();
                    ppage.checkout();
                }
                boolean isPageExisted = false;
                if (this.wikiService_.isExisting(wikiType, wikiOwner, TitleResolver.getId((String)title, (boolean)false))) {
                    page = (PageImpl)this.wikiService_.getPageById(wikiType, wikiOwner, TitleResolver.getId((String)title, (boolean)false));
                    isPageExisted = true;
                } else {
                    try {
                        page = (PageImpl)this.wikiService_.createPage(wikiType, wikiOwner, title, TitleResolver.getId((String)parentTitle, (boolean)false));
                    }
                    catch (Exception e) {
                        isPageExisted = true;
                        page = (PageImpl)this.wikiService_.getPageById(wikiType, wikiOwner, TitleResolver.getId((String)title, (boolean)false));
                    }
                }
                page.getContent().setText(content);
                this.setPermissionForReportAsWiki(users, page);
                page.setSyntax(Syntax.XWIKI_2_0.toIdString());
                page.setMinorEdit(false);
                page.checkin();
                page.checkout();
                if (wikiType.equals(PortalConfig.GROUP_TYPE)) {
                    path = "/portal/intranet/wiki/" + wikiType + "/" + wikiOwner + "/" + page.getName();
                } else if (wikiType.equals(PortalConfig.PORTAL_TYPE)) {
                    path = "/portal/intranet/wiki/" + page.getName();
                }
                if (!isPageExisted) {
                    this.wikiService_.postAddPage(wikiType, wikiOwner, TitleResolver.getId((String)title, (boolean)false), (Page)page);
                }
            }
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Unknown exception", e);
        }
        return path;
    }

    public void setPermissionForReportAsWiki(List<String> users, PageImpl page) {
        try {
            HashMap permissions = page.getPermission();
            permissions.remove(ANY);
            for (int i = 0; i < users.size(); ++i) {
                permissions.put(users.get(i).toString(), PermissionType.ALL);
            }
            page.setPermission(permissions);
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Unknown exception", e);
        }
    }
}

