/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.chat.portlet.chat;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Named;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.servlet.http.HttpServletRequest;
import juzu.SessionScoped;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.chat.bean.File;
import org.exoplatform.chat.utils.ChatUtils;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.jcr.util.Text;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

/*
 * Exception performing whole class analysis ignored.
 */
@Named(value="documentsData")
@SessionScoped
public class DocumentsData {
    private static final Logger LOG = Logger.getLogger(DocumentsData.class.getName());
    RepositoryService repositoryService_;
    NodeHierarchyCreator nodeHierarchyCreator_;
    SessionProviderService sessionProviderService_;
    SpaceService spaceService_;
    ListenerService listenerService_;
    public static String FILE_CREATED_ACTIVITY = "ActivityNotify.event.FileCreated";
    public static final String TYPE_DOCUMENT = "Documents";

    @Inject
    public DocumentsData(RepositoryService repositoryService, SessionProviderService sessionProviderService, NodeHierarchyCreator nodeHierarchyCreator, SpaceService spaceService, ListenerService listenerService) {
        this.repositoryService_ = repositoryService;
        this.nodeHierarchyCreator_ = nodeHierarchyCreator;
        this.sessionProviderService_ = sessionProviderService;
        this.spaceService_ = spaceService;
        this.listenerService_ = listenerService;
    }

    public SessionProvider getUserSessionProvider() {
        SessionProvider sessionProvider = this.sessionProviderService_.getSessionProvider(null);
        return sessionProvider;
    }

    protected File getNode(String id) {
        SessionProvider sessionProvider = this.getUserSessionProvider();
        try {
            Session session = sessionProvider.getSession("collaboration", this.repositoryService_.getCurrentRepository());
            Node node = this.getNodeById(id, session);
            File file = this.getFileFromNode(node);
            return file;
        }
        catch (Exception e) {
            LOG.warning("JCR::\n" + e.getMessage());
            return null;
        }
    }

    private File getFileFromNode(Node node) throws Exception {
        File file = new File();
        file.setName(node.getName());
        if (node.hasProperty("exo:title")) {
            file.setTitle(Text.unescapeIllegalJcrChars((String)node.getProperty("exo:title").getString()));
        }
        if (node.isNodeType("mix:referenceable")) {
            file.setUuid(node.getUUID());
        }
        Calendar date = node.getProperty("exo:dateModified").getDate();
        file.setCreatedDate(date);
        Long size = new Long(0L);
        if (node.hasNode("jcr:content")) {
            Node contentNode = node.getNode("jcr:content");
            size = contentNode.getProperty("jcr:data").getLength();
        }
        file.setSizeLabel(DocumentsData.calculateFileSize((long)size));
        file.setSize(size);
        if (node.hasProperty("exo:lastModifier")) {
            String owner = node.getProperty("exo:lastModifier").getString();
            if ("__system".equals(owner)) {
                owner = "System";
            }
            file.setOwner(owner);
        }
        file.setPath(Text.escapePath((String)node.getPath()));
        HttpServletRequest request = Util.getPortalRequestContext().getRequest();
        String baseURI = request.getScheme() + "://" + request.getServerName() + ":" + String.format("%s", request.getServerPort());
        String url = baseURI + "/documents/file/" + Util.getPortalRequestContext().getRemoteUser() + "/" + file.getUuid() + "/" + Text.escape((String)file.getName());
        file.setPublicUrl(url);
        return file;
    }

    private Node getNodeById(String id, Session session) throws Exception {
        Node node = null;
        if (!id.contains("/")) {
            node = session.getNodeByUUID(id);
        } else {
            Node rootNode = session.getRootNode();
            String path = id.startsWith("/") ? id.substring(1) : id;
            node = rootNode.getNode(path);
        }
        return node;
    }

    protected void setPermission(String id, String targetUser) {
        if (StringUtils.isEmpty((CharSequence)targetUser)) {
            LOG.warning("No target User to set permission for " + id);
            return;
        }
        SessionProvider sessionProvider = this.getUserSessionProvider();
        Object uuid = null;
        try {
            Session session = sessionProvider.getSession("collaboration", this.repositoryService_.getCurrentRepository());
            ExtendedNode node = (ExtendedNode)this.getNodeById(id, session);
            if (node.canAddMixin("exo:privilegeable")) {
                String[] users;
                node.addMixin("exo:privilegeable");
                for (String user : users = targetUser.split(",")) {
                    node.setPermission(user, new String[]{"read"});
                }
                node.save();
            }
        }
        catch (Exception e) {
            LOG.warning(e.getMessage());
        }
    }

    protected String storeFile(FileItem item, String name, boolean isPrivateContext) {
        return this.storeFile(item, name, null, isPrivateContext);
    }

    protected String storeFile(FileItem item, String encodedFileName, String name, boolean isPrivateContext) {
        String filename = encodedFileName != null ? encodedFileName : item.getName();
        try {
            filename = URLDecoder.decode(filename, "utf-8");
        }
        catch (UnsupportedEncodingException e1) {
            // empty catch block
        }
        filename = Utils.cleanName((String)filename);
        String filenameExt = "";
        String filenameBase = filename;
        if (filename.lastIndexOf(".") > -1) {
            filenameExt = filename.substring(filename.lastIndexOf("."));
            filenameBase = filename.substring(0, filename.lastIndexOf("."));
        }
        String title = Text.escapeIllegalJcrChars((String)filename);
        String cleanedFilenameBase = ChatUtils.cleanString((String)filenameBase);
        String cleanedFilenameExt = ChatUtils.cleanString((String)filenameExt);
        String cleanedFilename = cleanedFilenameBase.concat(cleanedFilenameExt);
        SessionProvider sessionProvider = this.getUserSessionProvider();
        String uuid = null;
        try {
            Node homeNode;
            Session session = sessionProvider.getSession("collaboration", this.repositoryService_.getCurrentRepository());
            if (isPrivateContext) {
                Node userNode = this.nodeHierarchyCreator_.getUserNode(sessionProvider, name);
                homeNode = userNode.getNode("Private");
            } else {
                Node rootNode = session.getRootNode();
                homeNode = rootNode.getNode(this.getSpacePath(name));
            }
            Node docNode = homeNode.getNode("Documents");
            Node fileNode = null;
            int cpt = 1;
            boolean fileExist = false;
            do {
                try {
                    while (docNode.hasNode(cleanedFilename)) {
                        cleanedFilename = cleanedFilenameBase.concat("-").concat(String.valueOf(cpt)).concat(cleanedFilenameExt);
                        ++cpt;
                    }
                    fileNode = docNode.addNode(cleanedFilename, "nt:file");
                    if (!fileNode.hasProperty("exo:title")) {
                        fileNode.addMixin("exo:rss-enable");
                    }
                    fileNode.setProperty("exo:title", title);
                    Node jcrContent = fileNode.addNode("jcr:content", "nt:resource");
                    jcrContent.setProperty("jcr:data", item.getInputStream());
                    jcrContent.setProperty("jcr:lastModified", Calendar.getInstance());
                    jcrContent.setProperty("jcr:encoding", "UTF-8");
                    if (filename.toLowerCase().endsWith(".jpg")) {
                        jcrContent.setProperty("jcr:mimeType", "image/jpeg");
                    } else if (filename.toLowerCase().endsWith(".png")) {
                        jcrContent.setProperty("jcr:mimeType", "image/png");
                    } else if (filename.toLowerCase().endsWith(".pdf")) {
                        jcrContent.setProperty("jcr:mimeType", "application/pdf");
                    } else if (filename.toLowerCase().endsWith(".doc")) {
                        jcrContent.setProperty("jcr:mimeType", "application/vnd.ms-word");
                    } else if (filename.toLowerCase().endsWith(".xls")) {
                        jcrContent.setProperty("jcr:mimeType", "application/vnd.ms-excel");
                    } else if (filename.toLowerCase().endsWith(".ppt")) {
                        jcrContent.setProperty("jcr:mimeType", "application/vnd.ms-powerpoint");
                    } else if (filename.toLowerCase().endsWith(".docx")) {
                        jcrContent.setProperty("jcr:mimeType", "application/vnd.openxmlformats-officedocument.wordprocessingml.document");
                    } else if (filename.toLowerCase().endsWith(".xlsx")) {
                        jcrContent.setProperty("jcr:mimeType", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
                    } else if (filename.toLowerCase().endsWith(".pptx")) {
                        jcrContent.setProperty("jcr:mimeType", "application/vnd.openxmlformats-officedocument.presentationml.presentation");
                    } else if (filename.toLowerCase().endsWith(".odp")) {
                        jcrContent.setProperty("jcr:mimeType", "application/vnd.oasis.opendocument.presentation");
                    } else if (filename.toLowerCase().endsWith(".odt")) {
                        jcrContent.setProperty("jcr:mimeType", "application/vnd.oasis.opendocument.text");
                    } else if (filename.toLowerCase().endsWith(".ods")) {
                        jcrContent.setProperty("jcr:mimeType", "application/vnd.oasis.opendocument.spreadsheet");
                    } else if (filename.toLowerCase().endsWith(".zip")) {
                        jcrContent.setProperty("jcr:mimeType", "application/zip");
                    } else {
                        jcrContent.setProperty("jcr:mimeType", "application/octet-stream");
                    }
                    session.save();
                    fileExist = false;
                }
                catch (ItemExistsException e) {
                    fileExist = true;
                    docNode.refresh(false);
                    cleanedFilename = cleanedFilenameBase.concat("-").concat(String.valueOf(++cpt)).concat(".").concat(cleanedFilenameExt);
                }
            } while (fileExist);
            uuid = fileNode.getUUID();
            if (!isPrivateContext) {
                this.listenerService_.broadcast(FILE_CREATED_ACTIVITY, null, (Object)fileNode);
            }
        }
        catch (Exception e) {
            LOG.warning("JCR::" + e.getMessage());
        }
        return uuid;
    }

    private String getSpacePath(String spaceDisplayname) {
        Space spacet = this.spaceService_.getSpaceByDisplayName(spaceDisplayname);
        if (spacet == null) {
            LOG.warning("Cannot get the space of " + spaceDisplayname + ". Return null.");
            return null;
        }
        return "Groups".concat(spacet.getGroupId());
    }

    public static String calculateFileSize(long fileLengthLong) {
        int fileLengthDigitCount = Long.toString(fileLengthLong).length();
        double fileSizeKB = 0.0;
        String howBig = "";
        if (fileLengthDigitCount < 4) {
            fileSizeKB = fileLengthLong;
            howBig = "Byte(s)";
        } else if (fileLengthDigitCount >= 4 && fileLengthDigitCount <= 6) {
            fileSizeKB = new Double(fileLengthLong) / 1024.0;
            howBig = "KB";
        } else if (fileLengthDigitCount >= 7 && fileLengthDigitCount <= 9) {
            fileSizeKB = new Double(fileLengthLong) / 1048576.0;
            howBig = "MB";
        } else if (fileLengthDigitCount > 9) {
            fileSizeKB = new Double(fileLengthLong) / 1.073741824E9;
            howBig = "GB";
        }
        String finalResult = DocumentsData.roundTwoDecimals((double)fileSizeKB);
        return finalResult + " " + howBig;
    }

    private static String roundTwoDecimals(double d) {
        DecimalFormat twoDForm = new DecimalFormat("#.##");
        return twoDForm.format(d);
    }
}

