/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.chat.portlet.chat;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.wiki.mow.api.Page;
import org.exoplatform.wiki.mow.api.Permission;
import org.exoplatform.wiki.mow.api.PermissionEntry;
import org.exoplatform.wiki.mow.api.PermissionType;
import org.exoplatform.wiki.mow.api.Wiki;
import org.exoplatform.wiki.resolver.TitleResolver;
import org.exoplatform.wiki.service.IDType;
import org.xwiki.rendering.syntax.Syntax;

@Named(value="wikiService")
@ApplicationScoped
public class WikiService {
    org.exoplatform.wiki.service.WikiService wikiService_;
    private static final Logger LOG = Logger.getLogger("WikiService");
    public static final String ANY = "any".intern();

    @Inject
    public WikiService(org.exoplatform.wiki.service.WikiService wikiService) {
        this.wikiService_ = wikiService;
    }

    protected String createIntranetPage(String creator, String title, String content, ArrayList<String> users) {
        return this.createOrEditPage(creator, "Meeting Notes", title, content, users, false, null);
    }

    protected String createSpacePage(String creator, String title, String content, String spaceGroupId, ArrayList<String> users) {
        return this.createOrEditPage(creator, "Meeting Notes", title, content, users, false, spaceGroupId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createOrEditPage(String creator, String parentTitle, String title, String content, ArrayList<String> users, boolean forceNew, String spaceGroupId) {
        String wikiType = PortalConfig.PORTAL_TYPE;
        String wikiOwner = "intranet";
        String path = "";
        if (spaceGroupId != null) {
            wikiType = PortalConfig.GROUP_TYPE;
            wikiOwner = "/" + spaceGroupId;
        }
        try {
            org.exoplatform.wiki.service.WikiService wikiService = this.wikiService_;
            synchronized (wikiService) {
                Page ppage = this.wikiService_.getPageOfWikiByName(wikiType, wikiOwner, TitleResolver.getId((String)parentTitle, (boolean)false));
                if (ppage == null) {
                    ppage = new Page();
                    ppage.setTitle(parentTitle);
                    ppage.setContent("= " + parentTitle + " =\n");
                    ppage.setSyntax(Syntax.XWIKI_2_0.toIdString());
                    Wiki wiki = this.wikiService_.getWikiByTypeAndOwner(wikiType, wikiOwner);
                    if (wiki == null) {
                        wiki = this.wikiService_.createWiki(wikiType, wikiOwner);
                    }
                    Page wikiHome = wiki.getWikiHome();
                    this.setPermissionForReportAsWiki(Collections.EMPTY_LIST, ppage, wikiHome);
                    List permissions = ppage.getPermissions();
                    permissions.add(new PermissionEntry(ANY, "", IDType.USER, new Permission[]{new Permission(PermissionType.VIEWPAGE, true)}));
                    ppage.setPermissions(permissions);
                    Wiki pwiki = new Wiki();
                    pwiki.setOwner(wikiOwner);
                    pwiki.setType(wikiType);
                    ppage = this.wikiService_.createPage(pwiki, "WikiHome", ppage);
                    permissions = ppage.getPermissions();
                    for (int i = 0; i < permissions.size(); ++i) {
                        PermissionEntry permission = (PermissionEntry)permissions.get(i);
                        if (!creator.equals(permission.getId())) continue;
                        permissions.remove(i);
                    }
                    ppage.setPermissions(permissions);
                    this.wikiService_.updatePage(ppage, null);
                }
                Page page = new Page();
                page.setTitle(title);
                page.setContent(content);
                page.setSyntax(Syntax.XWIKI_2_0.toIdString());
                this.setPermissionForReportAsWiki(users, page, ppage);
                page.setOwner(creator);
                page.setAuthor(creator);
                page.setMinorEdit(false);
                if (wikiType.equals(PortalConfig.GROUP_TYPE)) {
                    path = "/portal/intranet/wiki/" + wikiType + wikiOwner + "/" + TitleResolver.getId((String)title, (boolean)false);
                } else if (wikiType.equals(PortalConfig.PORTAL_TYPE)) {
                    path = "/portal/intranet/wiki/" + TitleResolver.getId((String)title, (boolean)false);
                }
                page.setUrl(path);
                Wiki wiki = new Wiki();
                wiki.setOwner(wikiOwner);
                wiki.setType(wikiType);
                boolean isPageExisted = false;
                if (this.wikiService_.isExisting(wikiType, wikiOwner, TitleResolver.getId((String)title, (boolean)false))) {
                    this.wikiService_.getPageById(TitleResolver.getId((String)title, (boolean)false));
                    isPageExisted = true;
                } else {
                    try {
                        this.wikiService_.createPage(wiki, TitleResolver.getId((String)parentTitle, (boolean)false), page);
                    }
                    catch (Exception e) {
                        isPageExisted = true;
                        this.wikiService_.getPageById(TitleResolver.getId((String)title, (boolean)false));
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Unknown exception", e);
        }
        return path;
    }

    public void setPermissionForReportAsWiki(List<String> users, Page page, Page parentPage) {
        try {
            Permission[] allPermissions = new Permission[]{new Permission(PermissionType.VIEWPAGE, true), new Permission(PermissionType.EDITPAGE, true)};
            List permissions = parentPage.getPermissions();
            if (permissions != null) {
                int i;
                int anyIndex = -1;
                for (i = 0; i < permissions.size(); ++i) {
                    PermissionEntry any = (PermissionEntry)permissions.get(i);
                    if (!ANY.equals(any.getId())) continue;
                    anyIndex = i;
                }
                if (anyIndex > -1) {
                    permissions.remove(anyIndex);
                }
                for (i = 0; i < users.size(); ++i) {
                    String strUser = users.get(i).toString();
                    PermissionEntry userPermission = new PermissionEntry(strUser, strUser, IDType.USER, allPermissions);
                    permissions.add(userPermission);
                }
                page.setPermissions(permissions);
            }
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Unknown exception", e);
        }
    }
}

