/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.chat.portlet.chat;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.portlet.PortletPreferences;
import juzu.Path;
import juzu.Resource;
import juzu.Response;
import juzu.SessionScoped;
import juzu.View;
import juzu.impl.common.Tools;
import juzu.plugin.ajax.Ajax;
import juzu.request.ApplicationContext;
import juzu.request.RequestContext;
import juzu.request.RequestParameter;
import juzu.request.SecurityContext;
import juzu.request.UserContext;
import juzu.template.Template;
import org.apache.commons.fileupload.FileItem;
import org.exoplatform.chat.bean.File;
import org.exoplatform.chat.common.utils.ChatUtils;
import org.exoplatform.chat.listener.ServerBootstrap;
import org.exoplatform.chat.model.SpaceBean;
import org.exoplatform.chat.model.SpaceBeans;
import org.exoplatform.chat.portlet.chat.CalendarService;
import org.exoplatform.chat.portlet.chat.ChatApplication_;
import org.exoplatform.chat.portlet.chat.DocumentsData;
import org.exoplatform.chat.portlet.chat.WikiService;
import org.exoplatform.chat.utils.PropertyManager;
import org.exoplatform.commons.api.ui.ActionContext;
import org.exoplatform.commons.api.ui.PlugableUIService;
import org.exoplatform.commons.api.ui.RenderContext;
import org.exoplatform.commons.api.ui.Response;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

@SessionScoped
public class ChatApplication {
    @Inject
    @Path(value="index.gtmpl")
    Template index;
    String token_ = "---";
    String remoteUser_ = null;
    String fullname_ = null;
    boolean isAdmin_ = false;
    Boolean isTeamAdmin_ = null;
    boolean profileInitialized_ = false;
    private static final Logger LOG = Logger.getLogger("ChatApplication");
    OrganizationService organizationService_;
    SpaceService spaceService_;
    PlugableUIService uiService;
    String dbName;
    @Inject
    Provider<PortletPreferences> providerPreferences;
    @Inject
    DocumentsData documentsData_;
    @Inject
    CalendarService calendarService_;
    @Inject
    WikiService wikiService_;
    public static final String CHAT_EXTENSION_POPUP = "chat_extension_popup";
    public static final String CHAT_EXTENSION_MENU = "chat_extension_menu";
    private static final String EX_ACTION_NAME = "extension_action";

    @Inject
    public ChatApplication(OrganizationService organizationService, SpaceService spaceService, PlugableUIService uiService) {
        this.uiService = uiService;
        this.organizationService_ = organizationService;
        this.spaceService_ = spaceService;
        this.dbName = ChatUtils.getDBName();
    }

    @View
    public Response.Content index(ApplicationContext appContext, UserContext userContext, SecurityContext securityContext) {
        boolean isPublic;
        this.remoteUser_ = securityContext.getRemoteUser();
        boolean bl = isPublic = this.remoteUser_ == null;
        if (isPublic) {
            this.remoteUser_ = "__anonim_";
        }
        String chatServerURL = PropertyManager.getProperty((String)"chatServerUrl");
        String chatIntervalChat = PropertyManager.getProperty((String)"chatIntervalChat");
        String chatIntervalSession = PropertyManager.getProperty((String)"chatIntervalSession");
        String chatIntervalStatus = PropertyManager.getProperty((String)"chatIntervalStatus");
        String chatIntervalUsers = PropertyManager.getProperty((String)"chatIntervalUsers");
        String publicModeEnabled = PropertyManager.getProperty((String)"publicMode");
        String servicesImplementation = PropertyManager.getProperty((String)"servicesImplementation");
        String dbServerMode = PropertyManager.getProperty((String)"dbServerType");
        String demoMode = "embed".equals(dbServerMode) || "jcr".equals(servicesImplementation) ? "DEV" : "PROD";
        String plfUserStatusUpdateUrl = PropertyManager.getProperty((String)"plfUsrStatUpdUrl");
        String fullname = this.fullname_ == null || this.fullname_.isEmpty() ? this.remoteUser_ : this.fullname_;
        PortletPreferences portletPreferences = (PortletPreferences)this.providerPreferences.get();
        String view = portletPreferences.getValue("view", "responsive");
        if (!("normal".equals(view) || "responsive".equals(view) || "public".equals(view))) {
            view = "responsive";
        }
        String fullscreen = portletPreferences.getValue("fullscreen", "false");
        SimpleDateFormat df = new SimpleDateFormat("MM/dd/yyyy");
        Date today = Calendar.getInstance().getTime();
        String todayDate = df.format(today);
        Locale locale = userContext.getLocale();
        ResourceBundle bundle = appContext.resolveBundle(locale);
        RenderContext exMenuCtx = new RenderContext(CHAT_EXTENSION_MENU);
        exMenuCtx.setRsBundle(bundle);
        List menuResponse = this.uiService.render(exMenuCtx);
        RenderContext exPopupCtx = new RenderContext(CHAT_EXTENSION_POPUP);
        exPopupCtx.setActionUrl(ChatApplication_.processAction().toString());
        exPopupCtx.setRsBundle(bundle);
        List popupResponse = this.uiService.render(exPopupCtx);
        StringBuilder extMenu = new StringBuilder();
        StringBuilder extPopup = new StringBuilder();
        try {
            for (Response menu : menuResponse) {
                extMenu.append(new String(menu.getData(), "UTF-8"));
            }
            for (Response popup : popupResponse) {
                extPopup.append(new String(popup.getData(), "UTF-8"));
            }
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, ex.getMessage(), ex);
        }
        return this.index.with().set("user", (Object)this.remoteUser_).set("room", (Object)"noroom").set("token", (Object)this.token_).set("chatServerURL", (Object)chatServerURL).set("fullname", (Object)fullname).set("chatIntervalChat", (Object)chatIntervalChat).set("chatIntervalSession", (Object)chatIntervalSession).set("chatIntervalStatus", (Object)chatIntervalStatus).set("chatIntervalUsers", (Object)chatIntervalUsers).set("plfUserStatusUpdateUrl", (Object)plfUserStatusUpdateUrl).set("publicMode", (Object)isPublic).set("publicModeEnabled", (Object)publicModeEnabled).set("view", (Object)view).set("fullscreen", (Object)fullscreen).set("demoMode", (Object)demoMode).set("today", (Object)todayDate).set("dbName", (Object)this.dbName).set("extPopup", (Object)extPopup).set("extMenu", (Object)extMenu).ok().withMetaTag("viewport", "width=device-width, initial-scale=1.0").withAssets(new String[]{"chat-" + view}).withCharset(Tools.UTF_8);
    }

    @Ajax
    @Resource
    public Response.Content maintainSession() {
        return juzu.Response.ok((CharSequence)"OK").withMimeType("text/html; charset=UTF-8").withHeader("Cache-Control", new String[]{"no-cache"});
    }

    @Ajax
    @Resource
    public Response.Content initChatProfile() {
        if (!"__anonim_".equals(this.remoteUser_)) {
            this.fullname_ = ServerBootstrap.getUserFullName((String)this.remoteUser_, (String)this.dbName);
        }
        String out = "{\"token\": \"" + this.token_ + "\", \"fullname\": \"" + this.fullname_ + "\", \"msg\": \"nothing to update\", \"isAdmin\": \"" + this.isAdmin_ + "\", \"isTeamAdmin\": \"" + this.isTeamAdmin_ + "\"}";
        if (!this.profileInitialized_ && !"__anonim_".equals(this.remoteUser_)) {
            try {
                Collection ms;
                this.token_ = ServerBootstrap.getToken((String)this.remoteUser_);
                this.addUser(this.remoteUser_, this.token_, this.dbName);
                this.saveFullNameAndEmail(this.remoteUser_, this.dbName);
                if ("true".equals(PropertyManager.getProperty((String)"publicMode"))) {
                    ms = this.organizationService_.getMembershipHandler().findMembershipsByUserAndGroup(this.remoteUser_, PropertyManager.getProperty((String)"publicAdminGroup"));
                    boolean bl = this.isAdmin_ = ms != null && ms.size() > 0;
                }
                if (this.isTeamAdmin_ == null) {
                    ms = this.organizationService_.getMembershipHandler().findMembershipsByUserAndGroup(this.remoteUser_, PropertyManager.getProperty((String)"teamAdminGroup"));
                    this.isTeamAdmin_ = ms != null && ms.size() > 0;
                }
                if (!"__anonim_".equals(this.remoteUser_)) {
                    ServerBootstrap.setAsAdmin((String)this.remoteUser_, (boolean)this.isAdmin_, (String)this.dbName);
                }
                out = "{\"token\": \"" + this.token_ + "\", \"fullname\": \"" + this.fullname_ + "\", \"msg\": \"updated\", \"isAdmin\": \"" + this.isAdmin_ + "\", \"isTeamAdmin\": \"" + this.isTeamAdmin_ + "\"}";
                this.profileInitialized_ = true;
            }
            catch (Exception e) {
                LOG.warning(e.getMessage());
                this.profileInitialized_ = false;
                return juzu.Response.notFound((CharSequence)"Error during init, try later");
            }
        }
        if (!"__anonim_".equals(this.remoteUser_)) {
            this.saveSpaces(this.remoteUser_, this.dbName);
        }
        return juzu.Response.ok((CharSequence)out).withMimeType("text/event-stream; charset=UTF-8").withHeader("Cache-Control", new String[]{"no-cache"}).withCharset(Tools.UTF_8);
    }

    @Resource
    @Ajax
    public Response.Content upload(String room, String targetUser, String targetFullname, String encodedFileName, FileItem userfile, SecurityContext securityContext) {
        String fieldName;
        try {
            targetFullname = URLDecoder.decode(targetFullname, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        LOG.info("File is uploaded in " + room + " (" + targetFullname + ")");
        if (userfile.isFormField() && "room".equals(fieldName = userfile.getFieldName())) {
            room = userfile.getString();
            LOG.info("room : " + room);
        }
        if (userfile.getFieldName().equals("userfile")) {
            String uuid = null;
            if (targetUser.startsWith("space-")) {
                uuid = this.documentsData_.storeFile(userfile, encodedFileName, targetFullname, false);
            } else {
                this.remoteUser_ = securityContext.getRemoteUser();
                uuid = this.documentsData_.storeFile(userfile, encodedFileName, this.remoteUser_, true);
                this.documentsData_.setPermission(uuid, targetUser);
            }
            File file = this.documentsData_.getNode(uuid);
            LOG.info(file.toJSON());
            return juzu.Response.ok((CharSequence)file.toJSON()).withMimeType("application/json; charset=UTF-8").withHeader("Cache-Control", new String[]{"no-cache"}).withCharset(Tools.UTF_8);
        }
        return juzu.Response.ok((CharSequence)"{\"status\":\"File has not been uploaded !\"}").withMimeType("application/json; charset=UTF-8").withHeader("Cache-Control", new String[]{"no-cache"});
    }

    @Ajax
    @Resource
    public juzu.Response processAction(RequestContext reqContext) {
        Map params = reqContext.getParameters();
        HashMap<String, List<String>> p = new HashMap<String, List<String>>();
        for (String name : params.keySet()) {
            p.put(name, Arrays.asList(((RequestParameter)params.get(name)).toArray()));
        }
        String actionName = ((RequestParameter)params.get(EX_ACTION_NAME)).getValue();
        ActionContext actContext = new ActionContext(CHAT_EXTENSION_POPUP, actionName);
        actContext.setParams(p);
        Response response = this.uiService.processAction(actContext);
        if (response != null) {
            return juzu.Response.ok((CharSequence)new String(response.getData(), Charset.forName("UTF-8"))).withMimeType("application/json; charset=UTF-8").withHeader("Cache-Control", new String[]{"no-cache"});
        }
        return juzu.Response.status((int)404).withHeader("Cache-Control", new String[]{"no-cache"});
    }

    @Ajax
    @Resource
    public Response.Content createEvent(String space, String users, String summary, String startDate, String startTime, String endDate, String endTime, String location) {
        SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy hh:mm a");
        try {
            this.calendarService_.saveEvent(this.remoteUser_, space, users, summary, sdf.parse(startDate + " " + startTime), sdf.parse(endDate + " " + endTime), location);
        }
        catch (ParseException e) {
            LOG.warning("parse exception during event creation");
            return juzu.Response.notFound((CharSequence)"Error during event creation");
        }
        catch (Exception e) {
            LOG.warning("exception during event creation");
            return juzu.Response.notFound((CharSequence)"Error during event creation");
        }
        return juzu.Response.ok((CharSequence)"{\"status\":\"ok\"}").withMimeType("application/json; charset=UTF-8").withHeader("Cache-Control", new String[]{"no-cache"});
    }

    @Ajax
    @Resource
    public Response.Content saveWiki(String targetFullname, String content) {
        SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy HH-mm");
        String group = null;
        String title = null;
        String path = "";
        JSONObject jsonObject = (JSONObject)JSONValue.parse((String)content);
        String typeRoom = (String)jsonObject.get((Object)"typeRoom");
        String xwiki = (String)jsonObject.get((Object)"xwiki");
        xwiki = xwiki.replaceAll("~", "~~");
        xwiki = xwiki.replaceAll("&#38", "&");
        xwiki = xwiki.replaceAll("&lt;", "<");
        xwiki = xwiki.replaceAll("&gt;", ">");
        xwiki = xwiki.replaceAll("&quot;", "\"");
        xwiki = xwiki.replaceAll("<br/>", "\n");
        xwiki = xwiki.replaceAll("&#92", "\\\\");
        xwiki = xwiki.replaceAll("  ", "\t");
        ArrayList users = (ArrayList)jsonObject.get((Object)"users");
        if ("s".equalsIgnoreCase(typeRoom)) {
            Space spaceBean = this.spaceService_.getSpaceByDisplayName(targetFullname);
            if (spaceBean != null) {
                group = spaceBean.getGroupId();
                if (group.startsWith("/")) {
                    group = group.substring(1);
                }
                title = "Meeting " + sdf.format(new Date());
                path = this.wikiService_.createSpacePage(this.remoteUser_, title, xwiki, group, users);
            }
        } else {
            title = targetFullname + " Meeting " + sdf.format(new Date());
            path = this.wikiService_.createIntranetPage(this.remoteUser_, title, xwiki, users);
        }
        return juzu.Response.ok((CharSequence)("{\"status\":\"ok\", \"path\":\"" + path + "\"}")).withMimeType("application/json; charset=UTF-8").withHeader("Cache-Control", new String[]{"no-cache"}).withCharset(Tools.UTF_8);
    }

    public Response.Content createDemoUser(String fullname, String email, String isPublic, String dbName) {
        String username;
        String out = "created";
        boolean isPublicUser = "true".equals(isPublic);
        this.remoteUser_ = username = "__anonim_" + fullname.trim().toLowerCase().replace(" ", "-").replace(".", "-");
        this.token_ = ServerBootstrap.getToken((String)this.remoteUser_);
        this.addUser(this.remoteUser_, this.token_, dbName);
        ServerBootstrap.addUserFullNameAndEmail((String)username, (String)fullname, (String)email, (String)dbName);
        ServerBootstrap.setAsAdmin((String)username, (boolean)false, (String)dbName);
        if (!isPublicUser) {
            this.saveDemoSpace(username, dbName);
        }
        StringBuffer json = new StringBuffer();
        json.append("{ \"username\": \"").append(this.remoteUser_).append("\"");
        json.append(", \"token\": \"").append(this.token_).append("\" }");
        return juzu.Response.ok((CharSequence)json).withMimeType("text/html; charset=UTF-8").withHeader("Cache-Control", new String[]{"no-cache"}).withCharset(Tools.UTF_8);
    }

    protected void addUser(String remoteUser, String token, String dbName) {
        ServerBootstrap.addUser((String)remoteUser, (String)token, (String)dbName);
    }

    protected String saveFullNameAndEmail(String username, String dbName) {
        String fullname = username;
        try {
            User user;
            fullname = ServerBootstrap.getUserFullName((String)username, (String)dbName);
            if ((fullname == null || fullname.isEmpty()) && (user = this.organizationService_.getUserHandler().findUserByName(username)) != null) {
                fullname = user.getFirstName() + " " + user.getLastName();
                ServerBootstrap.addUserFullNameAndEmail((String)username, (String)fullname, (String)user.getEmail(), (String)dbName);
            }
        }
        catch (Exception e) {
            LOG.warning(e.getMessage());
        }
        return fullname;
    }

    protected void setAsAdmin(String username, boolean isAdmin, String dbName) {
        try {
            ServerBootstrap.setAsAdmin((String)username, (boolean)isAdmin, (String)dbName);
        }
        catch (Exception e) {
            LOG.warning(e.getMessage());
        }
    }

    protected void saveSpaces(String username, String dbName) {
        try {
            ListAccess spacesListAccess = this.spaceService_.getAccessibleSpacesWithListAccess(username);
            List<Object> spaces = Arrays.asList(spacesListAccess.load(0, spacesListAccess.getSize()));
            ArrayList<SpaceBean> beans = new ArrayList<SpaceBean>();
            for (Space space : spaces) {
                SpaceBean spaceBean = new SpaceBean();
                spaceBean.setDisplayName(space.getDisplayName());
                spaceBean.setGroupId(space.getGroupId());
                spaceBean.setId(space.getId());
                spaceBean.setShortName(space.getShortName());
                beans.add(spaceBean);
            }
            ServerBootstrap.setSpaces((String)username, (SpaceBeans)new SpaceBeans(beans), (String)dbName);
        }
        catch (Exception e) {
            LOG.warning(e.getMessage());
        }
    }

    protected void saveDemoSpace(String username, String dbName) {
        try {
            ArrayList<SpaceBean> beans = new ArrayList<SpaceBean>();
            SpaceBean spaceBean = new SpaceBean();
            spaceBean.setDisplayName("Welcome Space");
            spaceBean.setGroupId("/public");
            spaceBean.setId("welcome_space");
            spaceBean.setShortName("welcome_space");
            beans.add(spaceBean);
            ServerBootstrap.setSpaces((String)username, (SpaceBeans)new SpaceBeans(beans), (String)dbName);
        }
        catch (Exception e) {
            LOG.warning(e.getMessage());
        }
    }
}

