/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.chat.portlet.notification;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.portlet.PortletPreferences;
import juzu.Path;
import juzu.Response;
import juzu.SessionScoped;
import juzu.View;
import juzu.impl.common.Tools;
import juzu.request.ApplicationContext;
import juzu.request.SecurityContext;
import juzu.request.UserContext;
import juzu.template.Template;
import org.exoplatform.chat.common.utils.ChatUtils;
import org.exoplatform.chat.listener.ServerBootstrap;
import org.exoplatform.chat.model.SpaceBean;
import org.exoplatform.chat.model.SpaceBeans;
import org.exoplatform.chat.portlet.notification.BundleService;
import org.exoplatform.chat.utils.PropertyManager;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.application.RequestNavigationData;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.social.common.router.ExoRouter;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.ws.frameworks.cometd.ContinuationService;

/*
 * Exception performing whole class analysis ignored.
 */
@SessionScoped
public class NotificationApplication {
    private static final Logger LOG = Logger.getLogger(NotificationApplication.class.getName());
    @Inject
    @Path(value="index.gtmpl")
    Template index;
    boolean standaloneChatServer;
    String token_ = "---";
    String remoteUser_ = null;
    boolean profileInitialized_ = false;
    OrganizationService organizationService_;
    SpaceService spaceService_;
    String dbName;
    @Inject
    BundleService bundleService_;
    @Inject
    ContinuationService continuationService;
    @Inject
    Provider<PortletPreferences> providerPreferences;

    @Inject
    public NotificationApplication(OrganizationService organizationService, SpaceService spaceService) {
        this.organizationService_ = organizationService;
        this.spaceService_ = spaceService;
        this.dbName = ChatUtils.getDBName();
        this.standaloneChatServer = Boolean.valueOf(PropertyManager.getProperty((String)"standaloneChatServer"));
    }

    @View
    public Response.Content index(ApplicationContext applicationContext, SecurityContext securityContext, UserContext userContext) throws IOException {
        String chatCometDServerUrl;
        String cometdToken;
        String chatServerURL = PropertyManager.getProperty((String)"chatServerUrl");
        String chatPage = PropertyManager.getProperty((String)"chatPortalPage");
        this.remoteUser_ = securityContext.getRemoteUser();
        String plfUserStatusUpdateUrl = PropertyManager.getProperty((String)"plfUsrStatUpdUrl");
        this.initUserProfile();
        PortletPreferences portletPreferences = (PortletPreferences)this.providerPreferences.get();
        String title = portletPreferences.getValue("title", "---");
        Locale locale = userContext.getLocale();
        ResourceBundle bundle = applicationContext.resolveBundle(locale);
        String messages = this.bundleService_.getBundle("chatBundleData", bundle, locale);
        String spaceId = this.getCurrentSpaceId();
        String portalURI = Util.getPortalRequestContext().getPortalURI();
        if (this.standaloneChatServer) {
            cometdToken = this.token_;
            chatCometDServerUrl = chatServerURL;
        } else {
            cometdToken = this.continuationService.getUserToken(this.remoteUser_);
            chatCometDServerUrl = "/cometd";
        }
        return this.index.with().set("user", (Object)this.remoteUser_).set("token", (Object)this.token_).set("standalone", (Object)this.standaloneChatServer).set("chatCometDServerUrl", (Object)chatCometDServerUrl).set("cometdToken", (Object)cometdToken).set("chatServerURL", (Object)chatServerURL).set("chatPage", (Object)chatPage).set("plfUserStatusUpdateUrl", (Object)plfUserStatusUpdateUrl).set("title", (Object)title).set("messages", (Object)messages).set("spaceId", (Object)spaceId).set("sessionId", (Object)Util.getPortalRequestContext().getRequest().getSession().getId()).set("dbName", (Object)this.dbName).set("portalURI", (Object)portalURI).ok().withCharset(Tools.UTF_8);
    }

    public void initUserProfile() {
        if (!this.profileInitialized_) {
            try {
                this.token_ = ServerBootstrap.getToken((String)this.remoteUser_);
                this.addUser(this.remoteUser_, this.token_, this.dbName);
                this.saveFullNameAndEmail(this.remoteUser_, this.dbName);
                this.saveSpaces(this.remoteUser_, this.dbName);
                this.profileInitialized_ = true;
            }
            catch (Exception e) {
                this.profileInitialized_ = false;
            }
        }
        if (!"__anonim_".equals(this.remoteUser_)) {
            this.saveSpaces(this.remoteUser_, this.dbName);
        }
    }

    protected void addUser(String remoteUser, String token, String dbName) {
        ServerBootstrap.addUser((String)remoteUser, (String)token, (String)dbName);
    }

    protected String saveFullNameAndEmail(String username, String dbName) {
        String fullname = username;
        try {
            fullname = ServerBootstrap.getUserFullName((String)username, (String)dbName);
            if (fullname == null || fullname.isEmpty()) {
                User user = this.organizationService_.getUserHandler().findUserByName(username);
                fullname = user.getFirstName() + " " + user.getLastName();
                ServerBootstrap.addUserFullNameAndEmail((String)username, (String)fullname, (String)user.getEmail(), (String)dbName);
            }
        }
        catch (Exception e) {
            LOG.warning(e.getMessage());
        }
        return fullname;
    }

    protected void saveSpaces(String username, String dbName) {
        try {
            ListAccess spacesListAccess = this.spaceService_.getAccessibleSpacesWithListAccess(username);
            List<Object> spaces = Arrays.asList(spacesListAccess.load(0, spacesListAccess.getSize()));
            ArrayList<SpaceBean> beans = new ArrayList<SpaceBean>();
            for (Space space : spaces) {
                SpaceBean spaceBean = new SpaceBean();
                spaceBean.setDisplayName(space.getDisplayName());
                spaceBean.setGroupId(space.getGroupId());
                spaceBean.setId(space.getId());
                spaceBean.setShortName(space.getShortName());
                beans.add(spaceBean);
            }
            ServerBootstrap.setSpaces((String)username, (SpaceBeans)new SpaceBeans(beans), (String)dbName);
        }
        catch (Exception e) {
            LOG.warning(e.getMessage());
        }
    }

    protected String getCurrentSpaceId() {
        Space currSpace = NotificationApplication.getSpaceByContext();
        if (currSpace != null) {
            return currSpace.getId();
        }
        return "";
    }

    private static Space getSpaceByContext() {
        PortalRequestContext pcontext = Util.getPortalRequestContext();
        String requestPath = pcontext.getControllerContext().getParameter(RequestNavigationData.REQUEST_PATH);
        if (!pcontext.getSiteType().equals((Object)SiteType.GROUP) || !pcontext.getSiteName().startsWith("/spaces")) {
            return null;
        }
        ExoRouter.Route route = ExoRouter.route((String)requestPath);
        if (route == null) {
            return null;
        }
        String spacePrettyName = (String)route.localArgs.get("spacePrettyName");
        SpaceService spaceService = (SpaceService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(SpaceService.class);
        return spaceService.getSpaceByPrettyName(spacePrettyName);
    }
}

