/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.chat.api;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Response;
import org.exoplatform.addons.chat.utils.MessageDigester;
import org.exoplatform.chat.utils.PropertyManager;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.user.UserStateService;
import org.exoplatform.ws.frameworks.cometd.ContinuationService;
import org.json.simple.JSONObject;

@Path(value="/chat/api/1.0/user/")
public class UserRestService
implements ResourceContainer {
    public static final String ANONIM_USER = "__anonim_";
    protected static final String LAST_MODIFIED_PROPERTY = "Last-Modified";
    protected static final String IF_MODIFIED_SINCE_DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss z";

    @GET
    @Path(value="/token/")
    public Response getToken(@QueryParam(value="tokenOnly") String tokenOnly) throws Exception {
        String token;
        boolean withTokenOnly;
        ConversationState conversationState = ConversationState.getCurrent();
        String userId = conversationState.getIdentity().getUserId();
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        SimpleDateFormat dateFormat = new SimpleDateFormat(IF_MODIFIED_SINCE_DATE_FORMAT);
        boolean bl = withTokenOnly = tokenOnly != null && "true".equals(tokenOnly);
        if ("__anonim".equals(userId)) {
            userId = ANONIM_USER;
            token = "---";
        } else {
            String passphrase = PropertyManager.getProperty((String)"chatPassPhrase");
            String in = userId + passphrase;
            token = MessageDigester.getHash(in);
        }
        if (withTokenOnly) {
            return Response.ok((Object)token, (String)"text/plain").cacheControl(cacheControl).header(LAST_MODIFIED_PROPERTY, (Object)dateFormat.format(new Date())).build();
        }
        JSONObject data = new JSONObject();
        data.put((Object)"username", (Object)userId);
        data.put((Object)"token", (Object)token);
        return Response.ok((Object)data.toString(), (String)"application/json").cacheControl(cacheControl).header(LAST_MODIFIED_PROPERTY, (Object)dateFormat.format(new Date())).build();
    }

    @GET
    @Path(value="/cometdToken/")
    @RolesAllowed(value={"users"})
    public Response getCometdToken() throws Exception {
        String token;
        ConversationState conversationState = ConversationState.getCurrent();
        String userId = conversationState.getIdentity().getUserId();
        Boolean standaloneChatServer = Boolean.valueOf(PropertyManager.getProperty((String)"standaloneChatServer"));
        if (standaloneChatServer.booleanValue()) {
            String passphrase = PropertyManager.getProperty((String)"chatPassPhrase");
            String in = userId + passphrase;
            token = MessageDigester.getHash(in);
        } else {
            ContinuationService continuation = (ContinuationService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ContinuationService.class);
            token = continuation.getUserToken(userId);
        }
        return Response.ok((Object)token, (String)"text/plain").build();
    }

    @GET
    @Path(value="/onlineStatus/")
    @RolesAllowed(value={"users"})
    public Response getOnlineStatus(@QueryParam(value="users") String users) throws Exception {
        UserStateService userState = (UserStateService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(UserStateService.class);
        if (users != null) {
            String[] split = users.split(",");
            JSONObject data = new JSONObject();
            for (String u : split) {
                data.put((Object)u, (Object)userState.isOnline(u));
            }
            return Response.ok((Object)data.toString(), (String)"application/json").build();
        }
        return Response.serverError().status(400).build();
    }

    @GET
    @Path(value="/onlineUsers/")
    @RolesAllowed(value={"users"})
    public Response getOnlineUsers() throws Exception {
        UserStateService userState = (UserStateService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(UserStateService.class);
        List list = userState.online().stream().map(u -> u.getUserId()).collect(Collectors.toList());
        String users = String.join((CharSequence)",", list);
        return Response.ok((Object)users, (String)"text/plain").build();
    }
}

