/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.chat.service;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.security.RolesAllowed;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.wiki.mow.api.Page;
import org.exoplatform.wiki.mow.api.Permission;
import org.exoplatform.wiki.mow.api.PermissionEntry;
import org.exoplatform.wiki.mow.api.PermissionType;
import org.exoplatform.wiki.mow.api.Wiki;
import org.exoplatform.wiki.resolver.TitleResolver;
import org.exoplatform.wiki.service.IDType;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

@Path(value="/chat/api/1.0/wiki/")
public class WikiService
implements ResourceContainer {
    org.exoplatform.wiki.service.WikiService wikiService_;
    private static final Logger LOG = Logger.getLogger("WikiService");
    public static final String ANY = "any".intern();

    public WikiService(org.exoplatform.wiki.service.WikiService wikiService) {
        this.wikiService_ = wikiService;
    }

    @POST
    @Path(value="/saveWiki")
    @RolesAllowed(value={"users"})
    public Response saveWiki(@Context HttpServletRequest request, @Context SecurityContext sc, @FormParam(value="targetFullname") String targetFullname, @FormParam(value="content") String content) throws Exception {
        SpaceService spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
        String currentUser = sc.getUserPrincipal().getName();
        SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy HH-mm");
        String group = null;
        String title = null;
        String path = "";
        JSONObject jsonObject = (JSONObject)JSONValue.parse((String)content);
        String typeRoom = (String)jsonObject.get((Object)"typeRoom");
        String wikiPageContent = (String)jsonObject.get((Object)"wikiPageContent");
        ArrayList users = (ArrayList)jsonObject.get((Object)"users");
        if ("s".equalsIgnoreCase(typeRoom)) {
            Space spaceBean = spaceService.getSpaceByDisplayName(targetFullname);
            if (spaceBean != null) {
                group = spaceBean.getGroupId();
                if (group.startsWith("/")) {
                    group = group.substring(1);
                }
                title = "Meeting " + sdf.format(new Date());
                path = this.createSpacePage(currentUser, title, wikiPageContent, group, users);
            }
        } else {
            title = targetFullname + " Meeting " + sdf.format(new Date());
            path = this.createIntranetPage(currentUser, title, wikiPageContent, users);
        }
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        JSONObject data = new JSONObject();
        data.put((Object)"status", (Object)"ok");
        data.put((Object)"path", (Object)path);
        return Response.ok((Object)data.toString(), (String)"application/json").cacheControl(cacheControl).build();
    }

    protected String createIntranetPage(String creator, String title, String content, ArrayList<String> users) {
        return this.createOrEditPage(creator, "Meeting Notes", title, content, users, false, null);
    }

    protected String createSpacePage(String creator, String title, String content, String spaceGroupId, ArrayList<String> users) {
        return this.createOrEditPage(creator, "Meeting Notes", title, content, users, false, spaceGroupId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createOrEditPage(String creator, String parentTitle, String title, String content, ArrayList<String> users, boolean forceNew, String spaceGroupId) {
        Object wikiOwner;
        String wikiType = PortalConfig.PORTAL_TYPE;
        if (spaceGroupId != null) {
            wikiType = PortalConfig.GROUP_TYPE;
            wikiOwner = "/" + spaceGroupId;
        } else {
            wikiOwner = CommonsUtils.getCurrentSite().getName();
        }
        Object path = "";
        try {
            org.exoplatform.wiki.service.WikiService wikiService = this.wikiService_;
            synchronized (wikiService) {
                Page ppage = this.wikiService_.getPageOfWikiByName(wikiType, (String)wikiOwner, TitleResolver.getId((String)parentTitle, (boolean)false));
                if (ppage == null) {
                    ppage = new Page();
                    ppage.setTitle(parentTitle);
                    ppage.setContent("<h1>" + parentTitle + "</h1>\n");
                    ppage.setSyntax("xhtml/1.0");
                    Wiki wiki = this.wikiService_.getWikiByTypeAndOwner(wikiType, (String)wikiOwner);
                    if (wiki == null) {
                        wiki = this.wikiService_.createWiki(wikiType, (String)wikiOwner);
                    }
                    Page wikiHome = wiki.getWikiHome();
                    this.setPermissionForReportAsWiki(Collections.emptyList(), ppage, wikiHome);
                    List permissions = ppage.getPermissions();
                    permissions.add(new PermissionEntry(ANY, "", IDType.USER, new Permission[]{new Permission(PermissionType.VIEWPAGE, true)}));
                    ppage.setPermissions(permissions);
                    Wiki pwiki = new Wiki();
                    pwiki.setOwner((String)wikiOwner);
                    pwiki.setType(wikiType);
                    ppage = this.wikiService_.createPage(pwiki, "WikiHome", ppage);
                    permissions = ppage.getPermissions();
                    for (int i = 0; i < permissions.size(); ++i) {
                        PermissionEntry permission = (PermissionEntry)permissions.get(i);
                        if (!creator.equals(permission.getId())) continue;
                        permissions.remove(i);
                    }
                    ppage.setPermissions(permissions);
                    this.wikiService_.updatePage(ppage, null);
                }
                Page page = new Page();
                page.setTitle(title);
                page.setContent(content);
                page.setSyntax("xhtml/1.0");
                this.setPermissionForReportAsWiki(users, page, ppage);
                page.setOwner(creator);
                page.setAuthor(creator);
                page.setMinorEdit(false);
                if (wikiType.equals(PortalConfig.GROUP_TYPE)) {
                    path = "/wiki/" + wikiType + (String)wikiOwner + "/" + TitleResolver.getId((String)title, (boolean)false);
                } else if (wikiType.equals(PortalConfig.PORTAL_TYPE)) {
                    path = "/" + PortalContainer.getInstance().getName() + "/" + (String)wikiOwner + "/wiki/" + TitleResolver.getId((String)title, (boolean)false);
                }
                page.setUrl((String)path);
                Wiki wiki = new Wiki();
                wiki.setOwner((String)wikiOwner);
                wiki.setType(wikiType);
                if (this.wikiService_.isExisting(wikiType, (String)wikiOwner, TitleResolver.getId((String)title, (boolean)false))) {
                    this.wikiService_.getPageById(TitleResolver.getId((String)title, (boolean)false));
                } else {
                    try {
                        this.wikiService_.createPage(wiki, TitleResolver.getId((String)parentTitle, (boolean)false), page);
                    }
                    catch (Exception e) {
                        this.wikiService_.getPageById(TitleResolver.getId((String)title, (boolean)false));
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Unknown exception", e);
        }
        return path;
    }

    public void setPermissionForReportAsWiki(List<String> users, Page page, Page parentPage) {
        try {
            Permission[] allPermissions = new Permission[]{new Permission(PermissionType.VIEWPAGE, true), new Permission(PermissionType.EDITPAGE, true)};
            List permissions = parentPage.getPermissions();
            if (permissions != null) {
                int i;
                int anyIndex = -1;
                for (i = 0; i < permissions.size(); ++i) {
                    PermissionEntry any = (PermissionEntry)permissions.get(i);
                    if (!ANY.equals(any.getId())) continue;
                    anyIndex = i;
                }
                if (anyIndex > -1) {
                    permissions.remove(anyIndex);
                }
                for (i = 0; i < users.size(); ++i) {
                    String strUser = users.get(i).toString();
                    PermissionEntry userPermission = new PermissionEntry(strUser, strUser, IDType.USER, allPermissions);
                    permissions.add(userPermission);
                }
                page.setPermissions(permissions);
            }
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Unknown exception", e);
        }
    }
}

